/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import org.simantics.db.ChangeSet.StatementChange;
import org.simantics.db.Resource;

/**
 * Intentionally implements hashCode and equals so that the {@link #claim}
 * field is not counted as an ID of this instance.
 * 
 * @author Tuukka Lehtonen
 */
final class StatementChangeImpl implements StatementChange {

    private final Resource s;
    private final Resource p;
    private final Resource o;

    /**
     * Intentionally left package-modifiable through {@link #setClaim(boolean)}
     * as an implementation-internal optimization by allowing reuse of the same
     * StatementChangeImpl instance.
     */
    private boolean claim;

    public StatementChangeImpl(final SessionImplSocket session, final int s, final int p, final int o, boolean claim) {
        this.s = session.getResource(s);
        this.p = session.getResource(p);
        this.o = session.getResource(o);
        this.claim = claim;
    }
    public StatementChangeImpl(final Resource s, final Resource p, final Resource o, boolean claim) {
        this.s = s;
        this.p = p;
        this.o = o;
        this.claim = claim;
    }

    @Override
    public Resource getObject() {
        return o;
    }

    @Override
    final public Resource getPredicate() {
        return p;
    }

    @Override
    final public Resource getSubject() {
        return s;
    }

    void setClaim(boolean claim) {
        this.claim = claim;
    }

    public boolean isClaim() {
        return claim;
    }

    @Override
    public boolean isAsserted(Resource testSubject) {
    	return !s.equals(testSubject);
    }

    @Override
    public int hashCode() {
        return hashCode(s, p, o);
    }
    
    public static int hashCode(Resource s, Resource p, Resource o) {
        return 41 * ( 31 * s.hashCode() + p.hashCode()) + o.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (StatementChangeImpl.class != object.getClass())
            return false;
        StatementChangeImpl r = (StatementChangeImpl) object;
        return getSubject().equals(r.getSubject())
        && getPredicate().equals(r.getPredicate())
        && getObject().equals(r.getObject());
    }
}

