/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import gnu.trove.list.array.TIntArrayList;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.simantics.db.DirectStatements;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.ResourceSupport;

final public class DirectStatementsImpl implements DirectStatements {

    final ResourceSupport support;
    final int subject;
    final TIntArrayList statements = new TIntArrayList();
    
    DirectStatementsImpl(ResourceSupport support, int subject) {
        this.support = support;
        this.subject = subject;
    }
    
    void addStatement(int p, int o) {
        statements.add(p);
        statements.add(o);
    }
    
    @Override
    public Resource getSubject() {
        return new ResourceImpl(support, subject);
    }

    @Override
    public boolean add(Statement arg0) {
        throw new Error("Not supported");
    }

    @Override
    public boolean addAll(Collection<? extends Statement> arg0) {
        throw new Error("Not supported");
    }

    @Override
    public void clear() {
        throw new Error("Not supported");
    }

    @Override
    public boolean contains(Object arg0) {
        Statement stm = (Statement)arg0;
        ResourceImpl p = (ResourceImpl)stm.getPredicate();
        ResourceImpl o = (ResourceImpl)stm.getObject();
        for(int i=0;i<statements.size();i+=2) {
            int pi = statements.getQuick(i);
            int oi = statements.getQuick(i+1);
            if(p.id == pi && o.id == oi) return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new Error("Not supported");
    }

    @Override
    public boolean isEmpty() {
        throw new Error("Not supported");
    }

    @Override
    public Iterator<Statement> iterator() {
        return new Iterator<Statement>() {

            int index = 0;
            int max = statements.size();
            
            @Override
            public boolean hasNext() {
                return index < max; 
            }

            @Override
            public Statement next() {
                return new DirectStatementImpl(support, subject, statements.getQuick(index++), statements.getQuick(index++));
            }

            @Override
            public void remove() {
                throw new Error("Not supported");
            }
            
        };
    }

    @Override
    public boolean remove(Object arg0) {
        throw new Error("Not supported");
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new Error("Not supported");
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new Error("Not supported");
    }

    @Override
    public int size() {
        return statements.size() >> 1;
    }

    @Override
    public Object[] toArray() {
        throw new Error("Not supported");
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new Error("Not supported");
    }

    @Override
    public void add(int index, Statement element) {
        throw new Error("Not supported");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Statement> c) {
        throw new Error("Not supported");
    }

    @Override
    public Statement get(int index_) {
        int index = 2*index_;
        return new DirectStatementImpl(support, subject, statements.getQuick(index), statements.getQuick(index+1));
    }

    @Override
    public int indexOf(Object o) {
        throw new Error("Not supported");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new Error("Not supported");
    }

    @Override
    public ListIterator<Statement> listIterator() {
        throw new Error("Not supported");
    }

    @Override
    public ListIterator<Statement> listIterator(int index) {
        throw new Error("Not supported");
    }

    @Override
    public Statement remove(int index) {
        throw new Error("Not supported");
    }

    @Override
    public Statement set(int index, Statement element) {
        throw new Error("Not supported");
    }

    @Override
    public List<Statement> subList(int fromIndex, int toIndex) {
        throw new Error("Not supported");
    }
    
}
