/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkCamera;
import vtk.vtkRenderer;

public class ParallelPerspectiveHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        final boolean activate = !oldValue;
        IEditorPart ap = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        final VtkView panel = (VtkView)ap.getAdapter(VtkView.class);
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkRenderer ren = panel.getRenderer();
                vtkCamera cam = ren.GetActiveCamera();
                if (activate) {
                    double distance = cam.GetDistance();
                    double angle = cam.GetViewAngle();
                    double scale = Math.tan(Math.toRadians(angle / 2.0)) * distance;
                    cam.SetParallelScale(scale);
                    cam.SetParallelProjection(1);
                    ren.ResetCameraClippingRange();
                } else {
                    cam.SetParallelProjection(0);
                    ren.ResetCameraClippingRange();
                }
                panel.refresh();
            }
        });
        return null;
    }
}

