/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalShortCharMapOps;
import com.koloboke.collect.map.ShortCharMap;
import com.koloboke.function.ShortCharConsumer;
import com.koloboke.function.ShortCharPredicate;
import java.util.Map;

public final class CommonShortCharMapOps {
    public static boolean containsAllEntries(final InternalShortCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortCharMap) {
            ShortCharMap m2 = (ShortCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortCharMapOps) {
                return ((InternalShortCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortCharPredicate(){

                public boolean test(short a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortCharMapOps map, Map<? extends Short, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortCharMap) {
            if (another instanceof InternalShortCharMapOps) {
                ((InternalShortCharMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortCharMap)another).forEach(new ShortCharConsumer(){

                    public void accept(short key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonShortCharMapOps() {
    }
}

