/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package (and its subpackages) contain internal implementations. These
 * classes should <em>not</em> be accessed directly (treat them like {@code com.sun} classes).
 *
 * <p>Advice: exclude this package and all subpackages from the auto-complete in your favourite IDE:
 * <a href="http://www.jetbrains.com/idea/webhelp/excluding-classes-from-auto-import.html">IDEA</a>,
 * <a href="http://stackoverflow.com/q/2073913/648955">Eclipse</a>, etc.
 *
 * <p>Annotation {@link javax.annotation.ParametersAreNonnullByDefault} on this package added to
 * suppress warnings in API about not annotated method implementations. It doesn't mean that all
 * parameters in the package are really nonnull by default.
 */
@javax.annotation.ParametersAreNonnullByDefault
package com.koloboke.collect.impl;