/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongShortMap}s.
 *
 * @see HashLongShortMap
 * @see HashLongShortMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashLongShortMapFactory
        extends LongShortMapFactory<HashLongShortMapFactory>
        , LongHashFactory<HashLongShortMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongShortMap newMutableMap();

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4,
            @Nonnull Map<Long, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(
            @Nonnull long[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(
            @Nonnull Map<Long, Short> map);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4,
            @Nonnull Map<Long, Short> map5);



    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(
            @Nonnull long[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashLongShortMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashLongShortMap newMutableMapOf(long k1, short v1);

    @Override
    @Nonnull
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2);

    @Override
    @Nonnull
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

    @Override
    @Nonnull
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

    @Override
    @Nonnull
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);
    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4,
            @Nonnull Map<Long, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(
            @Nonnull Map<Long, Short> map);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4,
            @Nonnull Map<Long, Short> map5);



    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashLongShortMap newUpdatableMapOf(long k1, short v1);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

    @Override
    @Nonnull
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);

    


    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4,
            @Nonnull Map<Long, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(
            @Nonnull Map<Long, Short> map);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Map<Long, Short> map1,
            @Nonnull Map<Long, Short> map2,
            @Nonnull Map<Long, Short> map3,
            @Nonnull Map<Long, Short> map4,
            @Nonnull Map<Long, Short> map5);



    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashLongShortMap newImmutableMapOf(long k1, short v1);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

    @Override
    @Nonnull
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);
}
