/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatLongMap}s.
 *
 * @see HashFloatLongMap
 * @see HashFloatLongMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashFloatLongMapFactory
        extends FloatLongMapFactory<HashFloatLongMapFactory>
        , HashContainerFactory<HashFloatLongMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatLongMap newMutableMap();

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4,
            @Nonnull Map<Float, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(
            @Nonnull float[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(
            @Nonnull Map<Float, Long> map);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4,
            @Nonnull Map<Float, Long> map5);



    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(
            @Nonnull float[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashFloatLongMap newMutableMapOf(float k1, long v1);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

    @Override
    @Nonnull
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);
    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4,
            @Nonnull Map<Float, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(
            @Nonnull Map<Float, Long> map);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4,
            @Nonnull Map<Float, Long> map5);



    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMapOf(float k1, long v1);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

    @Override
    @Nonnull
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);

    


    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4,
            @Nonnull Map<Float, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(
            @Nonnull Map<Float, Long> map);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Map<Float, Long> map1,
            @Nonnull Map<Float, Long> map2,
            @Nonnull Map<Float, Long> map3,
            @Nonnull Map<Float, Long> map4,
            @Nonnull Map<Float, Long> map5);



    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashFloatLongMap newImmutableMapOf(float k1, long v1);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

    @Override
    @Nonnull
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);
}
