/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatByteMap}s.
 *
 * @see HashFloatByteMap
 * @see HashFloatByteMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashFloatByteMapFactory
        extends FloatByteMapFactory<HashFloatByteMapFactory>
        , HashContainerFactory<HashFloatByteMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatByteMap newMutableMap();

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4,
            @Nonnull Map<Float, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(
            @Nonnull float[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(
            @Nonnull Map<Float, Byte> map);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4,
            @Nonnull Map<Float, Byte> map5);



    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(
            @Nonnull float[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashFloatByteMap newMutableMapOf(float k1, byte v1);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

    @Override
    @Nonnull
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);
    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4,
            @Nonnull Map<Float, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(
            @Nonnull Map<Float, Byte> map);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4,
            @Nonnull Map<Float, Byte> map5);



    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

    @Override
    @Nonnull
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);

    


    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4,
            @Nonnull Map<Float, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(
            @Nonnull Map<Float, Byte> map);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Map<Float, Byte> map1,
            @Nonnull Map<Float, Byte> map2,
            @Nonnull Map<Float, Byte> map3,
            @Nonnull Map<Float, Byte> map4,
            @Nonnull Map<Float, Byte> map5);



    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashFloatByteMap newImmutableMapOf(float k1, byte v1);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

    @Override
    @Nonnull
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);
}
