/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import java.net.IDN;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class HostNameVerifier {
    private static final Logger logger = Logger.getLogger(HostNameVerifier.class.getName());
    private static final int SAN_TYPE_DNS_NAME = 2;
    private static final int SAN_TYPE_IP_ADDRESS = 7;
    private static final Comparator<String> specificHostNameComparator = new Comparator<String>(){

        private int countChars(String value, char ch) {
            int count = 0;
            int pos = -1;
            while ((pos = value.indexOf(ch, pos + 1)) != -1) {
                ++count;
            }
            return count;
        }

        @Override
        public int compare(String o1, String o2) {
            int l2;
            int s2;
            int d2;
            int d1 = this.countChars(o1, '.');
            if (d1 != (d2 = this.countChars(o2, '.'))) {
                return d1 > d2 ? 1 : -1;
            }
            int s1 = this.countChars(o1, '*');
            if (s1 != (s2 = this.countChars(o2, '*'))) {
                return s1 < s2 ? 1 : -1;
            }
            int l1 = o1.length();
            if (l1 != (l2 = o2.length())) {
                return l1 > l2 ? 1 : -1;
            }
            return 0;
        }
    };

    public static void verifyHostName(String hostName, SSLSession sslSession) throws SSLPeerUnverifiedException {
        X509Certificate[] peerCertificates = (X509Certificate[])sslSession.getPeerCertificates();
        if (peerCertificates == null || peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates for hostname verification");
        }
        HostNameVerifier.verifyHostName(hostName, peerCertificates[0]);
    }

    public static void verifyHostName(String hostName, X509Certificate serverCertificate) throws SSLPeerUnverifiedException {
        String commonName;
        LdapName subject;
        String canonicalHostName;
        if (hostName.startsWith("[") && hostName.endsWith("]")) {
            canonicalHostName = hostName.substring(1, hostName.length() - 1);
        } else {
            try {
                canonicalHostName = IDN.toASCII(hostName);
            }
            catch (IllegalArgumentException e) {
                String failMessage = String.format("Hostname '%s' is invalid", hostName);
                throw new SSLPeerUnverifiedException(failMessage);
            }
        }
        logger.log(Level.FINE, "Translated hostname {0} to canonical hostname {1}", new Object[]{hostName, canonicalHostName});
        Collection<List<?>> subjectAltNameEntries = null;
        try {
            subjectAltNameEntries = serverCertificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException failMessage) {
            // empty catch block
        }
        if (subjectAltNameEntries == null) {
            subjectAltNameEntries = Collections.emptyList();
        }
        boolean subjectAltNamesContainsDNSName = false;
        for (List<?> subjectAltNameEntry : subjectAltNameEntries) {
            Object subjectAltNameType;
            if (subjectAltNameEntry.size() != 2 || (Integer)(subjectAltNameType = (Integer)subjectAltNameEntry.get(0)) != 7 && (Integer)subjectAltNameType != 2) continue;
            String subjectAltNameValue = (String)subjectAltNameEntry.get(1);
            if ((Integer)subjectAltNameType == 7 && subjectAltNameValue != null && subjectAltNameValue.contains("*")) continue;
            subjectAltNamesContainsDNSName |= (Integer)subjectAltNameType == 2;
            if (!HostNameVerifier.matchHostName(canonicalHostName, subjectAltNameValue)) continue;
            logger.log(Level.FINE, "Matched Subject Alternate Name to '{0}'", hostName);
            return;
        }
        if (subjectAltNamesContainsDNSName) {
            logger.log(Level.SEVERE, "Aborting host name verification due to mismatching DNS Subject Alternate Name", hostName);
            String failMessage = String.format("Failed to match hostname '%s' against DNS Subject Alternate Name", hostName);
            throw new SSLPeerUnverifiedException(failMessage);
        }
        try {
            subject = new LdapName(serverCertificate.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException e) {
            throw new SSLPeerUnverifiedException("Certificate contains invalid subject");
        }
        ArrayList<String> commonNames = new ArrayList<String>(1);
        for (Rdn rdn : subject.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            commonNames.add((String)rdn.getValue());
        }
        if (commonNames.isEmpty()) {
            throw new SSLPeerUnverifiedException("Certificate subject missing common name");
        }
        if (commonNames.size() > 1) {
            commonNames.sort(specificHostNameComparator);
        }
        if (!HostNameVerifier.matchHostName(canonicalHostName, commonName = (String)commonNames.get(commonNames.size() - 1))) {
            String failMessage = String.format("Hostname '%s' could not be verified", hostName);
            throw new SSLPeerUnverifiedException(failMessage);
        }
    }

    public static boolean matchHostName(String hostName, String patternName) {
        if (hostName == null || patternName == null) {
            return false;
        }
        int lastWildCard = patternName.lastIndexOf(42);
        if (lastWildCard == -1) {
            return hostName.equalsIgnoreCase(patternName);
        }
        if (lastWildCard > 0 || patternName.indexOf(46) == -1 || hostName.length() < patternName.length() - 1) {
            return false;
        }
        int nonWildcardComparisonOffset = hostName.length() - patternName.length() + 1;
        if (hostName.lastIndexOf(46, nonWildcardComparisonOffset - 1) >= 0) {
            return false;
        }
        return hostName.regionMatches(true, nonWildcardComparisonOffset, patternName, 1, patternName.length() - 1);
    }
}

