/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.CopyFormat;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CopyInRequest
implements ServerRequest {
    private String sql;
    private InputStream stream;
    private RequestExecutor.CopyFromHandler handler;
    private List<Notice> notices;

    CopyInRequest(String sql, InputStream stream, RequestExecutor.CopyFromHandler handler) {
        this.sql = sql;
        this.stream = stream;
        this.handler = handler;
        this.notices = new ArrayList<Notice>();
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeQuery(this.sql).flush();
    }

    private class Handler
    implements ProtocolHandler.CopyInResponse,
    ProtocolHandler.RowDescription,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.ReadyForQuery {
        boolean started = false;

        private Handler() {
        }

        @Override
        public InputStream copyIn(CopyFormat format, FieldFormat[] columnFormats) {
            this.started = true;
            return CopyInRequest.this.stream;
        }

        @Override
        public ProtocolHandler.Action rowDescription(ResultField[] fields) {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            CopyInRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            if (!this.started) {
                CopyInRequest.this.handler.handleError(new IOException("Command Not Initiated: COPY IN"), CopyInRequest.this.notices);
            } else {
                CopyInRequest.this.handler.handleComplete();
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action error(Notice notice) throws IOException {
            CopyInRequest.this.handler.handleError(new NoticeException(notice), CopyInRequest.this.notices);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            CopyInRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            CopyInRequest.this.handler.handleError(cause, CopyInRequest.this.notices);
        }
    }
}

