/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.collections.impl.factory.Maps;
import org.simantics.utils.datastructures.hints.AbstractHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext;

public class HintContext
extends AbstractHintObservable
implements IHintContext,
Cloneable {
    protected Map<IHintContext.Key, Object> hints = Maps.mutable.empty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWithoutNotification() {
        HintContext hintContext = this;
        synchronized (hintContext) {
            this.hints.clear();
        }
    }

    @Override
    public synchronized boolean containsHint(IHintContext.Key key) {
        return this.hints.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E getHint(IHintContext.Key key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        HintContext hintContext = this;
        synchronized (hintContext) {
            return (E)this.hints.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E removeHint(IHintContext.Key key) {
        Runnable notification;
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Object oldValue = null;
        HintContext hintContext = this;
        synchronized (hintContext) {
            block5: {
                oldValue = this.hints.remove(key);
                if (oldValue != null) break block5;
                return null;
            }
            notification = this.createFireKeyRemovedRunnable(this, key, oldValue);
        }
        notification.run();
        return (E)oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHints(Collection<? extends IHintContext.Key> keys) {
        ArrayList<Runnable> notifications = new ArrayList<Runnable>(this.hints.size());
        HintContext hintContext = this;
        synchronized (hintContext) {
            for (IHintContext.Key key : keys) {
                Object oldValue = this.hints.remove(key);
                if (oldValue == null) continue;
                Runnable notification = this.createFireKeyRemovedRunnable(this, key, oldValue);
                notifications.add(notification);
            }
        }
        for (Runnable r : notifications) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHint(IHintContext.Key key, Object value) {
        Runnable notification;
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!key.isValueAccepted(value)) {
            throw new RuntimeException("Value \"" + String.valueOf(value) + "\" is not accepted with key " + key.getClass().getName());
        }
        HintContext hintContext = this;
        synchronized (hintContext) {
            Object oldValue = this.hints.put(key, value);
            notification = this.createFireKeyChangedRunnable(this, key, oldValue, value);
        }
        notification.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHints(Map<IHintContext.Key, Object> hints) {
        ArrayList<Runnable> notifications = new ArrayList<Runnable>(hints.size());
        HintContext hintContext = this;
        synchronized (hintContext) {
            for (Map.Entry<IHintContext.Key, Object> e : hints.entrySet()) {
                IHintContext.Key key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    throw new IllegalArgumentException("a value is null for key " + String.valueOf(e.getKey()));
                }
                Object oldValue = this.hints.put(key, value);
                Runnable notification = this.createFireKeyChangedRunnable(this, key, oldValue, value);
                notifications.add(notification);
            }
        }
        for (Runnable r : notifications) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setHintWithoutNotification(IHintContext.Key key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (!key.isValueAccepted(value)) {
            throw new RuntimeException("Value \"" + String.valueOf(value) + "\" is not accepted with key " + key.getClass().getName());
        }
        HintContext hintContext = this;
        synchronized (hintContext) {
            return this.hints.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E removeHintWithoutNotification(IHintContext.Key key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Object oldValue = null;
        HintContext hintContext = this;
        synchronized (hintContext) {
            oldValue = this.hints.remove(key);
        }
        return (E)oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceHintsWithoutNotification(Map<IHintContext.Key, Object> hints) {
        HashMap<IHintContext.Key, Object> copy = new HashMap<IHintContext.Key, Object>(hints);
        HintContext hintContext = this;
        synchronized (hintContext) {
            this.hints = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceHints(Map<IHintContext.Key, Object> newHints) {
        ArrayList<Runnable> notifications = new ArrayList<Runnable>(Math.max(this.hints.size(), newHints.size()));
        HintContext hintContext = this;
        synchronized (hintContext) {
            HashSet<IHintContext.Key> removedKeys = new HashSet<IHintContext.Key>(this.hints.keySet());
            removedKeys.removeAll(newHints.keySet());
            for (IHintContext.Key key : removedKeys) {
                Object oldValue = this.hints.remove(key);
                if (oldValue == null) continue;
                Runnable notification = this.createFireKeyRemovedRunnable(this, key, oldValue);
                notifications.add(notification);
            }
            for (Map.Entry entry : newHints.entrySet()) {
                IHintContext.Key key = (IHintContext.Key)entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    throw new IllegalArgumentException("a value is null for key " + String.valueOf(entry.getKey()));
                }
                Object oldValue = this.hints.put(key, value);
                if (value.equals(oldValue)) continue;
                Runnable notification = this.createFireKeyChangedRunnable(this, key, oldValue, value);
                notifications.add(notification);
            }
        }
        for (Runnable r : notifications) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHintsWithoutNotification(Map<IHintContext.Key, Object> hints) {
        HintContext hintContext = this;
        synchronized (hintContext) {
            for (Map.Entry<IHintContext.Key, Object> e : hints.entrySet()) {
                IHintContext.Key key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    throw new IllegalArgumentException("a value is null for key " + String.valueOf(e.getKey()));
                }
                this.hints.put(key, value);
            }
        }
    }

    public static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public synchronized Map<IHintContext.Key, Object> getHints() {
        return new HashMap<IHintContext.Key, Object>(this.hints);
    }

    @Override
    public Map<IHintContext.Key, Object> getHintsUnsafe() {
        return this.hints;
    }

    @Override
    public synchronized <E extends IHintContext.Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        HashMap<IHintContext.Key, Object> result = new HashMap<IHintContext.Key, Object>();
        for (Map.Entry<IHintContext.Key, Object> e : this.hints.entrySet()) {
            IHintContext.Key key = e.getKey();
            if (!clazz.isAssignableFrom(key.getClass())) continue;
            result.put(key, e.getValue());
        }
        return result;
    }

    public synchronized int size() {
        return this.hints.size();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

