/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.collections;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

public class QuadTree<T> {
    Point2D center;
    Set<T> contains;
    double width;
    double height;
    boolean leaf;
    QuadTree<T> pXpY;
    QuadTree<T> nXpY;
    QuadTree<T> pXnY;
    QuadTree<T> nXnY;

    public QuadTree(Point2D center, double width, double height, int depth) {
        this.center = center;
        this.width = width;
        this.height = height;
        this.leaf = true;
        this.split(depth);
    }

    private QuadTree(Point2D center, double width, double height) {
        this.center = center;
        this.width = width;
        this.height = height;
        this.leaf = true;
    }

    public void insert(T object, Rectangle2D bounds) {
        if (this.leaf) {
            this.contains.add(object);
        } else {
            boolean nY;
            boolean pX = bounds.getMinX() > this.center.getX();
            boolean nX = bounds.getMaxX() < this.center.getX();
            boolean pY = bounds.getMinY() > this.center.getY();
            boolean bl = nY = bounds.getMaxY() < this.center.getY();
            if (pX) {
                if (pY) {
                    this.pXpY.insert(object, bounds);
                } else if (nY) {
                    this.pXnY.insert(object, bounds);
                } else {
                    this.pXpY.insert(object, bounds);
                    this.pXnY.insert(object, bounds);
                }
            } else if (nX) {
                if (pY) {
                    this.nXpY.insert(object, bounds);
                } else if (nY) {
                    this.nXnY.insert(object, bounds);
                } else {
                    this.nXpY.insert(object, bounds);
                    this.nXnY.insert(object, bounds);
                }
            } else if (pY) {
                this.pXpY.insert(object, bounds);
                this.nXpY.insert(object, bounds);
            } else if (nY) {
                this.pXnY.insert(object, bounds);
                this.nXnY.insert(object, bounds);
            } else {
                this.pXpY.insert(object, bounds);
                this.pXnY.insert(object, bounds);
                this.nXpY.insert(object, bounds);
                this.nXnY.insert(object, bounds);
            }
        }
    }

    public void remove(T object) {
        if (this.leaf) {
            this.contains.remove(object);
        } else {
            this.pXpY.remove(object);
            this.pXnY.remove(object);
            this.nXpY.remove(object);
            this.nXnY.remove(object);
        }
    }

    public void remove(T object, Rectangle2D bounds) {
        if (this.leaf) {
            this.contains.remove(object);
        } else {
            boolean nY;
            boolean pX = bounds.getMinX() > this.center.getX();
            boolean nX = bounds.getMaxX() < this.center.getX();
            boolean pY = bounds.getMinY() > this.center.getY();
            boolean bl = nY = bounds.getMaxY() < this.center.getY();
            if (pX) {
                if (pY) {
                    this.pXpY.remove(object, bounds);
                } else if (nY) {
                    this.pXnY.remove(object, bounds);
                } else {
                    this.pXpY.remove(object, bounds);
                    this.pXnY.remove(object, bounds);
                }
            } else if (nX) {
                if (pY) {
                    this.nXpY.remove(object, bounds);
                } else if (nY) {
                    this.nXnY.remove(object, bounds);
                } else {
                    this.nXpY.remove(object, bounds);
                    this.nXnY.remove(object, bounds);
                }
            } else if (pY) {
                this.pXpY.remove(object, bounds);
                this.nXpY.remove(object, bounds);
            } else if (nY) {
                this.pXnY.remove(object, bounds);
                this.nXnY.remove(object, bounds);
            } else {
                this.pXpY.remove(object, bounds);
                this.pXnY.remove(object, bounds);
                this.nXpY.remove(object, bounds);
                this.nXnY.remove(object, bounds);
            }
        }
    }

    public boolean contains(T object) {
        if (this.leaf) {
            return this.contains.contains(object);
        }
        return this.pXnY.contains(object) || this.pXpY.contains(object) || this.nXnY.contains(object) || this.nXpY.contains(object);
    }

    public void get(Rectangle2D bounds, Set<T> set) {
        if (this.leaf) {
            set.addAll(this.contains);
        } else {
            boolean nY;
            boolean pX = bounds.getMinX() > this.center.getX();
            boolean nX = bounds.getMaxX() < this.center.getX();
            boolean pY = bounds.getMinY() > this.center.getY();
            boolean bl = nY = bounds.getMaxY() < this.center.getY();
            if (pX) {
                if (pY) {
                    this.pXpY.get(bounds, set);
                } else if (nY) {
                    this.pXnY.get(bounds, set);
                } else {
                    this.pXpY.get(bounds, set);
                    this.pXnY.get(bounds, set);
                }
            } else if (nX) {
                if (pY) {
                    this.nXpY.get(bounds, set);
                } else if (nY) {
                    this.nXnY.get(bounds, set);
                } else {
                    this.nXpY.get(bounds, set);
                    this.nXnY.get(bounds, set);
                }
            } else if (pY) {
                this.pXpY.get(bounds, set);
                this.nXpY.get(bounds, set);
            } else if (nY) {
                this.pXnY.get(bounds, set);
                this.nXnY.get(bounds, set);
            } else {
                this.pXpY.get(bounds, set);
                this.pXnY.get(bounds, set);
                this.nXpY.get(bounds, set);
                this.nXnY.get(bounds, set);
            }
        }
    }

    public void clear() {
        if (this.leaf) {
            this.contains.clear();
        } else {
            this.pXpY.clear();
            this.pXnY.clear();
            this.nXpY.clear();
            this.nXnY.clear();
        }
    }

    private void split(int depth) {
        if (!this.leaf) {
            throw new IllegalStateException("Node is already split");
        }
        if (depth <= 0) {
            this.contains = new HashSet<T>();
            return;
        }
        this.split();
        this.pXpY.split(--depth);
        this.nXpY.split(depth);
        this.pXnY.split(depth);
        this.nXnY.split(depth);
    }

    private void split() {
        double w = this.width * 0.5;
        double h = this.height * 0.5;
        double wd2 = w * 0.5;
        double hd2 = h * 0.5;
        this.pXpY = new QuadTree<T>(new Point2D.Double(this.center.getX() + wd2, this.center.getY() + hd2), w, h);
        this.nXpY = new QuadTree<T>(new Point2D.Double(this.center.getX() - wd2, this.center.getY() + hd2), w, h);
        this.pXnY = new QuadTree<T>(new Point2D.Double(this.center.getX() + wd2, this.center.getY() - hd2), w, h);
        this.nXnY = new QuadTree<T>(new Point2D.Double(this.center.getX() - wd2, this.center.getY() - hd2), w, h);
        this.leaf = false;
    }
}

