/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.server.ui.prefs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.district.maps.server.TileserverMapnik;
import org.simantics.district.maps.server.TileserverMapnikInstance;
import org.simantics.district.network.ui.DynamicComboFieldEditor;
import org.simantics.maps.server.ui.TileserverMapnikStartJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapsServerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapsServerPreferencePage.class);
    private TileserverMapnik server;
    private DynamicComboFieldEditor currentTilesSelector;
    private Button removeSelectedTileButton;
    private String filterPath = null;

    public MapsServerPreferencePage() {
        super(1);
        this.setDescription("Maps server preferences");
    }

    public void init(IWorkbench workbench) {
        try {
            this.server = TileserverMapnikInstance.get();
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Could not initialize " + String.valueOf(((Object)((Object)this)).getClass()), (Throwable)e);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.maps.server");
    }

    private void createServerStatusField(final Composite parent) {
        final Label label = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        final Button b = new Button(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)b);
        this.updateWidgets(label, b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (MapsServerPreferencePage.this.server.isRunning()) {
                        MapsServerPreferencePage.this.server.stop();
                        MapsServerPreferencePage.this.updateWidgets(label, b);
                        MapsServerPreferencePage.this.updateTileWidgets();
                    } else {
                        new TileserverMapnikStartJob(status -> parent.getDisplay().asyncExec(() -> {
                            MapsServerPreferencePage.this.updateWidgets(label, b);
                            MapsServerPreferencePage.this.updateTileWidgets();
                        })).schedule();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not start/stop server", (Throwable)ex);
                }
            }
        });
    }

    private void updateWidgets(Label label, Button b) {
        String labelText = "";
        String buttonText = "";
        int labelColor = -1;
        try {
            if (this.server.isRunning()) {
                buttonText = "Stop";
                labelText = "running";
                labelColor = 6;
            } else {
                labelText = "stopped";
                buttonText = "Start";
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Could not create server status field!", (Throwable)e);
            labelText = "unknown";
            labelColor = 4;
        }
        label.setText("Tileserver is currently " + labelText);
        label.setForeground(this.getShell().getDisplay().getSystemColor(labelColor));
        b.setText(buttonText + " server");
    }

    private void createGeneralGroup() {
        Group serverGroup = new Group(this.getFieldEditorParent(), 0);
        serverGroup.setText("General");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)serverGroup);
        this.createServerStatusField((Composite)serverGroup);
        IntegerFieldEditor port = new IntegerFieldEditor("org.simantics.maps.server.defaultPort", "Tileserver port", (Composite)serverGroup);
        this.addField((FieldEditor)port);
        BooleanFieldEditor automatically = new BooleanFieldEditor("org.simantics.maps.server.startAutomatically", "Start tileserver automatically", (Composite)serverGroup);
        this.addField((FieldEditor)automatically);
        StringFieldEditor serverFolder = new StringFieldEditor("org.simantics.maps.server.serverFolder", "Server folder", (Composite)serverGroup);
        serverFolder.setEnabled(false, (Composite)serverGroup);
        this.addField((FieldEditor)serverFolder);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)serverGroup);
    }

    protected void createFieldEditors() {
        this.createGeneralGroup();
        this.createStylesGroup();
        this.createTilesGroup();
    }

    private void createStylesGroup() {
        Group stylesGroup = new Group(this.getFieldEditorParent(), 0);
        stylesGroup.setText("Styles");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)stylesGroup);
        this.createTM2StylesField((Composite)stylesGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)stylesGroup);
    }

    private void createTM2StylesField(Composite parent) {
        try {
            List styles = this.server.listStyles();
            String[][] namesAndValues = new String[styles.size()][];
            int i = 0;
            while (i < styles.size()) {
                String style = (String)styles.get(i);
                String[] nameAndValue = new String[]{style, style};
                namesAndValues[i] = nameAndValue;
                ++i;
            }
            ComboFieldEditor selector = new ComboFieldEditor("org.simantics.maps.server.currentTM2Style", "Selected Style", namesAndValues, parent);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)selector.getLabelControl(parent));
            this.addField((FieldEditor)selector);
        }
        catch (IOException e) {
            LOGGER.error("Failed to list existing TM2 styles", (Throwable)e);
        }
    }

    private void createTilesGroup() {
        Group tilesGroup = new Group(this.getFieldEditorParent(), 0);
        tilesGroup.setText("Vector Tiles");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tilesGroup);
        this.createTilesField((Composite)tilesGroup);
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)tilesGroup);
    }

    private void createTilesField(Composite parent) {
        try {
            String[][] namesAndValues = this.computeNamesAndValues();
            this.currentTilesSelector = new TileSelectorFieldEditor(namesAndValues, parent);
            GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).span(2, 1).applyTo((Control)this.currentTilesSelector.getLabelControl(parent));
            this.addField((FieldEditor)this.currentTilesSelector);
            Composite buttonParent = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)buttonParent);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonParent);
            Button addTileButton = new Button(buttonParent, 8);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)addTileButton);
            addTileButton.setText("Add");
            addTileButton.setToolTipText("Add Tile from File");
            this.removeSelectedTileButton = new Button(buttonParent, 8);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.removeSelectedTileButton);
            this.removeSelectedTileButton.setText("Remove");
            this.removeSelectedTileButton.setToolTipText("Remove Selected Tile");
            addTileButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.addTile()));
            this.removeSelectedTileButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.removeTile(this.currentSelectedTiles())));
            this.currentTilesSelector.addComboListener(SelectionListener.widgetSelectedAdapter(e -> this.updateTileWidgets()));
            this.updateTileWidgets();
        }
        catch (IOException e2) {
            LOGGER.error("Could not create tiles field", (Throwable)e2);
        }
    }

    private Path currentSelectedTiles() {
        String tileName = this.currentTilesSelector.getValue();
        return tileName != null && !tileName.isEmpty() ? this.server.getDataDirectory().resolve(tileName) : null;
    }

    private String getFile(File startingDirectory) {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        } else if (this.filterPath != null) {
            dialog.setFilterPath(this.filterPath);
        }
        dialog.setFilterExtensions(new String[]{"*.mbtiles"});
        this.filterPath = dialog.getFilterPath();
        String file = dialog.open();
        if (file != null && (file = file.trim()).length() > 0) {
            return file;
        }
        return null;
    }

    private void addTile() {
        String fileLocation = this.getFile(null);
        if (fileLocation == null) {
            return;
        }
        if (fileLocation != null) {
            Path p = Paths.get(fileLocation, new String[0]);
            Path target = this.server.getDataDirectory().resolve(p.getFileName());
            if (Files.exists(target, new LinkOption[0]) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Replace Vector Map Tiles", (String)("Replace existing vector map tile file?\n\n" + String.valueOf(target)))) {
                return;
            }
            try {
                Files.copy(p, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                String message = "Could not upload " + fileLocation + " to " + String.valueOf(target.toAbsolutePath());
                LOGGER.error(message, (Throwable)e);
                this.setErrorMessage(message);
            }
        }
        this.refreshTiles();
    }

    private void removeTile(Path tile) {
        try {
            if (tile != null && Files.deleteIfExists(tile)) {
                LOGGER.info("Removed map tile file {}", (Object)tile);
                this.refreshTiles();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to remove existing tile file {}", (Object)tile, (Object)e);
        }
    }

    private void updateTileWidgets() {
        Path servedTiles = this.server.getCurrentTiles();
        Path selectedTiles = this.currentSelectedTiles();
        boolean removeOk = false;
        try {
            removeOk = !this.server.isRunning() || selectedTiles != null && !selectedTiles.equals(servedTiles);
        }
        catch (IOException | InterruptedException exception) {}
        this.removeSelectedTileButton.setEnabled(removeOk);
    }

    private void refreshTiles() {
        try {
            this.currentTilesSelector.updateCombo(this.computeNamesAndValues());
            this.currentTilesSelector.load();
            this.updateTileWidgets();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load list of .mbtiles files", (Throwable)e);
        }
    }

    private String[][] computeNamesAndValues() throws IOException {
        List tiles = this.server.availableMBTiles();
        String[][] namesAndValues = new String[tiles.size()][];
        int i = 0;
        while (i < tiles.size()) {
            String style = (String)tiles.get(i);
            String[] nameAndValue = new String[]{style, style};
            namesAndValues[i] = nameAndValue;
            ++i;
        }
        return namesAndValues;
    }

    public boolean performOk() {
        boolean success = super.performOk();
        try {
            this.server.stop();
            new TileserverMapnikStartJob(status -> {}).schedule();
            this.updateTileWidgets();
        }
        catch (Exception e) {
            LOGGER.error("Could not restart tileserver-mapnik", (Throwable)e);
        }
        return success;
    }

    private static class TileSelectorFieldEditor
    extends DynamicComboFieldEditor {
        public TileSelectorFieldEditor(String[][] namesAndValues, Composite parent) {
            super("org.simantics.maps.server.currentMbTiles", "Current Tiles", namesAndValues, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
            GridData gd = (GridData)this.getComboBox().getLayoutData();
            gd.minimumWidth = 150;
            gd.grabExcessHorizontalSpace = true;
        }
    }
}

