/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.visualisations.triggers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.district.network.visualisations.triggers.VisualisationTrigger;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.structural.stubs.StructuralResource2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualisationTriggersContributions {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualisationTriggersContributions.class);
    private static final String VISUALISATIONS_TRIGGERS_MODULE = "VisualisationTriggers";
    private static final String VISUALISATION_TRIGGER_CONTRIBUTION = "visualisationTriggers";

    public static Map<String, List<VisualisationTrigger>> visualisationTriggers(ReadGraph graph) throws DatabaseException {
        List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        HashMap<String, List<VisualisationTrigger>> results = new HashMap<String, List<VisualisationTrigger>>();
        Layer0.getInstance((ReadGraph)graph);
        Object oldGraph = SCLContext.getCurrent().get((Object)"graph");
        try {
            SCLContext.getCurrent().put((Object)"graph", (Object)graph);
            for (Resource sharedOntology : sharedOntologies) {
                Collection userComponents = (Collection)graph.syncRequest((Read)new ObjectsWithSupertype(sharedOntology, Layer0.getInstance((ReadGraph)graph).ConsistsOf, StructuralResource2.getInstance((ReadGraph)graph).Component));
                for (Resource userComponent : userComponents) {
                    NamedResource moduleType = new NamedResource(NameLabelUtil.modalName((ReadGraph)graph, (Resource)userComponent), userComponent);
                    List<VisualisationTrigger> visualisationTriggerContributions = VisualisationTriggersContributions.visualisationTriggerContribution(graph, moduleType);
                    if (visualisationTriggerContributions == null) continue;
                    results.put(moduleType.getName(), visualisationTriggerContributions);
                }
            }
        }
        finally {
            SCLContext.getCurrent().put((Object)"graph", oldGraph);
        }
        return results;
    }

    private static List<VisualisationTrigger> visualisationTriggerContribution(ReadGraph graph, NamedResource moduleType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource sclModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)moduleType.getResource(), (Resource)L0.SCLModule, (String)VISUALISATIONS_TRIGGERS_MODULE);
        if (sclModule != null) {
            String moduleURI = graph.getURI(sclModule);
            try {
                List result = (List)SCLOsgi.MODULE_REPOSITORY.getValue(moduleURI, VISUALISATION_TRIGGER_CONTRIBUTION);
                return result;
            }
            catch (ValueNotFound e) {
                LOGGER.error("Could not find contributions for module {} and expression {}", new Object[]{moduleURI, VISUALISATION_TRIGGER_CONTRIBUTION, e});
            }
        }
        return null;
    }
}

