/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.StringType;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.requests.PossibleTechTypeItem;
import org.simantics.district.network.techtype.requests.PossibleTechTypeKeyName;
import org.simantics.district.network.techtype.requests.PossibleTechTypeTable;
import org.simantics.district.network.techtype.requests.TechTypeTableData;
import org.simantics.district.network.techtype.requests.TechTypeTableKeyName;
import org.simantics.district.network.techtype.requests.WriteTechTypeTable;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.structural.stubs.StructuralResource2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(TechTypeUtils.class);
    public static String DEFAULT_KEY_NAME = "pipeCode";

    public static void loadTechTypeTable(Resource componentType, String filePath) throws DatabaseException, IOException {
        TechTypeUtils.loadTechTypeTable(componentType, filePath, Charset.defaultCharset());
    }

    public static void loadTechTypeTable(Resource componentType, String filePath, Charset charset) throws DatabaseException, IOException {
        try {
            String data = Files.lines(Paths.get(filePath, new String[0]), charset).collect(Collectors.joining("\n"));
            Simantics.getSession().syncRequest((Write)new WriteTechTypeTable(componentType, data));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read contents of file '{}' as {}", new Object[]{filePath, charset, e});
            throw e;
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to write tech type table data to model", (Throwable)e);
            throw e;
        }
    }

    public static Map<String, String> getTableItem(RequestProcessor session, Resource table, String itemCode) throws DatabaseException {
        return (Map)session.syncRequest((Read)new PossibleTechTypeItem(table, itemCode), (Listener)TransientCacheListener.instance());
    }

    public static Map<String, String> getTableItem(Resource table, String itemCode) throws DatabaseException {
        Object graph = SCLContext.getCurrent().get((Object)"graph");
        if (graph != null && graph instanceof ReadGraph) {
            return TechTypeUtils.getTableItem((RequestProcessor)((ReadGraph)graph), table, itemCode);
        }
        return TechTypeUtils.getTableItem((RequestProcessor)Simantics.getSession(), table, itemCode);
    }

    public static void resetComponents(final Resource table) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(table), (Listener)TransientCacheListener.instance());
                if (model == null) {
                    return;
                }
                Resource type = graph.getPossibleObject(table, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasComponentType);
                if (type == null) {
                    return;
                }
                List components = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)type);
                for (Resource component : components) {
                    TechTypeUtils.updateComponent(graph, component, table);
                }
            }
        });
    }

    public static void resetMapElements(final Resource table) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(table), (Listener)TransientCacheListener.instance());
                if (model == null) {
                    return;
                }
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                Resource type = graph.getPossibleObject(table, DN.TechType_TechTypeTable_HasComponentType);
                if (type == null) {
                    return;
                }
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String typeName = (String)graph.getRelatedValue2(type, L0.HasName);
                Resource mapping = null;
                for (Resource m : QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)DN.Mapping_Base)) {
                    String name = (String)graph.getRelatedValue2(m, DN.Mapping_ComponentType);
                    if (!Objects.equals(name, typeName)) continue;
                    mapping = m;
                    break;
                }
                if (mapping == null) {
                    LOGGER.warn("No mapping found for component type {}", (Object)type);
                    return;
                }
                HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
                Resource mappingType = graph.getSingleType(mapping, DN.Mapping_Base);
                Collection mappingRelations = graph.getObjects(mappingType, L0.DomainOf);
                for (Resource r : mappingRelations) {
                    Resource relation;
                    String propertyName = (String)graph.getPossibleRelatedValue2(mapping, r);
                    if (propertyName == null || (relation = graph.getPossibleObject(r, DN.Mapping_HasPropertyRelation)) == null) continue;
                    properties.put(propertyName, (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(relation)));
                }
                Map data = (Map)graph.syncRequest((Read)new TechTypeTableData(table), (Listener)TransientCacheListener.instance());
                String keyName = (String)graph.syncRequest((Read)new TechTypeTableKeyName(table), (Listener)TransientCacheListener.instance());
                Resource keyRelation = ((PropertyInfo)properties.get((Object)keyName)).predicate;
                if (keyRelation == null) {
                    LOGGER.warn("No relation mapped to property {} found in {} mapping", (Object)keyName, (Object)mapping);
                    return;
                }
                Resource elementType = graph.isInstanceOf(mapping, DN.Mapping_EdgeMapping) ? DN.Edge : (graph.isInstanceOf(mapping, DN.Mapping_VertexMapping) ? DN.Vertex : DN.Element);
                List elements = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)elementType);
                for (Resource element : elements) {
                    Resource elementMapping = graph.getPossibleObject(element, DN.HasMapping);
                    if (!mapping.equals(elementMapping)) continue;
                    String key = (String)graph.getPossibleRelatedValue2(element, keyRelation);
                    Map values = (Map)data.get(key);
                    if (values == null) {
                        LOGGER.info("Key {} not found in tech type table {}", (Object)key, (Object)table);
                        continue;
                    }
                    for (Map.Entry entry : values.entrySet()) {
                        PropertyInfo prop = (PropertyInfo)properties.get(entry.getKey());
                        if (prop == null) continue;
                        String value = (String)entry.getValue();
                        Datatype dt = prop.requiredDatatype;
                        if (dt instanceof NumberType) {
                            try {
                                Object num = ((NumberBinding)prop.defaultBinding).create(value.replace(",", "."));
                                graph.claimLiteral(element, prop.predicate, prop.literalRange, num, prop.defaultBinding);
                            }
                            catch (NumberFormatException numberFormatException) {
                                graph.deny(element, prop.predicate);
                            }
                            catch (BindingException e) {
                                LOGGER.error("Failed to get binding for datatype {}", (Object)dt, (Object)e);
                            }
                            continue;
                        }
                        if (dt instanceof StringType) {
                            graph.claimLiteral(element, prop.predicate, prop.literalRange, (Object)value, (Binding)Bindings.STRING);
                            continue;
                        }
                        LOGGER.warn("updateComponent: Unsupported property type {}", (Object)dt);
                    }
                }
            }
        });
    }

    public static void updateComponent(WriteGraph graph, Resource component) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = graph.getSingleType(component, STR.Component);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(component));
        if (model == null) {
            LOGGER.info("updateComponent: No model for {}", (Object)component);
            return;
        }
        Resource table = (Resource)graph.syncRequest((Read)new PossibleTechTypeTable(model, type), (Listener)TransientCacheListener.instance());
        if (table == null) {
            LOGGER.info("updateComponent: No tech type table for {} in {}", (Object)type, (Object)model);
            return;
        }
        TechTypeUtils.updateComponent(graph, component, table);
    }

    public static void updateComponent(final Resource component) throws DatabaseException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("updateComponent({})", (Object)component);
        }
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                TechTypeUtils.updateComponent(graph, component);
            }
        });
    }

    public static void updateComponent(WriteGraph graph, Resource component, Resource table) throws DatabaseException {
        Variable v;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("updateComponent(graph, {}, {}), component, table)");
        }
        if ((v = (Variable)graph.syncRequest((Read)new PossibleVariable(component))) == null) {
            LOGGER.info("No variable found for {}", (Object)component);
            return;
        }
        String keyProp = TechTypeUtils.getKeyPropertyName((ReadGraph)graph, table);
        String itemCode = (String)v.getPropertyValue((ReadGraph)graph, keyProp);
        Map map = (Map)graph.syncRequest((Read)new PossibleTechTypeItem(table, itemCode), (Listener)TransientCacheListener.instance());
        if (map == null) {
            LOGGER.info("No entry found for \"{}\" in tech type table {}", (Object)itemCode, (Object)table);
            return;
        }
        for (String key : map.keySet()) {
            Datatype dt;
            Variable prop;
            if (key.equals(DEFAULT_KEY_NAME) || (prop = v.getPossibleProperty((ReadGraph)graph, key)) == null || (dt = prop.getPossibleDatatype((ReadGraph)graph)) == null) continue;
            String value = (String)map.get(key);
            if (dt instanceof NumberType) {
                try {
                    Double num = Double.valueOf(value.replace(",", "."));
                    NumberBinding binding = (NumberBinding)Bindings.getBinding((Datatype)dt);
                    prop.setValue(graph, binding.create((Number)num));
                }
                catch (NumberFormatException numberFormatException) {
                    Resource pred = prop.getPossiblePredicateResource((ReadGraph)graph);
                    if (pred == null) continue;
                    graph.deny(component, pred);
                }
                catch (BindingException e) {
                    LOGGER.error("Failed to get binding for datatype {}", (Object)dt, (Object)e);
                }
                continue;
            }
            if (dt instanceof StringType) {
                prop.setValue(graph, (Object)value);
                continue;
            }
            LOGGER.warn("updateComponent: Unsupported property type {}", (Object)dt);
        }
    }

    public static String getKeyPropertyName(ReadGraph graph, Resource table) throws DatabaseException {
        Object name = (String)graph.syncRequest((Read)new TechTypeTableKeyName(table), (Listener)TransientCacheListener.instance());
        if (name == null) {
            name = "_" + DEFAULT_KEY_NAME;
        }
        return name;
    }

    public static String getPossibleTechTypeKeyName(ReadGraph graph, Resource componentType) throws DatabaseException {
        return (String)graph.syncRequest((Read)new PossibleTechTypeKeyName(componentType), (Listener)TransientCacheListener.instance());
    }

    public static Resource getPossibleTechTypeTable(ReadGraph graph, Resource model, Resource componentType) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleTechTypeTable(model, componentType), (Listener)TransientCacheListener.instance());
    }

    public static Map<String, Map<String, String>> getTechTypeData(ReadGraph graph, Resource table) throws DatabaseException {
        return (Map)graph.syncRequest((Read)new TechTypeTableData(table), (Listener)TransientCacheListener.instance());
    }

    public static Map<String, Map<String, String>> getEnabledTechTypeData(ReadGraph graph, Resource table) throws DatabaseException {
        return (Map)graph.syncRequest((Read)new TechTypeTableData(table, true), (Listener)TransientCacheListener.instance());
    }

    public static Map<String, String> getPossibleTechTypeItem(ReadGraph graph, Resource table, String itemCode) throws DatabaseException {
        return (Map)graph.syncRequest((Read)new PossibleTechTypeItem(table, itemCode), (Listener)TransientCacheListener.instance());
    }

    public static final int compareNatural(String s1, String s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        int i = 0;
        char c1 = '\u0000';
        char c2 = '\u0000';
        while (i < len1 && i < len2 && (c1 = s1.charAt(i)) == (c2 = s2.charAt(i))) {
            ++i;
        }
        if (c1 == c2) {
            return len1 - len2;
        }
        if (Character.isDigit(c1)) {
            if (!Character.isDigit(c2)) {
                return 1;
            }
            int x1 = i + 1;
            while (x1 < len1 && Character.isDigit(s1.charAt(x1))) {
                ++x1;
            }
            int x2 = i + 1;
            while (x2 < len2 && Character.isDigit(s2.charAt(x2))) {
                ++x2;
            }
            return x2 == x1 ? c1 - c2 : x1 - x2;
        }
        if (Character.isDigit(c2)) {
            return -1;
        }
        return c1 - c2;
    }
}

