/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.table;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.dnd.Clipboard;
import org.simantics.district.network.ui.table.CustomPasteDataCommand;
import org.simantics.district.network.ui.table.TableDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteDataCommandHandler
extends AbstractLayerCommandHandler<CustomPasteDataCommand> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasteDataCommandHandler.class);
    private final SelectionLayer selectionLayer;
    private final DataLayer dataLayer;
    private final Clipboard cpb;
    private final TableDataProvider provider;

    public PasteDataCommandHandler(TableDataProvider provider, DataLayer dataLayer, SelectionLayer selectionLayer, Clipboard cpb) {
        this.provider = provider;
        this.dataLayer = dataLayer;
        this.selectionLayer = selectionLayer;
        this.cpb = cpb;
    }

    public Class<CustomPasteDataCommand> getCommandClass() {
        return CustomPasteDataCommand.class;
    }

    protected boolean doCommand(CustomPasteDataCommand command) {
        String[][] fullData = command.data;
        int pasteRow = command.pasteRow;
        Collection pasteColumn = command.getColumnPositions();
        if (pasteRow > -1) {
            this.provider.setDataValues(pasteColumn, pasteRow, fullData);
            this.dataLayer.fireLayerEvent((ILayerEvent)new StructuralRefreshEvent((ILayer)this.dataLayer));
        }
        return true;
    }
}

