/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.diagram.participant.pointertool.TranslateMode;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

public class DNTranslateMode
extends TranslateMode {
    public DNTranslateMode(Point2D startingPoint, Point2D currentPoint, int mouseId, Collection<IElement> elements) {
        super(startingPoint, currentPoint, mouseId, elements);
    }

    protected boolean commit() {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ArrayList<ElementTransforms.TransformedObject> transformed = new ArrayList<ElementTransforms.TransformedObject>();
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    for (IElement e : DNTranslateMode.this.elementsToReallyTranslate) {
                        Object obj = ElementUtils.getObject((IElement)e);
                        if (!(obj instanceof Resource) || !graph.isInstanceOf((Resource)obj, DN.Vertex)) continue;
                        Resource res = (Resource)obj;
                        double[] currentCoords = (double[])graph.getRelatedValue2(res, DIA.HasLocation);
                        double x = ModelledCRS.longitudeToX((double)currentCoords[0]);
                        double y = ModelledCRS.latitudeToY((double)currentCoords[1]);
                        AffineTransform at = ElementUtils.getLocalTransform((IElement)e, (AffineTransform)new AffineTransform());
                        if (graph.isInstanceOf(res, DN.Vertex)) {
                            double lat = ModelledCRS.yToLatitude((double)(y + -DNTranslateMode.this.dy / at.getScaleY()));
                            double lon = ModelledCRS.xToLongitude((double)(x + DNTranslateMode.this.dx / at.getScaleX()));
                            double[] coords = new double[]{lon, lat};
                            graph.claimLiteral(res, DIA.HasLocation, (Object)coords);
                            continue;
                        }
                        transformed.add(new ElementTransforms.TransformedObject((Resource)obj, at));
                    }
                    if (!transformed.isEmpty()) {
                        ElementTransforms.setTransformRequest(transformed).perform(graph);
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Translated " + transformed.size() + " " + (transformed.size() == 1 ? "element" : "elements") + " by (" + DNTranslateMode.this.dx + "," + -DNTranslateMode.this.dy + ") mm."));
                    }
                    graph.markUndoPoint();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        for (IElement dirty : this.elementsToDirty) {
            dirty.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
        }
        this.setDirty();
        this.remove();
        return false;
    }
}

