/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import gnu.trove.list.array.TDoubleArrayList;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.district.network.ModelledCRS;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.utils.GeometryUtils;

public class DistrictNetworkNodeUtils {
    public static ThreadLocal<AffineTransform> sharedTransform = new ThreadLocal<AffineTransform>(){

        @Override
        protected AffineTransform initialValue() {
            return new AffineTransform();
        }
    };

    public static Rectangle2D calculateDrawnGeometry(Point2D p, Rectangle2D margin, Rectangle2D result, double scaleRecip) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        double mw = margin.getWidth();
        double mh = margin.getHeight();
        result.setFrame(p.getX() - mw / 2.0 * scaleRecip, p.getY() - mh / 2.0 * scaleRecip, mw * scaleRecip, mh * scaleRecip);
        return result;
    }

    public static Point2D calculatePoint2D(Point2D point, Point2D result) {
        double x = ModelledCRS.longitudeToX((double)point.getX());
        double y = ModelledCRS.latitudeToY((double)(-point.getY()));
        if (result == null) {
            result = new Point2D.Double(x, y);
        } else {
            result.setLocation(x, y);
        }
        return result;
    }

    public static AffineTransform getTransformToRectangle(Rectangle2D toDraw, AffineTransform transform) {
        if (transform == null) {
            transform = new AffineTransform();
        }
        transform.setTransform(toDraw.getWidth(), 0.0, 0.0, toDraw.getHeight(), toDraw.getCenterX(), toDraw.getCenterY());
        return transform;
    }

    public static double calculateScaleRecip(AffineTransform tr) {
        int zoomLevel = MapScalingTransform.zoomLevel((AffineTransform)tr);
        if (zoomLevel == 0) {
            zoomLevel = 1;
        }
        return 1.0 / (DistrictNetworkNodeUtils.getScale(tr) * Math.sqrt(zoomLevel));
    }

    static double getScale(AffineTransform tr) {
        double scale = GeometryUtils.getScale((AffineTransform)tr);
        scale = Math.max(4096.0, scale);
        return scale;
    }

    public static int calculateCenterPointAndDirection(Path2D path, Point2D centerPoint, Point2D direction) {
        PathIterator pi = path.getPathIterator(null);
        TDoubleArrayList segments = new TDoubleArrayList(20);
        double[] tmp = new double[6];
        while (!pi.isDone()) {
            pi.currentSegment(tmp);
            segments.add(tmp[0]);
            segments.add(tmp[1]);
            pi.next();
        }
        int segCount = segments.size();
        if (segCount == 0) {
            centerPoint.setLocation(Double.NaN, Double.NaN);
            direction.setLocation(Double.NaN, Double.NaN);
            return 0;
        }
        if (segCount == 2) {
            centerPoint.setLocation(segments.getQuick(0), segments.getQuick(1));
            direction.setLocation(1.0, 0.0);
            return 1;
        }
        int longest = 2;
        double distance = -1.7976931348623157E308;
        int i = 2;
        while (i < segCount) {
            double dy;
            double dx = segments.getQuick(i) - segments.getQuick(i - 2);
            double d = dx * dx + (dy = segments.getQuick(i + 1) - segments.getQuick(i - 1)) * dy;
            if (d > distance) {
                distance = d;
                longest = i;
            }
            i += 2;
        }
        double x0 = segments.getQuick(longest - 2);
        double y0 = segments.getQuick(longest - 1);
        double x1 = segments.getQuick(longest);
        double y1 = segments.getQuick(longest + 1);
        distance = Math.sqrt(distance);
        centerPoint.setLocation((x0 + x1) / 2.0, (y0 + y1) / 2.0);
        direction.setLocation((x1 - x0) / distance, (y1 - y0) / distance);
        return segCount / 2;
    }
}

