/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public abstract class DistrictNetworkNode
extends G2DParentNode {
    private static final long serialVersionUID = 4211303726201894711L;
    protected Rectangle2D bounds;

    protected Rectangle2D _getOwnBounds() {
        return this.bounds;
    }

    public Rectangle2D getBoundsInLocal(boolean ignoreNulls) {
        return this._getBoundsInLocalRec();
    }

    protected Rectangle2D _getBoundsInLocalRec() {
        Rectangle2D ownBounds = this._getOwnBounds();
        Rectangle2D bounds = null;
        for (IG2DNode node : this.getNodes()) {
            Rectangle2D b = node.getBoundsInLocal(true);
            if (b == null || GeometryUtils.isUndefinedRectangle((Rectangle2D)b)) continue;
            b = node.localToParent(b);
            if (bounds == null) {
                bounds = b.getFrame();
                continue;
            }
            bounds.add(b);
        }
        if (bounds != null) {
            if (ownBounds != null) {
                bounds.add(ownBounds);
            }
            return bounds;
        }
        return ownBounds;
    }

    public Rectangle2D getBoundsInLocal() {
        return this._getBoundsInLocalRec();
    }

    protected void updateBounds() {
        Rectangle2D oldBounds = this.bounds;
        if (oldBounds == null) {
            oldBounds = new Rectangle2D.Double();
        }
        this.bounds = this.calculateBounds(oldBounds);
    }

    protected abstract Rectangle2D calculateBounds(Rectangle2D var1);
}

