/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import org.simantics.district.network.ui.nodes.DeferredNode;
import org.simantics.district.network.ui.nodes.DeferredRenderingNode;
import org.simantics.district.network.ui.nodes.HoverSensitiveNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.NodeException;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.DPIUtil;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.Lists;
import org.simantics.scl.runtime.tuple.Tuple3;

public class DistrictNetworkHoverInfoNode
extends G2DNode
implements HoverSensitiveNode,
DeferredNode {
    private static final long serialVersionUID = 1L;
    private static final String HOVER_INFO_DEFERRED = "hoverInfo";
    public static final String NODE_KEY = "DISTRICT_NETWORK_HOVER_INFO";
    private static final int PAD = 15;
    private List<Tuple3> labels;
    private Font font = new Font("SansSerif", 0, DPIUtil.upscale((int)14));
    private Point2D origin;
    private boolean hover = false;
    private Point2D mousePosition;
    private Rectangle2D bgRect = new Rectangle2D.Double();
    private static AtomicReference<INode> activeNode = new AtomicReference();

    public void render(Graphics2D g) {
        DeferredRenderingNode deferred;
        ParentNode root = (ParentNode)NodeUtil.getNearestParentOfType((INode)this, RTreeNode.class);
        DeferredRenderingNode deferredRenderingNode = deferred = root != null ? (DeferredRenderingNode)root.getNode(HOVER_INFO_DEFERRED) : null;
        if (deferred != null) {
            deferred.deferNode(g.getTransform(), this);
        } else {
            this.renderDeferred(g);
        }
    }

    @Override
    public void renderDeferred(Graphics2D g) {
        if (!this.hover || activeNode.get() == null) {
            return;
        }
        if (this.labels == null || this.labels.isEmpty() || this.mousePosition == null) {
            return;
        }
        AffineTransform ot = g.getTransform();
        Font of = g.getFont();
        this.doRender(g);
        g.setFont(of);
        g.setTransform(ot);
    }

    private ToIntFunction<String> widthMeasurer(FontMetrics fm) {
        return s -> fm.stringWidth((String)s);
    }

    private void doRender(Graphics2D g) {
        AffineTransform tt = this.getTransform();
        g.transform(tt);
        g.translate(this.mousePosition.getX(), this.mousePosition.getY());
        double scale = 1.0 / GeometryUtils.getScale((AffineTransform)g.getTransform());
        g.scale(scale, scale);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        ToIntFunction<String> sizer = this.widthMeasurer(fm);
        double rowHeight = (double)fm.getHeight() * 1.1;
        List<Tuple3> values = this.labels.subList(0, this.labels.size() - 1);
        Tuple3 title = this.labels.get(this.labels.size() - 1);
        int maxLabelWidth = values.stream().map(t -> (String)t.c0).mapToInt(sizer).max().orElse(15);
        int[] valueWidths = values.stream().map(t -> (String)t.c1).mapToInt(sizer).toArray();
        int maxValueWidth = Arrays.stream(valueWidths).max().orElse(15);
        int maxUnitWidth = values.stream().map(t -> (String)t.c2).mapToInt(sizer).max().orElse(15);
        String titleString = (Objects.toString(title.c0, "") + " " + Objects.toString(title.c1, "") + " " + Objects.toString(title.c2, "")).trim();
        int titleWidth = sizer.applyAsInt(titleString);
        int titleRowWidth = 15 + titleWidth + 15;
        int maxValueRowWidth = 15 + maxLabelWidth + 15 + maxValueWidth + 15 + maxUnitWidth + 15;
        int totalWidth = Math.max(maxValueRowWidth, titleRowWidth);
        int totalHeight = (int)Math.round(rowHeight * (double)this.labels.size());
        double minX = -(15 + maxLabelWidth + 15 + maxValueWidth + 15);
        double minY = -(totalHeight + (int)Math.round(rowHeight));
        this.bgRect.setRect(minX, minY, totalWidth, totalHeight + 15);
        this.confineIn(this.bgRect, g.getClip().getBounds2D());
        g.setColor(Color.WHITE);
        g.fill(this.bgRect);
        g.setColor(Color.DARK_GRAY);
        g.draw(this.bgRect);
        g.setColor(Color.BLACK);
        g.translate(this.bgRect.getMinX() - minX, this.bgRect.getMinY() - minY);
        int rows = values.size();
        double y = -rowHeight;
        float labelX = -(maxLabelWidth + 15 + maxValueWidth + 15);
        float unitX = 0.0f;
        int i = 0;
        while (i < rows) {
            Tuple3 t2 = values.get(i);
            float ty = (float)y;
            if (t2.c0 != null && ((String)t2.c0).length() > 0) {
                g.drawString((String)t2.c0, labelX, ty);
            }
            if (t2.c1 != null && ((String)t2.c1).length() > 0) {
                g.drawString((String)t2.c1, (float)(-(valueWidths[i] + 15)), ty);
            }
            if (t2.c2 != null && ((String)t2.c2).length() > 0) {
                g.drawString((String)t2.c2, unitX, ty);
            }
            y -= rowHeight;
            ++i;
        }
        if (!titleString.trim().isEmpty()) {
            int titleX = (int)((double)(labelX - 15.0f) + (this.bgRect.getWidth() - (double)titleWidth) * 0.5);
            g.drawString(titleString, (float)titleX, (float)y);
        }
    }

    private Rectangle2D confineIn(Rectangle2D r, Rectangle2D bounds) {
        double maxX = Math.min(r.getMaxX(), bounds.getMaxX());
        double maxY = Math.min(r.getMaxY(), bounds.getMaxY());
        r.setFrame(maxX - r.getWidth(), maxY - r.getHeight(), r.getWidth(), r.getHeight());
        r.setFrame(Math.max(r.getMinX(), bounds.getMinX()), Math.max(r.getMinY(), bounds.getMinY()), r.getWidth(), r.getHeight());
        return r;
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public void setLabels(List<Tuple3> list) {
        this.labels = Lists.reverse(list);
    }

    public void setOrigin(Point2D origin) {
        this.origin = origin;
    }

    @Override
    public boolean hover(boolean hover, boolean isConnectionTool) {
        boolean changed = hover ^ this.hover;
        this.hover = hover;
        return changed;
    }

    @Override
    public void setMousePosition(Point2D p) {
        this.mousePosition = p;
    }

    public void delete() {
        super.delete();
        activeNode.set(null);
    }

    public void setHoveredNode(INode hoveredNode) {
        ParentNode root = (ParentNode)NodeUtil.getNearestParentOfType((INode)this.parent, RTreeNode.class);
        if (root != null) {
            INode child = ProfileVariables.browseChild((INode)root, (String)"");
            if (child == null) {
                throw new NullPointerException("Scenegraph child node was not found: ");
            }
            INode existing = NodeUtil.getChildById((INode)child, (String)HOVER_INFO_DEFERRED);
            if (existing == null) {
                if (child instanceof ParentNode) {
                    existing = (INode)((ParentNode)child).addNode(HOVER_INFO_DEFERRED, DeferredRenderingNode.class);
                    ((DeferredRenderingNode)existing).setZIndex(Integer.MAX_VALUE);
                } else {
                    throw new NodeException("Cannot claim child node for non-parent-node " + String.valueOf(child));
                }
            }
        }
        activeNode.set(hoveredNode);
        this.repaint();
    }
}

