/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.simantics.district.network.ui.internal.Activator;
import org.simantics.district.network.ui.participants.Modes;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class DistrictDiagramViewerActionContributor
extends EditorActionBarContributor {
    private static final boolean DEBUG = false;
    private IEditorPart activePart;
    private Display display;
    private ICanvasContext currentContext;
    ModeAction pointerAction;
    ModeAction connectAction;
    ModeAction insertAction;
    IContributionItem pointerItem;
    IContributionItem connectItem;
    IContributionItem insertItem;
    protected IToolBarManager mgr;
    IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == DistrictDiagramViewerActionContributor.this.activePart) {
                DistrictDiagramViewerActionContributor.this.setActiveEditor(null);
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    };
    IHintListener TOOL_LISTENER = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            final IToolMode mode = (IToolMode)newValue;
            final IEditorPart part = DistrictDiagramViewerActionContributor.this.activePart;
            DistrictDiagramViewerActionContributor.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ((this).DistrictDiagramViewerActionContributor.this.display.isDisposed()) {
                        return;
                    }
                    if ((this).DistrictDiagramViewerActionContributor.this.activePart != part) {
                        return;
                    }
                    DistrictDiagramViewerActionContributor.this.updateActionBars(part, mode);
                }
            });
        }
    };

    public void contributeToCoolBar(ICoolBarManager coolBarManager) {
        IContributionItem item = coolBarManager.find("org.simantics.modeling.ui.diagramtoolbar");
        if (item instanceof ToolBarContributionItem) {
            this.mgr = ((ToolBarContributionItem)item).getToolBarManager();
        }
        if (this.mgr == null) {
            return;
        }
        this.pointerAction = new ModeAction("org.simantics.modeling.ui.pointerMode", Hints.POINTERTOOL);
        this.pointerAction.setText("Pointer Mode");
        this.pointerAction.setImageDescriptor(org.simantics.modeling.ui.Activator.POINTER_MODE);
        this.connectAction = new ModeAction("org.simantics.modeling.ui.connectMode", Hints.CONNECTTOOL);
        this.connectAction.setText("Connect Mode");
        this.connectAction.setImageDescriptor(org.simantics.modeling.ui.Activator.CONNECT_MODE);
        this.insertAction = new ModeAction("org.simantics.district.network.ui.insertMode", Modes.INSERT_TOOL);
        this.insertAction.setText("Insert Mode");
        this.insertAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/shape_square_add.png"));
        this.pointerItem = new ActionContributionItem((IAction)this.pointerAction);
        this.connectItem = new ActionContributionItem((IAction)this.connectAction);
        this.insertItem = new ActionContributionItem((IAction)this.insertAction);
        this.mgr.appendToGroup("tool.additions", this.pointerItem);
        this.mgr.appendToGroup("tool.additions", this.connectItem);
        this.mgr.appendToGroup("tool.additions", this.insertItem);
        this.mgr.markDirty();
        this.getPage().addPartListener(this.partListener);
    }

    public void dispose() {
        this.getPage().removePartListener(this.partListener);
        if (this.mgr != null) {
            this.mgr.remove(this.connectItem);
            this.mgr.remove(this.pointerItem);
            this.mgr.remove(this.insertItem);
            this.connectItem.dispose();
            this.pointerItem.dispose();
            this.insertItem.dispose();
            this.mgr.markDirty();
            this.mgr.update(true);
            if (this.activePart != null) {
                this.activePart.getEditorSite().getActionBars().updateActionBars();
                this.activePart = null;
            }
        }
        this.setContext(null, null);
        super.dispose();
        this.setContext(null, null);
        this.activePart = null;
    }

    public void setActiveEditor(IEditorPart part) {
        if (part == this.activePart) {
            return;
        }
        this.activePart = part;
        if (part != null) {
            this.display = part.getSite().getShell().getDisplay();
        }
        ICanvasContext ctx = part != null ? (ICanvasContext)part.getAdapter(ICanvasContext.class) : null;
        this.setContext(part, ctx);
    }

    private void setContext(IEditorPart part, ICanvasContext context) {
        ICanvasContext previous = this.currentContext;
        this.currentContext = context;
        if (previous != context) {
            if (previous != null && !previous.isDisposed()) {
                previous.getHintStack().removeKeyHintListener(Hints.KEY_TOOL, this.TOOL_LISTENER);
            }
            if (context != null && !context.isDisposed()) {
                context.getHintStack().addKeyHintListener(Hints.KEY_TOOL, this.TOOL_LISTENER);
            }
        }
        if (part != null && context != null && !context.isDisposed()) {
            this.updateActionBars(part, (IToolMode)context.getHintStack().getHint(Hints.KEY_TOOL));
        } else {
            this.updateActionBars(null, null);
        }
    }

    private void updateActionBars(IEditorPart part, IToolMode toolMode) {
        this.updateToolMode(toolMode);
        if (part != null) {
            part.getEditorSite().getActionBars().updateActionBars();
        }
    }

    private void updateToolMode(IToolMode toolMode) {
        if (toolMode != null) {
            this.pointerAction.setEnabled(true);
            this.connectAction.setEnabled(true);
            this.insertAction.setEnabled(true);
            if (toolMode == Hints.POINTERTOOL) {
                this.pointerAction.setChecked(true);
                this.connectAction.setChecked(false);
                this.insertAction.setChecked(false);
            } else if (toolMode == Hints.CONNECTTOOL) {
                this.pointerAction.setChecked(false);
                this.insertAction.setChecked(false);
                this.connectAction.setChecked(true);
            } else if (toolMode == Modes.INSERT_TOOL) {
                this.pointerAction.setChecked(false);
                this.insertAction.setChecked(true);
                this.connectAction.setChecked(false);
            }
        } else {
            this.pointerAction.setEnabled(false);
            this.connectAction.setEnabled(false);
            this.insertAction.setEnabled(false);
        }
    }

    public class ModeAction
    extends Action {
        private IToolMode targetMode;

        public ModeAction(String id, IToolMode targetMode) {
            super(id, 8);
            this.targetMode = targetMode;
        }

        public void run() {
            final ICanvasContext context = DistrictDiagramViewerActionContributor.this.currentContext;
            if (context == null) {
                return;
            }
            IEditorPart part = DistrictDiagramViewerActionContributor.this.activePart;
            if (part == null) {
                return;
            }
            if (context.isDisposed()) {
                return;
            }
            ThreadUtils.asyncExec((IThreadWorkQueue)context.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (context.isDisposed()) {
                        return;
                    }
                    IToolMode toolMode = (IToolMode)context.getHintStack().getHint(Hints.KEY_TOOL);
                    if (!ModeAction.this.targetMode.equals(toolMode)) {
                        context.getDefaultHintContext().setHint(Hints.KEY_TOOL, (Object)ModeAction.this.targetMode);
                    }
                }
            });
        }
    }
}

