/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.sg;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.maps.MapScalingTransform;
import org.simantics.maps.elevation.server.SingletonTiffTileInterface;
import org.simantics.maps.sg.Formatting;
import org.simantics.maps.sg.MapInfoConstants;
import org.simantics.maps.sg.MapInfoNode;

public class MapLocationInfoNode
extends MapInfoNode {
    private static final long serialVersionUID = 7994492218791569147L;
    private static final transient int MAX_DIGITS = 7;
    private static final transient int MAX_Z_DECIMALS = 2;
    private static final transient double TRIM_THRESHOLD_MAX_VALUE = Math.pow(10.0, 4.0);
    private static final transient double TEXT_RIGHT_MARGIN = 20.0;
    private MouseUtil mouse;

    public void render(Graphics2D g2d) {
        double startLon;
        double startLat;
        if (!this.enabled || this.mouse == null) {
            return;
        }
        AffineTransform ot = g2d.getTransform();
        g2d.setTransform(new AffineTransform());
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            return;
        }
        MouseUtil.MouseInfo mouseInfo = this.mouse.getMouseInfo(0);
        if (mouseInfo != null && mouseInfo.canvasPosition != null) {
            Point2D canvasPosition = mouseInfo.canvasPosition;
            double cx = canvasPosition.getX();
            double cy = canvasPosition.getY();
            startLat = MapLocationInfoNode.yToLatitude(-cy / this.transform.getScaleY());
            startLon = MapLocationInfoNode.xToLongitude(cx / this.transform.getScaleX());
        } else {
            startLat = 0.0;
            startLon = 0.0;
        }
        Number z = SingletonTiffTileInterface.lookup((double)startLat, (double)startLon);
        int zoomLevel = MapScalingTransform.zoomLevel(ot);
        String str = "X: " + Formatting.formatValue(startLon, 7, false, Formatting.FormatMode.LIMIT_DIGITS, TRIM_THRESHOLD_MAX_VALUE) + "   Y: " + Formatting.formatValue(startLat, 7, false, Formatting.FormatMode.LIMIT_DIGITS, TRIM_THRESHOLD_MAX_VALUE) + "   Z: " + Formatting.formatValue(z.doubleValue(), 2, false, Formatting.FormatMode.LIMIT_DECIMALS, TRIM_THRESHOLD_MAX_VALUE) + "   (zoom: " + zoomLevel + ")";
        Font font = MapInfoConstants.getInfoFont();
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(str, g2d);
        double yOffsetFromBottom = this.getMapInfoNextY(g2d);
        double frameMaxY = bounds.getMaxY() - yOffsetFromBottom;
        double frameMinY = frameMaxY - (double)font.getSize() - 4.0;
        double frameWidth = r.getWidth() + 20.0;
        double frameMaxX = bounds.getMaxX() - 20.0;
        double frameMinX = frameMaxX - frameWidth;
        double textY = frameMinY + 2.0 + (double)fm.getMaxAscent();
        Composite oc = g2d.getComposite();
        g2d.setComposite(MapInfoConstants.INFO_COMPOSITE);
        g2d.setStroke(MapInfoConstants.INFO_STROKE);
        g2d.setColor(MapInfoConstants.TEXT_BG_COLOR);
        this.rect.setFrame(frameMinX, frameMinY, frameWidth, frameMaxY - frameMinY);
        g2d.fill(this.rect);
        g2d.setColor(Color.BLACK);
        g2d.drawString(str, (int)frameMinX + 10, (int)textY);
        g2d.setComposite(oc);
        g2d.setTransform(ot);
        this.setMapInfoNextY(g2d, yOffsetFromBottom + this.rect.getHeight() + 4.0);
    }

    public void setMouseUtil(MouseUtil util) {
        this.mouse = util;
    }

    private static double xToLongitude(double x) {
        return x;
    }

    private static double yToLatitude(double y) {
        double rad = Math.toRadians(y);
        double sinh = Math.sinh(rad);
        double atan = Math.atan(sinh);
        double finald = Math.toDegrees(atan);
        return finald;
    }
}

