/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.eclipse;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.maps.sg.MapAttributionNode;
import org.simantics.maps.sg.MapInfoNode;
import org.simantics.maps.sg.MapLocationInfoNode;
import org.simantics.maps.sg.MapNode;
import org.simantics.maps.sg.MapScaleNode;
import org.simantics.maps.sg.commands.MapCommands;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPainter
extends AbstractCanvasParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapPainter.class);
    public static final IHintContext.Key KEY_MAP_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final IHintContext.Key KEY_MAP_BACKGROUND_COLOR = new IHintContext.KeyOf(Object.class);
    public static final double ZOOM_IN_LIMIT = 1.0E7;
    public static final double ZOOM_OUT_LIMIT = 10.0;
    IHintListener mapListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ICanvasContext cc = MapPainter.this.getContext();
            if (cc != null) {
                MapPainter.this.updateNode();
                cc.getContentContext().setDirty();
            }
        }
    };
    private MapNode mapNode;
    private MapLocationInfoNode locationInfoNode;
    private MapScaleNode scaleNode;
    private MapInfoNode attributionNode;
    private AffineTransform transform;
    private ScheduledFuture<?> schedule;

    public MapPainter(AffineTransform transform) {
        this.transform = transform;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_MAP_ENABLED, this.mapListener);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_MAP_BACKGROUND_COLOR, this.mapListener);
    }

    public void removedFromContext(ICanvasContext ctx) {
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_MAP_ENABLED, this.mapListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_MAP_BACKGROUND_COLOR, this.mapListener);
        super.removedFromContext(ctx);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKeyEvent(CommandEvent e) {
        if (e.command.equals((Object)Commands.MAP_ENABLE)) {
            this.setEnabled(true);
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)MapCommands.MAP_BACKGROUND_COLOR_CHANGE)) {
            ICanvasContext context = (ICanvasContext)e.getContext();
            Color s = (Color)context.getHintStack().getHint(MapCommands.KEY_MAP_BACKGROUND_COLOR);
            this.setBackgroundColor(s);
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.MAP_DISABLE)) {
            this.setEnabled(false);
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.MAP_TOGGLE)) {
            this.setEnabled(!this.isMapEnabled());
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.ENABLE_PAINTING)) {
            this.enablePainting();
            this.updateNode();
            this.setDirty();
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=31)
    public boolean handleEvent(Event e) {
        if (e instanceof MouseEvent.MouseMovedEvent && this.locationInfoNode != null && this.locationInfoNode.isEnabled() && (this.schedule == null || this.schedule.isDone())) {
            LOGGER.debug("current setDirty time" + System.currentTimeMillis());
            this.schedule = ThreadUtils.getNonBlockingWorkExecutor().schedule(() -> AWTThread.getThreadAccess().asyncExec(() -> ((MapPainter)this).setDirty()), 100L, TimeUnit.MILLISECONDS);
        }
        return false;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.mapNode = (MapNode)parent.addNode("map", MapNode.class);
        this.mapNode.setTransform(this.transform);
        this.mapNode.setEnabled(true);
        this.mapNode.setZIndex(-2147482649);
        this.attributionNode = (MapInfoNode)((Object)parent.addNode("mapAttribution", MapAttributionNode.class));
        this.attributionNode.setTransform(this.transform);
        this.attributionNode.setZIndex(2147482648);
        this.attributionNode.setEnabled(true);
        this.scaleNode = (MapScaleNode)((Object)parent.addNode("mapScale", MapScaleNode.class));
        this.scaleNode.setTransform(this.transform);
        this.scaleNode.setZIndex(2147482649);
        this.scaleNode.setEnabled(true);
        this.locationInfoNode = (MapLocationInfoNode)((Object)parent.addNode("mapLocationInfo", MapLocationInfoNode.class));
        this.locationInfoNode.setTransform(this.transform);
        this.locationInfoNode.setZIndex(2147482650);
        this.locationInfoNode.setEnabled(true);
        this.locationInfoNode.setMouseUtil((MouseUtil)this.getContext().getAtMostOneItemOfClass(MouseUtil.class));
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.mapNode.remove();
        this.attributionNode.remove();
        this.scaleNode.remove();
        this.locationInfoNode.remove();
    }

    protected void updateNode() {
        this.mapNode.setEnabled(this.isPaintingEnabled());
        this.mapNode.setEnabled(this.isMapEnabled());
        this.mapNode.setBackgroundColor(this.getBackgroundColor());
    }

    boolean isPaintingEnabled() {
        boolean enabled = this.isMapEnabled();
        Boolean globalDisable = (Boolean)this.getHint(Hints.KEY_DISABLE_PAINTING);
        return enabled && !Boolean.TRUE.equals(globalDisable);
    }

    public boolean isMapEnabled() {
        Boolean enabled = (Boolean)this.getHint(KEY_MAP_ENABLED);
        return !Boolean.FALSE.equals(enabled);
    }

    public void setEnabled(boolean enabled) {
        this.setHint(KEY_MAP_ENABLED, enabled);
    }

    private void enablePainting() {
        this.setHint(Hints.KEY_DISABLE_PAINTING, false);
    }

    private void setBackgroundColor(Color backgroundColor) {
        this.setHint(KEY_MAP_BACKGROUND_COLOR, backgroundColor);
    }

    private Color getBackgroundColor() {
        return (Color)this.getHint(KEY_MAP_BACKGROUND_COLOR);
    }
}

