/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.java;

import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.scl.compiler.parser.generator.compression.CompressedParseTable;
import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.grammar.Prod;

public class GenerateParser {
    String packageName;
    String className;
    String exceptionName;
    AnaGrammar grammar;
    CompressedParseTable table;
    private static final Pattern PATTERN = Pattern.compile("\\$[A-Za-z0-9]+\\$");

    public GenerateParser(String packageName, String className, AnaGrammar grammar, String exceptionName, CompressedParseTable table) {
        this.packageName = packageName;
        this.className = className;
        this.grammar = grammar;
        this.exceptionName = exceptionName;
        this.table = table;
    }

    private String readTemplate() throws IOException {
        int c;
        InputStream stream = this.getClass().getResourceAsStream("Parser.java.template");
        byte[] buffer = new byte[10000];
        int pos = 0;
        while ((c = stream.read(buffer, pos, buffer.length - pos)) > 0) {
            if ((pos += c) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        return new String(buffer, 0, pos, "UTF-8");
    }

    public void generate(File file) throws IOException {
        PrintStream out = new PrintStream(file, "UTF-8");
        int aPos = 0;
        String template = this.readTemplate();
        Matcher matcher = PATTERN.matcher(template);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            out.print(template.substring(aPos, start));
            String varName = template.substring(start + 1, end - 1);
            this.generateVar(out, varName);
            aPos = end;
        }
        out.print(template.substring(aPos));
        out.close();
    }

    private void generateVar(PrintStream out, String varName) {
        if ("package".equals(varName)) {
            out.print(this.packageName);
        } else if ("class".equals(varName)) {
            out.print(this.className);
        } else if ("terminalCount".equals(varName)) {
            out.print(this.grammar.terminalNames.length);
        } else if ("nonterminalCount".equals(varName)) {
            out.print(this.grammar.nonterminalNames.length);
        } else if ("productCount".equals(varName)) {
            out.print(this.grammar.prods.size());
        } else if ("stateCount".equals(varName)) {
            out.print(this.table.actionTable.rowIndex.length);
        } else if ("parseMethods".equals(varName)) {
            int i = 0;
            while (i < this.grammar.initialNonterminals.length) {
                Object ntName = this.grammar.getName(this.grammar.initialNonterminals[i]);
                ntName = ((String)ntName).substring(0, 1).toUpperCase() + ((String)ntName).substring(1);
                out.println("    public Object parse" + (String)ntName + "() {");
                out.println("        return parse(" + this.table.initialStates[i] + ");");
                out.println("    }");
                ++i;
            }
        } else if ("terminalNames".equals(varName)) {
            int i = 0;
            while (i < this.grammar.terminalNames.length) {
                if (i > 0) {
                    out.println(",");
                }
                out.print("        \"" + this.grammar.terminalNames[i] + "\"");
                ++i;
            }
        } else if ("nonterminalNames".equals(varName)) {
            int i = 0;
            while (i < this.grammar.nonterminalNames.length) {
                if (i > 0) {
                    out.println(",");
                }
                out.print("        \"" + this.grammar.nonterminalNames[i] + "\"");
                ++i;
            }
        } else if ("stateDescriptions".equals(varName)) {
            int i = 0;
            while (i < this.table.stateDescriptions.length) {
                if (i > 0) {
                    out.println(",");
                }
                out.print("        \"" + this.table.stateDescriptions[i].replace("\n", "\\n") + "\"");
                ++i;
            }
        } else if ("reduceCases".equals(varName)) {
            int i = 0;
            while (i < this.grammar.prods.size()) {
                Prod prod = this.grammar.prods.get(i);
                if (!this.grammar.nonterminalNames[prod.lhs].startsWith("init$")) {
                    out.println("        case " + i + ":");
                    out.println("            return reduce" + prod.name + "();");
                }
                ++i;
            }
        } else if ("reduceDelegates".equals(varName)) {
            int i = 0;
            while (i < this.grammar.prods.size()) {
                Prod prod = this.grammar.prods.get(i);
                if (this.grammar.nonterminalNames[prod.lhs].startsWith("init$")) {
                    out.println("        null,");
                } else {
                    out.println("        new ReduceDelegate() {");
                    out.println("            public Object reduce(" + this.className + " parser) {");
                    out.println("                return parser.reduce" + prod.name + "();");
                    out.println("            }");
                    out.println("        },");
                }
                ++i;
            }
        } else if ("reduceMethods".equals(varName)) {
            THashSet usedNames = new THashSet();
            int i = 0;
            while (i < this.grammar.prods.size()) {
                Prod prod = this.grammar.prods.get(i);
                if (!this.grammar.nonterminalNames[prod.lhs].startsWith("init$") && usedNames.add((Object)prod.name)) {
                    out.println("    /**");
                    out.println("     * " + prod.toString(this.grammar).replace("*", "&#42;"));
                    out.println("     */");
                    out.println("    protected abstract Object reduce" + prod.name + "();");
                }
                ++i;
            }
        } else if ("Token".equals(varName)) {
            out.print("Token");
        } else if ("Symbol".equals(varName)) {
            out.print("Object");
        } else if ("tokenId".equals(varName)) {
            out.print("id");
        } else if ("imports".equals(varName)) {
            out.println("import org.simantics.scl.compiler.internal.parsing.Token;");
        } else if ("actionTableLength".equals(varName)) {
            out.print(this.table.actionTable.table.length);
        } else if ("gotoTableLength".equals(varName)) {
            out.print(this.table.gotoTable.table.length);
        } else if ("errorTableLength".equals(varName)) {
            out.print(this.table.errorTable.length);
        } else if ("Exception".equals(varName)) {
            out.print(this.exceptionName);
        }
    }
}

