/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.transformations;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EEnforce;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.block.BlockType;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QMapping;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.elaboration.transformations.DecomposedRule;
import org.simantics.scl.compiler.internal.elaboration.transformations.UnifiableFactory;
import org.simantics.scl.compiler.internal.elaboration.utils.ForcedClosure;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class TransformationBuilder {
    private final ErrorLog errorLog;
    private final TypingContext context;
    private final UnifiableFactory unifiableFactory;
    THashMap<MappingRelation, Mapping> mappings = new THashMap();
    THashMap<TransformationRule, LocalRelation> ruleSourceMatchRelations = new THashMap();
    ArrayList<ERuleset.DatalogRule> sourceMatchingRules = new ArrayList();
    ArrayList<Statement> mappingStatements = new ArrayList();
    TIntObjectHashMap<ArrayList<Statement>> enforcingStatements = new TIntObjectHashMap();

    public TransformationBuilder(ErrorLog errorLog, TypingContext context) {
        this.errorLog = errorLog;
        this.context = context;
        this.unifiableFactory = new UnifiableFactory(context, this.mappingStatements);
    }

    private Mapping getMapping(MappingRelation mappingRelation) {
        Mapping mapping = (Mapping)this.mappings.get((Object)mappingRelation);
        if (mapping == null) {
            mapping = new Mapping();
            mapping.relation = new LocalRelation(mappingRelation.name.name + "_src", new Type[]{mappingRelation.parameterTypes[0]});
            mapping.umap = new Variable("map_" + mappingRelation.name.name, Types.apply((Type)Names.Unifiable_UMap, mappingRelation.parameterTypes));
            this.mappings.put((Object)mappingRelation, (Object)mapping);
            this.mappingStatements.add(new LetStatement(new EVariable(mapping.umap), Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_createUMap, mappingRelation.parameterTypes[0], mappingRelation.parameterTypes[1], Expressions.punit())));
        }
        return mapping;
    }

    private static Expression statementsToExpression(EnvironmentalContext context, List<Statement> statements, Expression in) {
        int i = statements.size() - 1;
        while (i >= 0) {
            in = statements.get(i).toExpression(context, BlockType.Normal, in);
            --i;
        }
        return in;
    }

    private static Expression statementsToExpression(EnvironmentalContext context, List<Statement> statements) {
        return TransformationBuilder.statementsToExpression(context, statements, Expressions.tuple());
    }

    public void handleSeed(Query query) {
        if (query instanceof QMapping) {
            QMapping mapping = (QMapping)query;
            Mapping m = this.getMapping(mapping.mappingRelation);
            this.sourceMatchingRules.add(new ERuleset.DatalogRule(query.location, m.relation, new Expression[]{mapping.parameters[0]}, new QConjunction(new Query[0]), Variable.EMPTY_ARRAY));
            this.mappingStatements.add(new GuardStatement(this.unifiableFactory.putToUMapConstant(m.umap, mapping.parameters[0].copy(this.context), mapping.parameters[1].copy(this.context))));
        } else if (query instanceof QConjunction) {
            QConjunction conjunction = (QConjunction)query;
            Query[] queryArray = conjunction.queries;
            int n = conjunction.queries.length;
            int n2 = 0;
            while (n2 < n) {
                Query childQuery = queryArray[n2];
                this.handleSeed(childQuery);
                ++n2;
            }
        } else {
            this.errorLog.log(query.location, "Cannot use the query as a seed for the transformation.");
        }
    }

    public void handleRule(TransformationRule rule) {
        DecomposedRule decomposed = DecomposedRule.decompose(this.context, rule, true);
        for (QMapping mapping : decomposed.sourceMappings) {
            decomposed.sourceQueries.add(new QAtom((SCLRelation)this.getMapping((MappingRelation)mapping.mappingRelation).relation, Type.EMPTY_ARRAY, mapping.parameters[0].copy(this.context)));
        }
        final THashSet variableSet = new THashSet(rule.variables.length);
        Variable[] variableArray = rule.variables;
        int n = rule.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variableSet.add((Object)variable);
            ++n2;
        }
        final ArrayList sourceVariableList = new ArrayList(rule.variables.length);
        VariableProcedure analyze = new VariableProcedure(){

            @Override
            public void execute(long location, Variable variable) {
                if (variableSet.remove((Object)variable)) {
                    sourceVariableList.add(variable);
                }
            }
        };
        for (Query query : decomposed.sourceQueries) {
            query.forVariables(analyze);
        }
        VariableProcedure check = new VariableProcedure(){

            @Override
            public void execute(long location, Variable variable) {
                if (variableSet.contains((Object)variable)) {
                    TransformationBuilder.this.errorLog.log(location, "Cannot resolve the variable " + variable.getName() + " using the source patterns.");
                }
            }
        };
        for (QMapping mapping : decomposed.targetMappings) {
            mapping.parameters[0].forVariableUses(check);
        }
        Variable[] sourceVariables = sourceVariableList.toArray(new Variable[sourceVariableList.size()]);
        this.generateMatchingRules(decomposed, sourceVariables);
        ArrayList<QMapping> mappings = new ArrayList<QMapping>(decomposed.sourceMappings.size() + decomposed.targetMappings.size());
        mappings.addAll(decomposed.sourceMappings);
        mappings.addAll(decomposed.targetMappings);
        int capacity = Math.max(10, mappings.size());
        ArrayList<QMapping> closedMappings = new ArrayList<QMapping>(capacity);
        ArrayList<QMapping> openMappings = new ArrayList<QMapping>(capacity);
        ArrayList<QMapping> semiopenMappings = new ArrayList<QMapping>(capacity);
        TObjectIntHashMap mappedVariableUseCount = new TObjectIntHashMap();
        for (QMapping mapping : mappings) {
            Expression expression = mapping.parameters[1];
            if (expression instanceof EVariable) {
                Variable variable = ((EVariable)expression).getVariable();
                if (variableSet.contains((Object)variable)) {
                    mappedVariableUseCount.adjustOrPutValue((Object)variable, 1, 1);
                    openMappings.add(mapping);
                    continue;
                }
                closedMappings.add(mapping);
                continue;
            }
            PatternAnalyzer analyzer = new PatternAnalyzer((THashSet<Variable>)variableSet, (TObjectIntHashMap<Variable>)mappedVariableUseCount);
            expression.forVariableUses(analyzer);
            if (analyzer.containsVariables) {
                semiopenMappings.add(mapping);
                continue;
            }
            closedMappings.add(mapping);
        }
        ArrayList<Statement> phase2Actions = new ArrayList<Statement>();
        ArrayList<Statement> phase3Actions = new ArrayList<Statement>();
        for (QMapping mapping : closedMappings) {
            phase2Actions.add(new GuardStatement(this.unifiableFactory.putToUMapConstant(this.getMapping((MappingRelation)mapping.mappingRelation).umap, mapping.parameters[0].copy(this.context), mapping.parameters[1].copy(this.context))));
        }
        THashMap uniVariableMap = new THashMap();
        for (Variable variable : mappedVariableUseCount.keySet()) {
            int count = mappedVariableUseCount.get((Object)variable);
            if (count <= 1) continue;
            Variable uniVariable = new Variable("uvar_" + variable.getName(), Types.apply((Type)Names.Unifiable_Unifiable, variable.getType()));
            phase2Actions.add(new LetStatement(new EVariable(uniVariable), Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.Unifiable_uVar, variable.getType(), Expressions.tuple())));
            uniVariableMap.put((Object)variable, (Object)uniVariable);
        }
        THashSet undeterminedVariables = new THashSet((Collection)variableSet);
        for (QMapping mapping : openMappings) {
            Variable variable = ((EVariable)mapping.parameters[1]).getVariable();
            if (uniVariableMap.containsKey((Object)variable)) {
                semiopenMappings.add(mapping);
                continue;
            }
            Mapping m = this.getMapping(mapping.mappingRelation);
            Type resultType = mapping.mappingRelation.parameterTypes[1];
            phase3Actions.add(new LetStatement(new EVariable(variable), this.unifiableFactory.getFromUMap(Expressions.var(m.umap), mapping.parameters[0].copy(this.context), resultType)));
            undeterminedVariables.remove((Object)variable);
        }
        for (QMapping mapping : semiopenMappings) {
            Mapping m = this.getMapping(mapping.mappingRelation);
            Type valueType = mapping.mappingRelation.parameterTypes[1];
            phase2Actions.add(new GuardStatement(this.unifiableFactory.putToUMapUnifiable((THashSet<Variable>)variableSet, (THashMap<Variable, Variable>)uniVariableMap, Expressions.var(m.umap), mapping.parameters[0].copy(this.context), mapping.parameters[1].copy(this.context))));
            Expression pattern = this.toPattern((THashSet<Variable>)undeterminedVariables, mapping.parameters[1]);
            if (pattern == null) continue;
            Expression value = this.unifiableFactory.getFromUMap(Expressions.var(m.umap), mapping.parameters[0].copy(this.context), valueType);
            phase3Actions.add(new LetStatement(pattern, value));
        }
        if (!phase2Actions.isEmpty()) {
            this.mappingStatements.add(new GuardStatement(new EWhen(rule.location, new QAtom((SCLRelation)decomposed.ruleMatchingRelation, Type.EMPTY_ARRAY, Expressions.vars(sourceVariables)), TransformationBuilder.statementsToExpression(this.context.getCompilationContext(), phase2Actions), sourceVariables).compile(this.context)));
        }
        if (!decomposed.targetQueries.isEmpty()) {
            Variable[] variableArray2 = rule.variables;
            int n3 = rule.variables.length;
            int count = 0;
            while (count < n3) {
                Variable variable = variableArray2[count];
                if (variableSet.contains((Object)variable) && !mappedVariableUseCount.containsKey((Object)variable)) {
                    phase3Actions.add(new LetStatement(new EVariable(variable), this.unifiableFactory.generateDefaultValue(variable.getType())));
                }
                ++count;
            }
            TIntObjectHashMap phases = new TIntObjectHashMap();
            for (Query targetQuery : decomposed.targetQueries) {
                targetQuery.splitToPhases((TIntObjectHashMap<ArrayList<Query>>)phases);
            }
            int[] nArray = phases.keys();
            int n4 = nArray.length;
            int n5 = 0;
            while (n5 < n4) {
                int phase = nArray[n5];
                ArrayList targetQuery = (ArrayList)phases.get(phase);
                Expression enforcing = new EEnforce(new QConjunction(targetQuery.toArray(new Query[targetQuery.size()]))).compile(this.context);
                enforcing = TransformationBuilder.statementsToExpression(this.context.getCompilationContext(), phase3Actions, enforcing);
                enforcing = new EWhen(rule.location, new QAtom((SCLRelation)decomposed.ruleMatchingRelation, Type.EMPTY_ARRAY, Expressions.vars(sourceVariables)), enforcing, sourceVariables).compile(this.context);
                ArrayList<GuardStatement> list = (ArrayList<GuardStatement>)this.enforcingStatements.get(phase);
                if (list == null) {
                    list = new ArrayList<GuardStatement>();
                    this.enforcingStatements.put(phase, list);
                }
                list.add(new GuardStatement(ForcedClosure.forceClosure(enforcing.copy(this.context), SCLCompilerConfiguration.EVERY_RULE_ENFORCEMENT_IN_SEPARATE_METHOD)));
                ++n5;
            }
        }
    }

    public Expression compileRules() {
        ArrayList<Statement> allEnforcingStatements;
        ArrayList<LocalRelation> localRelations = new ArrayList<LocalRelation>();
        localRelations.addAll(this.ruleSourceMatchRelations.values());
        for (Mapping mapping : this.mappings.values()) {
            localRelations.add(mapping.relation);
        }
        if (this.enforcingStatements.size() == 1) {
            allEnforcingStatements = (ArrayList<Statement>)this.enforcingStatements.valueCollection().iterator().next();
        } else {
            int[] phases = this.enforcingStatements.keys();
            Arrays.sort(phases);
            allEnforcingStatements = new ArrayList<Statement>();
            int[] nArray = phases;
            int n = phases.length;
            int n2 = 0;
            while (n2 < n) {
                int phase = nArray[n2];
                allEnforcingStatements.addAll((Collection)this.enforcingStatements.get(phase));
                ++n2;
            }
        }
        Expression expression = TransformationBuilder.statementsToExpression(this.context.getCompilationContext(), allEnforcingStatements);
        expression = TransformationBuilder.statementsToExpression(this.context.getCompilationContext(), this.mappingStatements, expression);
        Expression result = new ERuleset(localRelations.toArray(new LocalRelation[localRelations.size()]), this.sourceMatchingRules.toArray(new ERuleset.DatalogRule[this.sourceMatchingRules.size()]), expression).compile(this.context);
        return result;
    }

    private Expression toPattern(THashSet<Variable> undeterminedVariables, Expression expression) {
        if (expression instanceof EVariable) {
            Variable variable = ((EVariable)expression).getVariable();
            if (undeterminedVariables.remove((Object)variable)) {
                return new EVariable(variable);
            }
            return null;
        }
        if (expression instanceof EApply) {
            Expression[] parameters;
            EApply apply = (EApply)expression;
            if (!(apply.getFunction() instanceof EConstant)) {
                return null;
            }
            EConstant function = (EConstant)apply.getFunction();
            IVal val = function.getValue().getValue();
            if (!(val instanceof Constant)) {
                return null;
            }
            Constant constant = (Constant)val;
            int constructorTag = constant.constructorTag();
            if (constructorTag < 0) {
                return null;
            }
            int arity = constant.getArity();
            if (arity != (parameters = apply.getParameters()).length) {
                return null;
            }
            Expression[] patterns = new Expression[arity];
            boolean noUndeterminedVariables = true;
            int i = 0;
            while (i < arity) {
                Expression pattern;
                patterns[i] = pattern = this.toPattern(undeterminedVariables, parameters[i]);
                if (pattern != null) {
                    noUndeterminedVariables = false;
                }
                ++i;
            }
            if (noUndeterminedVariables) {
                return null;
            }
            i = 0;
            while (i < arity) {
                if (patterns[i] == null) {
                    patterns[i] = Expressions.blank(parameters[i].getType());
                }
                ++i;
            }
            return new EApply(9223372034707292160L, apply.getEffect(), apply.getFunction().copy(this.context), patterns);
        }
        return null;
    }

    private void generateMatchingRules(DecomposedRule decomposed, Variable[] sourceVariables) {
        decomposed.ruleMatchingRelation = new LocalRelation(decomposed.rule.name.name + "_match", Types.getTypes(sourceVariables));
        this.ruleSourceMatchRelations.put((Object)decomposed.rule, (Object)decomposed.ruleMatchingRelation);
        this.sourceMatchingRules.add(new ERuleset.DatalogRule(decomposed.rule.location, decomposed.ruleMatchingRelation, Expressions.vars(sourceVariables), new QConjunction(decomposed.sourceQueries.toArray(new Query[decomposed.sourceQueries.size()])), sourceVariables));
        for (QMapping mapping : decomposed.targetMappings) {
            this.sourceMatchingRules.add(new ERuleset.DatalogRule(decomposed.rule.location, this.getMapping((MappingRelation)mapping.mappingRelation).relation, new Expression[]{mapping.parameters[0].copy(this.context)}, new QAtom((SCLRelation)decomposed.ruleMatchingRelation, Type.EMPTY_ARRAY, Expressions.vars(sourceVariables)), sourceVariables));
        }
    }

    static class Mapping {
        LocalRelation relation;
        Variable umap;

        Mapping() {
        }
    }

    private static class PatternAnalyzer
    implements VariableProcedure {
        THashSet<Variable> variableSet;
        TObjectIntHashMap<Variable> mappedVariableUseCount;
        boolean containsVariables;

        public PatternAnalyzer(THashSet<Variable> variableSet, TObjectIntHashMap<Variable> mappedVariableUseCount) {
            this.variableSet = variableSet;
            this.mappedVariableUseCount = mappedVariableUseCount;
        }

        @Override
        public void execute(long location, Variable variable) {
            if (!this.variableSet.contains((Object)variable)) {
                return;
            }
            this.mappedVariableUseCount.adjustOrPutValue((Object)variable, 1, 1);
            this.containsVariables = true;
        }
    }
}

