/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.names.Named;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.DelegateConstant;
import org.simantics.scl.compiler.internal.codegen.optimization.Optimization;
import org.simantics.scl.compiler.internal.codegen.optimization.OptimizationMap;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetFunctions;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class SCLConstant
extends DelegateConstant
implements Named {
    public Name name;
    public SSAFunction definition;
    public SSAFunction inlinableDefinition;
    public int inlineArity = Integer.MAX_VALUE;
    public int inlinePhaseMask = -1;
    public boolean isPrivate = false;
    static int inlineCount = 0;

    public SCLConstant(Name name, Type type) {
        super(type);
        this.name = name;
    }

    public void setInlineArity(int inlineArity, int inlinePhaseMask) {
        this.inlineArity = inlineArity;
        this.inlinePhaseMask = inlinePhaseMask;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setDefinition(SSAFunction definition) {
        this.definition = definition;
    }

    public SSAFunction getDefinition() {
        return this.definition;
    }

    @Override
    public void inline(SSASimplificationContext context, LetApply apply) {
        if (this.inlineTailCallToSelf(context, apply)) {
            return;
        }
        if (this.basicInline(context, apply)) {
            return;
        }
        this.trySpecialize(context, apply);
        Optimization opt = (Optimization)OptimizationMap.OPTIMIZATIONS.get((Object)this.name);
        if (opt != null) {
            opt.inline(context, apply);
        }
    }

    private boolean canInlineInPhase(int phase) {
        return (this.inlinePhaseMask >> phase & 1) == 1;
    }

    private boolean basicInline(SSASimplificationContext context, LetApply apply) {
        SSAFunction def;
        if (!this.canInlineInPhase(context.getPhase())) {
            return false;
        }
        ValRef functionRef = apply.getFunction();
        ValRef[] parameters = apply.getParameters();
        SSAFunction sSAFunction = def = this.inlinableDefinition == null ? this.definition : this.inlinableDefinition;
        if (parameters.length < this.inlineArity && (!this.isPrivate || parameters.length != def.getArity() || this.hasMoreThanOneOccurences())) {
            return false;
        }
        if (this.isPrivate && !this.hasMoreThanOneOccurences()) {
            context.removeConstant(this.name);
        } else {
            def = (SSAFunction)def.copy();
        }
        if (parameters.length >= def.getArity()) {
            if (parameters.length != def.getArity()) {
                apply.split(def.getArity());
            }
            apply.inline(def);
            context.markModified("SCLConstant.beta-constant " + String.valueOf(this.getName()));
        } else {
            def.applyTypes(functionRef.getTypeParameters());
            def.apply(apply.lineNumber, parameters);
            def.setTarget(apply.getTarget());
            new LetFunctions(def).insertBefore(apply);
            apply.remove();
            context.markModified("SCLConstant.partial-beta-constant " + String.valueOf(this.getName()));
        }
        return true;
    }

    private boolean inlineTailCallToSelf(SSASimplificationContext context, LetApply apply) {
        SSAFunction thisFunction = apply.getParent().getParent();
        if (thisFunction != this.definition) {
            return false;
        }
        ValRef ref = apply.getTarget().getOccurrence();
        if (ref == null || ref.getNext() != null) {
            return false;
        }
        if (!(ref.getParent() instanceof Jump)) {
            return false;
        }
        Jump jump = (Jump)ref.getParent();
        if (jump.getParameters().length != 1) {
            return false;
        }
        if (jump.getTarget().getBinding() != thisFunction.getReturnCont()) {
            return false;
        }
        if (apply.getParameters().length != thisFunction.getArity()) {
            return false;
        }
        jump.getTarget().remove();
        jump.setTarget(thisFunction.getFirstBlock().createOccurrence());
        jump.setParameters(apply.getParameters());
        apply.getFunction().remove();
        apply.detach();
        context.markModified("SCLConstant.simplify-tail-call");
        return true;
    }

    private void trySpecialize(SSASimplificationContext context, LetApply apply) {
        if (!this.isPrivate) {
            return;
        }
        if (this.hasMoreThanOneOccurences()) {
            return;
        }
        if (apply.getParent().getParent() == this.definition) {
            return;
        }
        ValRef functionRef = apply.getFunction();
        Type[] pValues = functionRef.getTypeParameters();
        boolean hasComplexTypes = false;
        Type[] typeArray = pValues;
        int n = pValues.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (!(Types.canonical(type) instanceof TVar)) {
                hasComplexTypes = true;
                break;
            }
            ++n2;
        }
        if (hasComplexTypes) {
            TVar[] pVarsTail;
            TVar[] pVars = this.definition.getTypeParameters();
            if (pVars.length == pValues.length) {
                pVarsTail = TVar.EMPTY_ARRAY;
            } else {
                pVarsTail = Arrays.copyOfRange(pVars, pValues.length, pVars.length);
                pVars = Arrays.copyOf(pVars, pValues.length);
            }
            this.type = Types.instantiate(this.type, pValues);
            this.definition.replace(pVars, pValues);
            Type[] newParameters = Types.freeVarsArray(pValues);
            this.type = Types.forAll((TVar[])newParameters, this.type);
            functionRef.setTypeParameters(newParameters);
            this.definition.setTypeParameters(Types.concat((TVar[])newParameters, pVarsTail));
            context.markModified("SCLConstant.specialize-types");
        }
        if (!this.definition.getFirstBlock().hasNoOccurences()) {
            return;
        }
        ValRef[] parameters = apply.getParameters();
        ValRef[] specialization = null;
        int arity = Math.min(parameters.length, this.definition.getArity());
        int i = 0;
        while (i < arity) {
            Val val = parameters[i].getBinding();
            if (val instanceof Constant) {
                if (specialization == null) {
                    specialization = new ValRef[arity];
                }
                specialization[i] = parameters[i];
            }
            ++i;
        }
        if (specialization != null) {
            this.specialize(context, apply, specialization);
        }
    }

    private void specialize(SSASimplificationContext context, LetApply apply, ValRef[] specialization) {
        ValRef[] oldParameters = apply.getParameters();
        int newParameterCount = oldParameters.length - specialization.length;
        int i = 0;
        while (i < specialization.length) {
            if (specialization[i] == null) {
                ++newParameterCount;
            }
            ++i;
        }
        if (newParameterCount == 0) {
            apply.getTarget().replaceBy(apply.getFunction());
            apply.remove();
        } else {
            ValRef[] newParameters = new ValRef[newParameterCount];
            int k = 0;
            int i2 = 0;
            while (i2 < specialization.length) {
                if (specialization[i2] == null) {
                    newParameters[k++] = oldParameters[i2];
                } else {
                    oldParameters[i2].remove();
                }
                ++i2;
            }
            i2 = specialization.length;
            while (i2 < oldParameters.length) {
                newParameters[k++] = oldParameters[i2];
                ++i2;
            }
            apply.setParameters(newParameters);
        }
        SSABlock firstBlock = this.definition.getFirstBlock();
        BoundVar[] parameters = firstBlock.getParameters();
        ArrayList<BoundVar> newParameters = new ArrayList<BoundVar>(parameters.length);
        int i3 = 0;
        while (i3 < specialization.length) {
            if (specialization[i3] != null) {
                parameters[i3].replaceBy(specialization[i3]);
            } else {
                newParameters.add(parameters[i3]);
            }
            ++i3;
        }
        i3 = specialization.length;
        while (i3 < parameters.length) {
            newParameters.add(parameters[i3]);
            ++i3;
        }
        firstBlock.setParameters(newParameters.toArray(new BoundVar[newParameters.size()]));
        this.type = this.definition.getType();
        context.markModified("SCLConstant.specialize");
    }

    public String toString() {
        char c = this.name.name.charAt(0);
        if (Character.isJavaIdentifierStart(c) || this.name.name.charAt(0) == '(' || c == '[') {
            return this.name.name;
        }
        return "(" + this.name.name + ")";
    }

    @Override
    public Name getName() {
        return this.name;
    }

    public Constant getBase() {
        return this.base;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    private boolean simplifyConstantFunction(SSASimplificationContext context) {
        ValRef constant = this.definition.isEqualToConstant();
        if (constant == null) {
            return false;
        }
        Val binding = constant.getBinding();
        if (binding == this) {
            return false;
        }
        if (binding instanceof Constant) {
            this.replaceBy(binding, this.definition.getTypeParameters(), constant.getTypeParameters());
            if (this.isPrivate) {
                this.definition.destroy();
                context.removeConstant(this.name);
            }
            context.markModified("SCLConstant.simplify-constant");
            return true;
        }
        return false;
    }

    public void simplify(SSASimplificationContext context) {
        if (!this.hasNoOccurences() && this.simplifyConstantFunction(context)) {
            return;
        }
        this.definition.simplify(context);
        if (this.inlineArity == Integer.MAX_VALUE && this.definition.isSimpleEnoughForInline()) {
            this.inlineArity = this.definition.getArity();
            this.inlinableDefinition = (SSAFunction)this.definition.copy();
            context.markModified("mark inlineable " + String.valueOf(this.name));
        }
    }

    public void saveInlinableDefinition() {
        if (this.inlineArity < Integer.MAX_VALUE) {
            this.inlinableDefinition = (SSAFunction)this.definition.copy();
        }
    }

    public void cleanup() {
        if (this.definition != null) {
            this.definition.cleanup();
        }
        if (this.inlinableDefinition != null) {
            this.inlinableDefinition.cleanup();
        }
    }
}

