/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.adapters;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.FreshEscapedName;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.representation.Root;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;

public class SystemResourcePasteImportAdvisor
implements IImportAdvisor {
    protected Resource root;
    protected Resource library;
    protected Resource model;
    protected String singleType = null;
    protected Map<String, String> nameMappings = new HashMap<String, String>();

    public SystemResourcePasteImportAdvisor(ReadGraph graph, Resource library) throws DatabaseException {
        this.library = library;
        this.model = (Resource)graph.syncRequest((Read)new PossibleModel(library));
    }

    public Resource getTarget() {
        return this.library;
    }

    public Resource analyzeType(ReadGraph graph, Root root) throws DatabaseException {
        return null;
    }

    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        if ("%model".equals(root.name)) {
            return this.model;
        }
        this.analyzeType(graph, root);
        String type = root.type;
        if (this.singleType != null) {
            if (!type.equals(this.singleType)) {
                throw new DatabaseException("Paste of a set of different types of objects is not supported.");
            }
        } else {
            this.singleType = type;
        }
        String newName = this.newName(graph, this.library, root.name);
        this.nameMappings.put(root.name, newName);
        return null;
    }

    public String newName(ReadGraph graph, Resource library, String name) throws DatabaseException {
        return (String)graph.syncRequest((Read)new FreshEscapedName(library, GraphFileResource.getInstance((ReadGraph)graph).HasSystemResource, name));
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        this.root = graph.newResource();
        String name = root.name;
        String newName = this.nameMappings.get(name);
        graph.addLiteral(this.root, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
        return this.root;
    }

    public Resource getRoot() {
        return this.root;
    }

    public void attachRoot(WriteGraph graph) throws DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(this.library, gf.Folder)) {
            if (graph.isInstanceOf(this.root, gf.Folder)) {
                graph.claim(this.library, gf.HasFolder, this.root);
                return;
            }
            if (graph.isInstanceOf(this.root, gf.File)) {
                graph.claim(this.library, gf.HasFile, this.root);
                return;
            }
        }
        throw new DatabaseException("Unknown type, cannot attach copied resource " + String.valueOf(this.root));
    }
}

