/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import org.simantics.utils.ui.ExceptionUtils;

public class ExperimentExistenceWatchdog {
    private Session session = Simantics.getSession();
    private final Resource experimentResource;
    private IExperiment experiment;
    private final ParametrizedRead<Resource, Boolean> inputValidator;
    private InputListener inputListener;

    public static ExperimentExistenceWatchdog activate(IExperiment experiment, Resource experimentResource) {
        ExperimentExistenceWatchdog validator = new ExperimentExistenceWatchdog(experiment, experimentResource, (ParametrizedRead<Resource, Boolean>)InputValidationCombinators.hasURI());
        validator.attachExperimentListener();
        validator.activateValidation();
        return validator;
    }

    private ExperimentExistenceWatchdog(IExperiment experiment, Resource experimentResource, ParametrizedRead<Resource, Boolean> inputValidator) {
        this.experiment = experiment;
        this.experimentResource = experimentResource;
        this.inputValidator = inputValidator;
    }

    private void attachExperimentListener() {
        this.experiment.addListener(new IExperimentListener(){

            public void stateChanged(ExperimentState state) {
                if (state == ExperimentState.DISPOSED && !ExperimentExistenceWatchdog.this.isDisposed()) {
                    ExperimentExistenceWatchdog.this.dispose();
                }
            }
        });
    }

    public void dispose() {
        this.deactivateValidation();
        this.experiment = null;
        this.session = null;
    }

    protected boolean isDisposed() {
        return this.session == null || this.experimentResource == null || this.experiment == null;
    }

    public synchronized void activateValidation() {
        if (this.isDisposed()) {
            throw new IllegalStateException(String.valueOf(this) + " is disposed");
        }
        if (this.inputListener != null) {
            return;
        }
        this.inputListener = new InputListener();
        this.session.asyncRequest(this.validationRequest(), (Listener)this.inputListener);
    }

    public synchronized void deactivateValidation() {
        if (this.isDisposed()) {
            throw new IllegalStateException(String.valueOf(this) + " is disposed");
        }
        if (this.inputListener == null) {
            return;
        }
        this.inputListener.dispose();
        this.inputListener = null;
    }

    private Read<Boolean> validationRequest() {
        return new UnaryRead<Resource, Boolean>(this.experimentResource){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return (Boolean)graph.syncRequest(ExperimentExistenceWatchdog.this.inputValidator.get((Object)ExperimentExistenceWatchdog.this.experimentResource));
            }
        };
    }

    private static void scheduleExperimentShutdown(final IExperiment experiment) {
        DatabaseJob job = new DatabaseJob("Experiment Shutdown Watchdog"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Shutdown", (int)100000);
                try {
                    experiment.shutdown((IProgressMonitor)mon.newChild(100000));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.schedule();
    }

    private class InputListener
    extends ListenerAdapter<Boolean> {
        private boolean disposed = false;

        private InputListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void execute(Boolean evaluation) {
            if (!Boolean.TRUE.equals(evaluation)) {
                ExperimentExistenceWatchdog.scheduleExperimentShutdown(ExperimentExistenceWatchdog.this.experiment);
            }
        }

        public void exception(Throwable t) {
            ExceptionUtils.logError((String)"ResourceEditorSupport.InputListener received an unexpected exception.", (Throwable)t);
        }

        public boolean isDisposed() {
            return this.disposed || ExperimentExistenceWatchdog.this.isDisposed();
        }
    }
}

