/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.userComponent;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.EnumerationMap;
import org.simantics.db.common.request.IsEnumeratedValue;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.NewSymbol;
import org.simantics.modeling.userComponent.TypeConversion;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.utils.strings.AlphanumComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTypeCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentTypeCommands.class);

    public static void applyCode(WriteGraph g, Resource componentType, String code) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        g.claimLiteral(componentType, STR.ProceduralComponentType_code, (Object)code, (Binding)Bindings.STRING);
    }

    public static Resource createConnectionPoint(WriteGraph g, Resource componentType, Resource cp) throws DatabaseException {
        return StructuralUtils.createConnectionPoint((WriteGraph)g, (Resource)componentType, (Resource)cp);
    }

    public static Resource createMonitorPropertyWithDefaults(WriteGraph g, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Resource monitorType = g.getPossibleObject(componentType, STR.ComponentType_HasDefaultMonitorValueType);
        if (monitorType == null) {
            monitorType = MOD.MonitorValue;
        }
        Resource relation = ComponentTypeCommands.createPropertyWithDefaultsBase(g, componentType, "newProperty");
        g.claim(relation, L0.HasRange, monitorType);
        Resource assertion = g.newResource();
        g.claim(componentType, L0.Asserts, assertion);
        g.claim(assertion, L0.InstanceOf, L0.Assertion);
        g.claim(assertion, L0.HasPredicate, relation);
        Resource value = g.newResource();
        g.claim(value, L0.InstanceOf, monitorType);
        g.claimLiteral(value, L0.HasValueType, L0.String, (Object)"Double", (Binding)Bindings.STRING);
        g.claimLiteral(value, L0.SCLValue_expression, L0.String, (Object)"", (Binding)Bindings.STRING);
        g.claim(assertion, L0.HasObject, value);
        return relation;
    }

    public static Resource createPropertyWithDefaults(WriteGraph g, Resource componentType) throws DatabaseException {
        g.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource relation = ComponentTypeCommands.createPropertyWithDefaultsBase(g, componentType, "newProperty");
        Resource assertion = g.newResource();
        g.claim(componentType, L0.Asserts, assertion);
        g.claim(assertion, L0.InstanceOf, L0.Assertion);
        g.claim(assertion, L0.HasPredicate, relation);
        Resource value = g.newResource();
        g.claim(value, L0.InstanceOf, L0.Literal);
        g.claimLiteral(value, L0.HasDataType, L0.DataType, (Object)Datatypes.DOUBLE, Bindings.getBindingUnchecked(Datatype.class));
        g.claimLiteral(value, L0.HasValueType, L0.String, (Object)"Double", (Binding)Bindings.STRING);
        g.claimValue(value, (Object)0.0, (Binding)Bindings.DOUBLE);
        g.claim(assertion, L0.HasObject, value);
        return relation;
    }

    public static Resource createPropertyWithDefaultsBase(WriteGraph g, Resource componentType, String defaultName) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        String name = NameUtils.findFreshEscapedName((ReadGraph)g, (String)defaultName, (Resource)componentType);
        Resource relation = g.newResource();
        g.claim(relation, L0.SubrelationOf, null, L0.HasProperty);
        boolean hadProperty = false;
        for (Resource type : g.getObjects(componentType, STR.ComponentType_HasDefaultPropertyRelationType)) {
            if (g.isInheritedFrom(type, STR.Property)) {
                hadProperty = true;
            }
            g.claim(relation, L0.InstanceOf, type);
        }
        if (!hadProperty) {
            g.claim(relation, L0.InstanceOf, STR.Property);
        }
        g.claimLiteral(relation, L0.HasName, (Object)name);
        g.claim(componentType, L0.ConsistsOf, L0.PartOf, relation);
        g.claim(relation, L0.HasDomain, L0.DomainOf, componentType);
        Resource invRelation = g.newResource();
        g.claim(invRelation, L0.SubrelationOf, null, L0.PropertyOf);
        g.claim(relation, L0.ConsistsOf, L0.PartOf, invRelation);
        g.claimLiteral(invRelation, L0.HasName, (Object)"Inverse");
        g.claim(relation, L0.InverseOf, invRelation);
        g.claimLiteral(relation, L0.RequiresValueType, (Object)"Double");
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)g);
        Resource category = g.getPossibleObject(relation, SEL.HasStandardPropertyInfo);
        if (category == null) {
            g.claim(relation, SEL.HasStandardPropertyInfo, MOD.UserDefinedPropertyInfo);
        }
        if (!g.isInstanceOf(relation, SEL.GenericParameterType)) {
            g.claim(relation, L0.InstanceOf, SEL.GenericParameterType);
        }
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Created new property " + name + " for " + String.valueOf(g.getRelatedValue2(componentType, L0.HasName, (Binding)Bindings.STRING)) + " " + componentType.toString()));
        return relation;
    }

    public static Resource createProperty(WriteGraph graph, Resource componentType, String name, String type, String unit, String range, String label, String description) throws DatabaseException {
        Resource property = ComponentTypeCommands.createPropertyWithDefaults(graph, componentType);
        ComponentTypeCommands.rename(graph, property, name);
        ComponentTypeCommands.setRequiredType(graph, componentType, property, type);
        ComponentTypeCommands.convertDefaultValue(graph, componentType, property, type);
        if (!type.equals("String")) {
            ComponentTypeCommands.setUnit(graph, componentType, property, unit);
            ComponentTypeCommands.setRange(graph, componentType, property, range);
        }
        ComponentTypeCommands.setLabel(graph, property, label);
        ComponentTypeCommands.setDescription(graph, property, description);
        return property;
    }

    public static void removeProperty(WriteGraph g, Resource componentType, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Resource assertion : g.getObjects(property, L0.HasPredicateInverse)) {
            g.deny(assertion);
        }
        g.deny(property);
        String name = (String)g.getPossibleRelatedValue2(componentType, L0.HasName);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Removed property " + String.valueOf(property) + " from component/annotation " + name + ", resource " + String.valueOf(componentType)));
    }

    public static void rename(WriteGraph g, Resource resource, String newName) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        String prevName = (String)g.getPossibleRelatedValue2(resource, L0.HasName);
        g.claimLiteral(resource, L0.HasName, (Object)newName);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Renamed component/annotation type from " + prevName + " to " + newName + ", resource " + String.valueOf(resource)));
    }

    public static void setRequiredType(WriteGraph g, Resource property, String requiredType) throws DatabaseException {
        ComponentTypeCommands.setRequiredType(g, null, property, requiredType);
    }

    public static void setRequiredType(WriteGraph g, Resource componentType, Resource property, String requiredType) throws DatabaseException {
        ComponentTypeCommands.setRequiredType(g, componentType, property, requiredType, null);
    }

    public static void setRequiredType(WriteGraph g, Resource componentType, Resource property, String requiredType, Resource possibleType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        g.claimLiteral(property, L0.RequiresValueType, (Object)requiredType);
        if (componentType != null) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
            for (Resource assertedValue : g.getAssertedObjects(componentType, property)) {
                if (!g.isInstanceOf(assertedValue, STR.MonitorValue)) continue;
                g.claimLiteral(assertedValue, L0.HasValueType, (Object)requiredType);
            }
        }
        if (g.hasStatement(property, L0.HasRange)) {
            g.deny(property, L0.HasRange);
        }
        if (possibleType != null) {
            if (g.hasStatement(possibleType, L0.Enumeration)) {
                g.claim(property, L0.HasRange, possibleType);
            } else if (g.isInheritedFrom(possibleType, MOD.MonitorValue)) {
                g.claim(property, L0.HasRange, possibleType);
            }
        }
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Set required type " + requiredType + " for component/annotation " + String.valueOf(property)));
    }

    public static void editType(WriteGraph graph, Resource componentType, Resource property, boolean convertDefaultValue, String newValue) throws DatabaseException {
        ComponentTypeCommands.editType(graph, componentType, property, convertDefaultValue, newValue, null);
    }

    public static void editType(WriteGraph graph, Resource componentType, Resource property, boolean convertDefaultValue, String newValue, Resource possibleType) throws DatabaseException {
        ComponentTypeCommands.setRequiredType(graph, componentType, property, newValue, possibleType);
        if (convertDefaultValue) {
            ComponentTypeCommands.convertDefaultValue(graph, componentType, property, newValue, possibleType);
            for (Resource indexRoot : Layer0Utils.listIndexRoots((ReadGraph)graph)) {
                for (Resource instance : QueryIndexUtils.searchByTypeShallow((ReadGraph)graph, (Resource)indexRoot, (Resource)componentType)) {
                    ComponentTypeCommands.convertInstantiatedValue(graph, instance, property, newValue, componentType);
                }
            }
        }
    }

    public static Resource getAssertedObject(ReadGraph g, Resource type, Resource relation) throws DatabaseException {
        return (Resource)((Map)g.syncRequest((Read)new AssertionMap(type))).get(relation);
    }

    public static void setMonitorExpression(WriteGraph g, Resource type, Resource relation, String valueText) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)g, type, relation);
        if (object == null) {
            LOGGER.warn("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)g, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)type) + ".");
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        g.claimLiteral(object, L0.SCLValue_expression, (Object)valueText, (Binding)Bindings.STRING);
    }

    public static void setDefaultValue(WriteGraph g, Resource type, Resource relation, String valueText) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)g, type, relation);
        if (object == null) {
            LOGGER.warn("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)g, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)type) + ".");
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource range = g.getPossibleObject(relation, L0.HasRange);
        if (range != null && g.hasStatement(range, L0.Enumeration)) {
            Map values = (Map)g.syncRequest((Read)new EnumerationMap(range));
            Resource value = (Resource)values.get(valueText);
            if (value != null) {
                for (Resource assertion : g.getObjects(type, L0.Asserts)) {
                    Resource p = g.getSingleObject(assertion, L0.HasPredicate);
                    if (!p.equals(relation)) continue;
                    g.deny(assertion, L0.HasObject, object);
                    g.claim(assertion, L0.HasObject, value);
                }
            }
            return;
        }
        if (valueText.length() > 0 && valueText.charAt(0) == '=') {
            String expression = valueText.substring(1);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
            if (!g.isInstanceOf(object, MOD.SCLValue)) {
                Resource assertion = g.getSingleObject(object, L0.HasObjectInverse);
                g.deny(assertion, L0.HasObject, object);
                object = g.newResource();
                g.claim(object, L0.InstanceOf, MOD.SCLValue);
                g.claim(assertion, L0.HasObject, object);
            }
            g.claimLiteral(object, L0.SCLValue_expression, L0.String, (Object)expression, (Binding)Bindings.STRING);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)g, (String)("Modified " + String.valueOf(g.getRelatedValue2(relation, Layer0.getInstance((ReadGraph)g).HasName, (Binding)Bindings.STRING)) + " with new expression '" + expression + "'"));
        } else {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
            if (g.isInstanceOf(object, MOD.SCLValue)) {
                Resource assertion = g.getSingleObject(object, L0.HasObjectInverse);
                g.deny(assertion, L0.HasObject, object);
                object = g.newResource();
                String sclType = (String)g.getRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING);
                Datatype newDatatype = TypeConversion.convertSCLTypeToDatatype(sclType);
                g.claim(object, L0.InstanceOf, L0.Literal);
                Binding ntb = Bindings.getBindingUnchecked(Datatype.class);
                g.claimLiteral(object, L0.HasDataType, L0.DataType, (Object)newDatatype, ntb);
                g.claim(assertion, L0.HasObject, object);
            }
            Datatype dt = g.getDataType(object);
            Binding binding = Bindings.getBinding((Datatype)dt);
            try {
                Object value = binding.parseValue(valueText, new DataValueRepository());
                g.claimValue(object, value, binding);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)g, (String)("Modified " + String.valueOf(g.getRelatedValue2(relation, Layer0.getInstance((ReadGraph)g).HasName, (Binding)Bindings.STRING)) + " with new value " + value.toString()));
            }
            catch (DataTypeSyntaxError e) {
                e.printStackTrace();
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setUnit(WriteGraph graph, Resource type, Resource relation, String unit) throws DatabaseException {
        Datatype dt;
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)graph, type, relation);
        if (object == null) {
            LOGGER.warn("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)graph, (Resource)type) + ".");
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        boolean hasRequiresDataType = graph.hasStatement(relation, L0X.RequiresDataType);
        if (hasRequiresDataType && (dt = graph.getDataType(object)) instanceof NumberType) {
            NumberType nt = (NumberType)Bindings.DATATYPE.cloneUnchecked((Object)dt);
            nt.setUnit(unit);
            graph.claimLiteral(object, L0.HasDataType, L0.DataType, (Object)nt, Bindings.DATATYPE);
            graph.claimLiteral(relation, L0X.RequiresDataType, L0.DataType, (Object)nt, Bindings.DATATYPE);
        }
        String oldUnit = (String)graph.getPossibleRelatedValue2(relation, L0X.HasUnit, (Binding)Bindings.STRING);
        if (unit != null) {
            graph.claimLiteral(relation, L0X.HasUnit, L0.String, (Object)unit, (Binding)Bindings.STRING);
        } else {
            graph.denyValue(relation, L0X.HasUnit);
        }
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Set unit from " + oldUnit + " to " + unit + " for component/annotation " + String.valueOf(type) + " property " + String.valueOf(relation)));
    }

    public static void setRange(WriteGraph graph, Resource type, Resource relation, String newRange) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)graph, type, relation);
        if (object == null) {
            LOGGER.warn("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)graph, (Resource)type) + ".");
            return;
        }
        Datatype dt = graph.getDataType(object);
        if (dt instanceof NumberType) {
            NumberType nt = (NumberType)dt;
            Binding ntb = Bindings.getBindingUnchecked(Datatype.class);
            nt.setRange(newRange);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            graph.claimLiteral(object, L0.HasDataType, L0.DataType, (Object)nt, ntb);
            graph.claimLiteral(relation, L0X.RequiresDataType, L0.DataType, (Object)nt, ntb);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Setted range " + newRange + " for component/annotation " + String.valueOf(type)));
        }
    }

    public static Tuple getDatatypeValueAndBinding(ReadGraph g, Resource object, String newSCLType) throws DatabaseException {
        Object newValue;
        Datatype newDatatype = TypeConversion.convertSCLTypeToDatatype(newSCLType);
        if (newDatatype == null) {
            LOGGER.warn("Couldn't convert default value to <" + newSCLType + ">.");
            return null;
        }
        Binding newBinding = Bindings.getBinding((Datatype)newDatatype);
        Datatype oldDatatype = g.getDataType(object);
        Binding oldBinding = Bindings.getBinding((Datatype)oldDatatype);
        Object oldValue = g.getValue(object, oldBinding);
        try {
            newValue = Bindings.adapt((Object)oldValue, (Binding)oldBinding, (Binding)newBinding);
        }
        catch (AdaptException adaptException) {
            try {
                newValue = newBinding.createDefault();
            }
            catch (BindingException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        return new Tuple3((Object)newDatatype, newValue, (Object)newBinding);
    }

    public static void convertDefaultValue(WriteGraph g, Resource type, Resource relation, String newSCLType) throws DatabaseException {
        ComponentTypeCommands.convertDefaultValue(g, type, relation, newSCLType, null);
    }

    private static Resource findAssertionWithPO(ReadGraph graph, Resource possibleType, Resource predicate, Resource object) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource assertion : graph.getObjects(possibleType, L0.Asserts)) {
            Resource p = graph.getSingleObject(assertion, L0.HasPredicate);
            Resource o = graph.getSingleObject(assertion, L0.HasObject);
            if (!predicate.equals(p) || !object.equals(o)) continue;
            return assertion;
        }
        return null;
    }

    public static void convertDefaultValue(WriteGraph g, Resource type, Resource relation, String newSCLType, Resource possibleType) throws DatabaseException {
        Tuple tuple;
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)g, type, relation);
        if (object == null) {
            LOGGER.warn("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)g, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)type) + ".");
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        if (possibleType != null && g.hasStatement(possibleType, L0.Enumeration)) {
            if (!g.isInstanceOf(object, possibleType)) {
                String firstKey;
                Map enumMap = (Map)g.syncRequest((Read)new EnumerationMap(possibleType));
                Resource defaultValue = (Resource)enumMap.get(firstKey = (String)Collections.min(enumMap.keySet(), AlphanumComparator.COMPARATOR));
                if (defaultValue != null) {
                    Resource assertion = ComponentTypeCommands.findAssertionWithPO((ReadGraph)g, type, relation, object);
                    if (assertion != null) {
                        g.deny(assertion, L0.HasObject);
                        g.claim(assertion, L0.HasObject, defaultValue);
                        return;
                    }
                    Layer0Utils.assert_((WriteGraph)g, (Resource)type, (Resource)relation, (Resource)defaultValue);
                    return;
                }
            } else {
                return;
            }
        }
        if ((tuple = ComponentTypeCommands.getDatatypeValueAndBinding((ReadGraph)g, object, newSCLType)) == null) {
            return;
        }
        if (((Boolean)g.sync((ReadInterface)new IsEnumeratedValue(object))).booleanValue()) {
            Resource assertion = ComponentTypeCommands.findAssertionWithPO((ReadGraph)g, type, relation, object);
            object = g.newResource();
            g.claim(object, L0.InstanceOf, L0.Literal);
            if (assertion != null) {
                g.deny(assertion, L0.HasObject);
                g.claim(assertion, L0.HasObject, object);
            }
        }
        g.claimLiteral(object, L0.HasDataType, L0.DataType, tuple.get(0), Bindings.getBindingUnchecked(Datatype.class));
        g.claimLiteral(object, L0.HasValueType, g.getRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING), (Binding)Bindings.STRING);
        g.claimValue(object, tuple.get(1), (Binding)tuple.get(2));
    }

    public static void convertInstantiatedValue(WriteGraph g, Resource instance, Resource relation, String newSCLType) throws DatabaseException {
        ComponentTypeCommands.convertInstantiatedValue(g, instance, relation, newSCLType, null);
    }

    public static void convertInstantiatedValue(WriteGraph g, Resource instance, Resource relation, String newSCLType, Resource possibleType) throws DatabaseException {
        Statement stm = g.getPossibleStatement(instance, relation);
        if (stm != null && !stm.isAsserted(instance)) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            Resource object = stm.getObject();
            if (((Boolean)g.sync((ReadInterface)new IsEnumeratedValue(object))).booleanValue()) {
                if (!g.isInstanceOf(object, possibleType)) {
                    g.deny(instance, relation);
                }
                return;
            }
            if (!g.isInstanceOf(object, L0.Literal)) {
                return;
            }
            Tuple tuple = ComponentTypeCommands.getDatatypeValueAndBinding((ReadGraph)g, object, newSCLType);
            g.claimLiteral(object, L0.HasDataType, L0.DataType, tuple.get(0), Bindings.getBindingUnchecked(Datatype.class));
            g.claimLiteral(object, L0.HasValueType, g.getRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING), (Binding)Bindings.STRING);
            g.claimValue(object, tuple.get(1), (Binding)tuple.get(2));
        }
    }

    public static void setLabel(WriteGraph graph, Resource relation, String newLabel) throws DatabaseException {
        ComponentTypeCommands.setProperty(graph, relation, Layer0.getInstance((ReadGraph)graph).HasLabel, newLabel);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Setted label " + newLabel + " for component/annotation " + String.valueOf(relation)));
    }

    public static void setDescription(WriteGraph graph, Resource relation, String newDescription) throws DatabaseException {
        ComponentTypeCommands.setProperty(graph, relation, Layer0.getInstance((ReadGraph)graph).HasDescription, newDescription);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Setted description " + newDescription + " for component/annotation " + String.valueOf(relation)));
    }

    public static void setProperty(WriteGraph graph, Resource relation, Resource property, String newValue) throws DatabaseException {
        if (newValue != null) {
            graph.claimLiteral(relation, property, (Object)newValue, (Binding)Bindings.STRING);
        } else {
            graph.denyValue(relation, property);
        }
    }

    public static Resource createSymbol(WriteGraph graph, Resource componentType) throws DatabaseException {
        return NewSymbol.createSymbol(graph, componentType);
    }

    public static String camelCaseNameToLabel(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len * 2);
        boolean wasLastUpper = false;
        boolean isFirstEncounteredLetter = true;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            boolean space = Character.isWhitespace(ch);
            if (space) {
                sb.append(ch);
            } else {
                boolean isUpperCaseLetter = Character.isUpperCase(ch);
                boolean isLetterOrDigit = Character.isLetterOrDigit(ch);
                if (!isFirstEncounteredLetter && isUpperCaseLetter && !wasLastUpper && isLetterOrDigit) {
                    sb.append(' ');
                    sb.append(ch);
                } else {
                    if (isLetterOrDigit && isFirstEncounteredLetter) {
                        sb.append(Character.toUpperCase(ch));
                    } else {
                        sb.append(ch);
                    }
                    if (isFirstEncounteredLetter) {
                        isFirstEncounteredLetter = !isLetterOrDigit;
                    }
                }
                wasLastUpper = isUpperCaseLetter;
            }
            ++i;
        }
        return sb.toString();
    }

    public static void saveProceduralCodeWithUC(WriteGraph graph, Resource componentType, String newText) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource code = graph.getPossibleObject(componentType, STR.ProceduralComponentType_code);
        ComponentTypeCommands.saveProceduralCode(graph, code, newText);
    }

    public static void saveProceduralCode(WriteGraph graph, Resource resource, String newText) throws ServiceException {
        graph.claimValue(resource, (Object)newText, (Binding)Bindings.STRING);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Saved Procedural Component Type SCL Code");
    }

    static class AssertionMap
    extends UnaryRead<Resource, Map<Resource, Resource>> {
        public AssertionMap(Resource parameter) {
            super((Object)parameter);
        }

        public Map<Resource, Resource> perform(ReadGraph graph) throws DatabaseException {
            THashMap result = new THashMap();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource assertion : graph.getObjects((Resource)this.parameter, L0.Asserts)) {
                result.put((Object)graph.getSingleObject(assertion, L0.HasPredicate), (Object)graph.getSingleObject(assertion, L0.HasObject));
            }
            return result;
        }
    }
}

