/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.prefs;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public final class DocumentsPreferences {
    public static final String P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS = "documents.preferExternalEditorForEmbeddedDocuments";
    public static final String P_DOCUMENTATION_VIEW_EDITOR_VISIBLE = "documents.documentationViewEditorVisible";
    public static final boolean DEFAULT_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS = false;
    public static final boolean DEFAULT_DOCUMENTATION_VIEW_EDITOR_VISIBLE = true;
    private final ScopedPreferenceStore store;
    public boolean preferExternalEditorForDocuments;
    public boolean documentationViewEditorVisible;

    public static DocumentsPreferences getFactoryDefaults() {
        return new DocumentsPreferences(null, false, true);
    }

    public DocumentsPreferences(ScopedPreferenceStore store, boolean preventSimulationWithErrors, boolean documentationViewEditorVisible) {
        this.store = store;
        this.preferExternalEditorForDocuments = preventSimulationWithErrors;
        this.documentationViewEditorVisible = documentationViewEditorVisible;
    }

    public static ScopedPreferenceStore getStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.document.ui");
    }

    public static DocumentsPreferences getPreferences() {
        return DocumentsPreferences.getPreferences(DocumentsPreferences.getStore());
    }

    public static DocumentsPreferences getPreferences(ScopedPreferenceStore store) {
        boolean peefd = store.getBoolean(P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS);
        boolean dvev = store.getBoolean(P_DOCUMENTATION_VIEW_EDITOR_VISIBLE);
        return new DocumentsPreferences(store, peefd, dvev);
    }

    public void storePreferences() throws IOException {
        this.store.setValue(P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS, this.preferExternalEditorForDocuments);
        this.store.setValue(P_DOCUMENTATION_VIEW_EDITOR_VISIBLE, this.documentationViewEditorVisible);
        if (this.store.needsSaving()) {
            this.store.save();
        }
    }

    public void putPreferences(Preferences node) {
        node.putBoolean(P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS, this.preferExternalEditorForDocuments);
        node.putBoolean(P_DOCUMENTATION_VIEW_EDITOR_VISIBLE, this.documentationViewEditorVisible);
    }

    public String toString() {
        return String.format("[preferExternalEditorForDocuments=%b, documentationViewEditorVisible=%b]", this.preferExternalEditorForDocuments, this.documentationViewEditorVisible);
    }

    public DocumentsPreferences readFrom(DocumentsPreferences other) {
        this.preferExternalEditorForDocuments = other.preferExternalEditorForDocuments;
        this.documentationViewEditorVisible = other.documentationViewEditorVisible;
        return this;
    }
}

