/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.logging.LogProvider;
import org.simantics.logging.internal.Activator;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCollector.class);

    public static Map<String, List<Path>> allLogs() {
        HashMap<String, List<Path>> results = new HashMap<String, List<Path>>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Collecting all logs from declarative services");
        }
        List<LogProvider> logProviders = LogCollector.getLogProviders();
        for (LogProvider logProvider : logProviders) {
            List logs = (List)logProvider.get();
            String key = logProvider.getClass().getSimpleName();
            Collection existing = (Collection)results.get(key);
            if (existing != null) {
                LOGGER.info("Duplicate log providers with name {} exist, merging logs", (Object)key);
                logs.addAll(existing);
            }
            results.put(key, logs);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found logs from {} providers", results.keySet());
        }
        return results;
    }

    private static List<LogProvider> getLogProviders() {
        ServiceReference[] serviceReferences = new ServiceReference[]{};
        String key = LogProvider.class.getName();
        try {
            serviceReferences = Activator.getContext().getAllServiceReferences(key, null);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Could not get service references for {}!", (Object)key, (Object)e);
        }
        if (serviceReferences.length == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No service references found for {}", (Object)key);
            }
            return Collections.emptyList();
        }
        ArrayList<LogProvider> logProviders = new ArrayList<LogProvider>(serviceReferences.length);
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference reference = serviceReferenceArray[n2];
            LogProvider logProvider = (LogProvider)Activator.getContext().getService(reference);
            logProviders.add(logProvider);
            ++n2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found {} log providers", logProviders);
        }
        return logProviders;
    }

    private static String currentLocalDateTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmm"));
    }

    public static String archiveFileName() {
        StringBuilder fileName = new StringBuilder();
        String productName = Platform.getProduct().getName();
        if (productName != null) {
            fileName.append(productName.replaceAll(" ", "_")).append("-");
        }
        fileName.append("logs-").append(LogCollector.currentLocalDateTimeStamp());
        String result = fileName.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved log files name {}", (Object)result);
        }
        return result;
    }

    public static void archiveLogs(String destination) throws IOException {
        LogCollector.archiveLogs(Paths.get(destination, new String[0]));
    }

    private static void archiveLogs(Path destination) throws IOException {
        Path tempDir = Files.createTempDirectory(destination.getFileName().toString(), new FileAttribute[0]);
        try {
            Map<String, List<Path>> allLogs = LogCollector.allLogs();
            for (Map.Entry<String, List<Path>> logEntry : allLogs.entrySet()) {
                Path subFolder = tempDir.resolve(logEntry.getKey());
                Files.createDirectory(subFolder, new FileAttribute[0]);
                for (Path p : logEntry.getValue()) {
                    try {
                        Files.copy(p, subFolder.resolve(p.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not copy {}", (Object)p.toAbsolutePath(), (Object)e);
                    }
                }
            }
            FileUtils.compressZip((String)tempDir.toAbsolutePath().toString(), (String)destination.toAbsolutePath().toString());
        }
        finally {
            FileUtils.delete((Path)tempDir);
        }
    }
}

