/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.DirectStatementProcedure;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleChild;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.PossibleOwner;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.RuntimeEnvironmentRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.NearestOwnerFinder;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDBUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDBUtils.class);

    public static boolean isParent(ReadGraph graph, Resource possibleParent, Resource possibleChild) throws DatabaseException {
        return (Boolean)graph.sync((ReadInterface)new IsParent(possibleParent, possibleChild));
    }

    public static Resource parent(ReadGraph graph, Resource child) throws DatabaseException {
        return graph.getSingleObject(child, Layer0.getInstance((ReadGraph)graph).PartOf);
    }

    public static String possibleRelatedString(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        return (String)graph.getPossibleRelatedValue(subject, relation, (Binding)Bindings.STRING);
    }

    public static Integer possibleRelatedInteger(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        return (Integer)graph.getPossibleRelatedValue(subject, relation, (Binding)Bindings.INTEGER);
    }

    public static Resource getPossibleOwner(ReadGraph graph, Resource resource) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleOwner(resource));
    }

    public static Resource commonAncestor(ReadGraph graph, Resource r1, Resource r2) throws DatabaseException {
        if (r1.equals(r2)) {
            return r1;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<Resource> visited = new HashSet<Resource>();
        visited.add(r1);
        visited.add(r2);
        do {
            if (r1 != null) {
                if ((r1 = graph.getPossibleObject(r1, L0.IsOwnedBy)) == null || visited.add(r1)) continue;
                return r1;
            }
            if (r2 != null) continue;
            return null;
        } while (r2 == null || (r2 = graph.getPossibleObject(r2, L0.IsOwnedBy)) == null || visited.add(r2));
        return r2;
    }

    private static Collection<Resource> getDirectOwners(ReadGraph graph, Resource resource) throws DatabaseException {
        if (resource.equals(graph.getRootLibrary())) {
            return Collections.emptyList();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<Resource> owners = graph.getObjects(resource, L0.IsOwnedBy);
        if (owners.isEmpty()) {
            owners = new THashSet();
            for (Statement statement : graph.getStatements(resource, L0.IsWeaklyRelatedTo)) {
                Resource inverse = graph.getPossibleInverse(statement.getPredicate());
                if (inverse == null || !graph.isSubrelationOf(inverse, L0.IsRelatedTo) || resource.equals(statement.getObject())) continue;
                owners.add(statement.getObject());
            }
        } else if (owners.size() > 1) {
            owners = new HashSet<Resource>(owners);
        }
        return owners;
    }

    @Deprecated
    public static Resource getNearestOwner(ReadGraph graph, Collection<Resource> resources) throws DatabaseException {
        if (resources.size() == 1) {
            return NearestOwnerFinder.getNearestOwner(graph, resources.iterator().next());
        }
        return NearestOwnerFinder.getNearestOwnerFromDirectOwners(graph, resources);
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Resource ... resources) throws DatabaseException {
        if (resources.length == 1) {
            return CommonDBUtils.getClusterSetForNewResource(graph, resources[0]);
        }
        Resource owner = NearestOwnerFinder.getNearestOwnerFromDirectOwners(graph, CollectionUtils.toList((Object[])resources));
        if (owner == null) {
            return null;
        }
        return CommonDBUtils.getClusterSetForNewResource(graph, owner, new HashSet<Resource>());
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Collection<Resource> resources) throws DatabaseException {
        if (resources.size() == 1) {
            return CommonDBUtils.getClusterSetForNewResource(graph, resources.iterator().next());
        }
        Resource owner = NearestOwnerFinder.getNearestOwnerFromDirectOwners(graph, resources);
        return CommonDBUtils.getClusterSetForNewResource(graph, owner, new HashSet<Resource>());
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Resource resource, Set<Resource> visited) throws DatabaseException {
        ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        if (cs.isClusterSet(resource)) {
            return resource;
        }
        Resource owner = CommonDBUtils.getPossibleOwner(graph, resource);
        if (owner == null || owner == resource) {
            return null;
        }
        if (!visited.add(owner)) {
            return null;
        }
        return CommonDBUtils.getClusterSetForNewResource(graph, owner, visited);
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Resource r) throws DatabaseException {
        return CommonDBUtils.getClusterSetForNewResource(graph, r, new HashSet<Resource>());
    }

    public static void selectClusterSet(WriteGraph graph, Collection<Resource> resources) throws DatabaseException {
        Resource clusterSet = CommonDBUtils.getClusterSetForNewResource((ReadGraph)graph, resources);
        if (clusterSet == null) {
            clusterSet = graph.getRootLibrary();
        }
        graph.setClusterSet4NewResource(clusterSet);
    }

    public static void selectClusterSet(WriteGraph graph, Resource ... resources) throws DatabaseException {
        Resource clusterSet = CommonDBUtils.getClusterSetForNewResource((ReadGraph)graph, resources);
        if (clusterSet == null) {
            clusterSet = graph.getRootLibrary();
        }
        graph.setClusterSet4NewResource(clusterSet);
    }

    public static void selectClusterSet(WriteGraph graph, Resource resource) throws DatabaseException {
        Resource clusterSet = CommonDBUtils.getClusterSetForNewResource((ReadGraph)graph, resource);
        if (clusterSet == null) {
            clusterSet = graph.getRootLibrary();
        }
        graph.setClusterSet4NewResource(clusterSet);
    }

    public static List<Resource> objectsWithType(ReadGraph graph, Resource subject, Resource relation, Resource type) throws DatabaseException {
        return new ArrayList<Resource>((Collection)graph.syncRequest((Read)new ObjectsWithType(subject, relation, type)));
    }

    public static Resource possibleObjectWithType(ReadGraph graph, Resource subject, Resource relation, Resource type) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleObjectWithType(subject, relation, type));
    }

    public static List<ClusterUID> listClusters(ReadGraph graph) throws DatabaseException {
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        ClusterUID[] uids = xs.listClusters();
        ArrayList<ClusterUID> result = new ArrayList<ClusterUID>(uids.length);
        ClusterUID[] clusterUIDArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterUID uid = clusterUIDArray[n2];
            result.add(uid);
            ++n2;
        }
        return result;
    }

    public static List<Resource> resourcesByCluster(ReadGraph graph, ClusterUID uid) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        ArrayList<Resource> result = new ArrayList<Resource>();
        int i = 1;
        while (i < 4096) {
            try {
                result.add(ss.getResource(uid.toRID(i)));
            }
            catch (InvalidResourceReferenceException invalidResourceReferenceException) {}
            ++i;
        }
        return result;
    }

    public static List<Statement> directStatements(ReadGraph graph, Resource resource, boolean ignoreVirtual) throws DatabaseException {
        DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
        new DirectStatementProcedure();
        if (ignoreVirtual) {
            return dqs.getDirectPersistentStatements(graph, resource);
        }
        return dqs.getDirectStatements(graph, resource);
    }

    public static List<Resource> garbageResources(ReadGraph graph) throws DatabaseException {
        final SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        TIntArrayList refs = new TIntArrayList();
        TIntArrayList res = new TIntArrayList();
        for (ClusterUID uid : CommonDBUtils.listClusters(graph)) {
            for (Resource r : CommonDBUtils.resourcesByCluster(graph, uid)) {
                boolean hv;
                int sid = ss.getTransientId(r);
                List<Statement> dstms = CommonDBUtils.directStatements(graph, r, true);
                for (Statement stm : dstms) {
                    int oid = ss.getTransientId(stm.getObject());
                    refs.add(sid);
                    refs.add(oid);
                }
                if (dstms.size() == 0 && !(hv = graph.hasValue(r))) continue;
                res.add(sid);
            }
        }
        final TIntHashSet reached = new TIntHashSet();
        int root = ss.getTransientId(graph.getRootLibrary());
        reached.add(root);
        int[] refArray = refs.toArray();
        boolean changes = true;
        while (changes) {
            changes = false;
            int i = 0;
            while (i < refArray.length) {
                int s = refArray[i];
                int o = refArray[i + 1];
                if (reached.contains(s) && reached.add(o)) {
                    changes = true;
                }
                i += 2;
            }
            System.err.println("Reachability iteration, changes = " + changes);
        }
        final ArrayList<Resource> result = new ArrayList<Resource>();
        res.forEach(new TIntProcedure(){

            public boolean execute(int r) {
                if (!reached.contains(r)) {
                    try {
                        result.add(ss.getResource(r));
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Unexpected error while resolving garbage resources.", (Throwable)e);
                    }
                }
                return true;
            }
        });
        return result;
    }

    public static ClusterUID clusterUIDOfResource(ReadGraph graph, Resource resource) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getUID(resource).asCID();
    }

    public static boolean isClusterLoaded(ReadGraph graph, ClusterUID clusterUID) throws DatabaseException {
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        return xs.isClusterLoaded(clusterUID);
    }

    public static void setImmutable(ReadGraph graph, Resource resource, boolean value) throws DatabaseException {
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        xs.setImmutable(resource, value);
    }

    public static Type getSCLType(ReadGraph graph, RuntimeEnvironment runtimeEnvironment, String typeText) throws DatabaseException {
        try {
            return Environments.getType((Environment)runtimeEnvironment.getEnvironment(), (String)typeText);
        }
        catch (SCLExpressionCompilationException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Type getSCLType(ReadGraph graph, Resource resource, String typeText) throws DatabaseException {
        try {
            RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(resource));
            return Environments.getType((Environment)runtimeEnvironment.getEnvironment(), (String)typeText);
        }
        catch (SCLExpressionCompilationException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Resource getPossibleChild(ReadGraph graph, Resource resource, String name) throws DatabaseException {
        return (Resource)graph.sync((ReadInterface)new PossibleChild(resource, name));
    }

    public static Resource getPossibleChild(ReadGraph graph, Resource resource, Resource type, String name) throws DatabaseException {
        Resource child = (Resource)graph.sync((ReadInterface)new PossibleChild(resource, name));
        if (child == null) {
            return null;
        }
        if (!graph.isInstanceOf(child, type)) {
            return null;
        }
        return child;
    }

    public static String getEnumerationValueName(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String label = (String)graph.getPossibleRelatedValue(resource, L0.HasLabel, (Binding)Bindings.STRING);
        if (label != null) {
            return label;
        }
        return CommonDBUtils.safeName(graph, resource);
    }

    private static String safeName(ReadGraph graph, Resource value) throws DatabaseException {
        return (String)graph.syncRequest((Read)new StringAdapterRequest(value));
    }

    public static class StringAdapterRequest
    extends ResourceRead<String> {
        public StringAdapterRequest(Resource resource) {
            super(resource);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            try {
                return (String)graph.adapt(this.resource, String.class);
            }
            catch (AdaptionException adaptionException) {
                return NameUtils.getSafeName(graph, this.resource);
            }
        }
    }
}

