/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.expressions;

import org.simantics.db.ReadGraph;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.modelica.ModelicaWriter;
import org.simantics.sysdyn.representation.expressions.Expression;
import org.simantics.sysdyn.representation.utils.FormatUtils;
import org.simantics.sysdyn.representation.utils.IndexUtils;
import org.simantics.sysdyn.representation.utils.UnitUtils;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/DelayExpression")
public class DelayExpression
extends Expression {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/DelayExpression/initialValue")
    private String initialValue;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/DelayExpression/delayTime")
    private String delayTime;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/DelayExpression/order")
    private Integer order;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/DelayExpression/expression")
    private String equation;

    @Override
    public String getDeclarationAddition() {
        int[] dimensions = null;
        if (this.getArrayRange() == null) {
            dimensions = this.getParent().getDimensionArray();
        }
        return "\t" + ModelicaWriter.getDelayName(this.order, dimensions) + " " + this.instance() + ";\n";
    }

    @Override
    public String getEquation() {
        StringBuilder sb = new StringBuilder();
        String equation = FormatUtils.replaceWhitespace(this.equation);
        equation = FormatUtils.formatExpressionForModelica(this.parent, equation);
        String delayTime = FormatUtils.replaceWhitespace(this.delayTime);
        delayTime = FormatUtils.formatExpressionForModelica(this.parent, delayTime);
        String initialValue = FormatUtils.replaceWhitespace(this.initialValue);
        initialValue = FormatUtils.formatExpressionForModelica(this.parent, initialValue);
        sb.append("\t" + this.instance() + "." + ModelicaWriter.getDelayValve(0) + " = " + equation + ";\n");
        sb.append("\t" + this.instance() + ".delayTime = " + delayTime + ";\n");
        sb.append("\t" + this.instance() + ".initialValue = ");
        if (initialValue != null && !initialValue.isEmpty()) {
            sb.append(initialValue);
        } else {
            sb.append(this.instance() + "." + ModelicaWriter.getDelayValve(0));
        }
        sb.append(";\n");
        String range = IndexUtils.rangeToIndexes(this.parent, this.getArrayRange());
        sb.append("\t" + this.parent.getModelicaName() + (range.equals("[:]") ? "" : range) + " = " + this.instance() + "." + ModelicaWriter.getDelayValve(this.order) + ";\n");
        return sb.toString();
    }

    @Override
    public String getExpression() {
        return "This + is + not + a + parameter + at + any + time";
    }

    @Override
    public String getModelicaExpression() {
        return this.getExpression();
    }

    @Override
    public String validateUnits(ReadGraph graph, SysdynModel model) {
        if (this.parent.getUnit() == null) {
            return "Unit not defined for " + this.parent.getName();
        }
        String result = UnitUtils.matchUnits(graph, model, this.parent.getParentConfiguration(), this.parent.getUnit(), this.equation);
        if (result == null) {
            result = UnitUtils.matchUnits(graph, model, this.parent.getParentConfiguration(), this.parent.getUnit(), this.initialValue);
        }
        if (result == null) {
            result = UnitUtils.matchUnits(graph, model, this.parent.getParentConfiguration(), UnitUtils.getTimeUnit(graph, model), this.delayTime);
        }
        return result;
    }

    public int getOrder() {
        return this.order;
    }

    private String instance() {
        String identifier = this.getArrayRange() != null && !this.getArrayRange().isEmpty() ? IndexUtils.rangeToIndexes(this.parent, this.getArrayRange()).replaceAll("[\\[\\]{},]", "_") : "_";
        return this.parent.getModelicaName() + identifier + "instance";
    }
}

