/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElement;
import org.simantics.objmap.annotations.UpdateMethod;
import org.simantics.spreadsheet.CellParseException;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.sysdyn.representation.Book;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.visitors.IElementVisitorVoid;

@GraphType(value="http://www.simantics.org/Spreadsheet-1.2/Spreadsheet")
public class Sheet
extends Variable {
    @RelatedElement(value="http://www.simantics.org/Layer0-1.1/PartOf")
    protected Book book;
    THashMap<String, Object> cells = new THashMap();
    THashSet<String> usedRanges = new THashSet();
    Resource resource;

    public String getSheet() {
        return "Sheet";
    }

    @UpdateMethod
    public boolean updateCells(ReadGraph g, Resource r) throws DatabaseException {
        if (g.hasStatement(r)) {
            this.resource = r;
            THashMap newCells = new THashMap();
            g.getObjects(r, Layer0.getInstance((ReadGraph)g).ConsistsOf);
            org.simantics.db.layer0.variable.Variable v = (org.simantics.db.layer0.variable.Variable)g.adapt(r, org.simantics.db.layer0.variable.Variable.class);
            for (org.simantics.db.layer0.variable.Variable child : v.getChildren(g)) {
                String name = child.getName(g);
                try {
                    SpreadsheetUtils.decodeCellAbsolute((String)name);
                    Object value = child.getPropertyValue(g, "content");
                    if (!(value instanceof Variant)) continue;
                    newCells.put((Object)name, ((Variant)value).getValue());
                }
                catch (CellParseException value) {
                }
                catch (MissingVariableException e) {
                    System.out.println("missing content for: " + name);
                }
            }
            boolean update = false;
            if (newCells.size() == this.cells.size()) {
                for (String key : this.cells.keySet()) {
                    if (this.cells.get((Object)key).equals(newCells.get((Object)key))) continue;
                    update = true;
                    break;
                }
            } else {
                update = true;
            }
            if (update) {
                this.cells = newCells;
                this.usedRanges.clear();
                return true;
            }
        }
        return false;
    }

    public String getStringRepresentation() {
        final StringBuilder clazz = new StringBuilder();
        clazz.append("class " + this.getModelicaName() + "_class\n");
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    HashSet<String> possibleRanges = new HashSet<String>();
                    HashSet<String> usedCells = new HashSet<String>();
                    for (String key : Sheet.this.usedRanges) {
                        if (Sheet.this.cells.containsKey((Object)key)) {
                            Sheet.this.addRange(key, usedCells, clazz);
                            continue;
                        }
                        for (String range : Sheet.this.getChildRanges(graph, key)) {
                            if (!Sheet.this.cells.containsKey((Object)range)) continue;
                            Sheet.this.addRange(range, usedCells, clazz);
                        }
                        possibleRanges.add(key);
                    }
                    org.simantics.db.layer0.variable.Variable v = (org.simantics.db.layer0.variable.Variable)graph.adapt(Sheet.this.resource, org.simantics.db.layer0.variable.Variable.class);
                    for (String possibleRange : possibleRanges) {
                        int i;
                        String[][] rangeCells;
                        org.simantics.db.layer0.variable.Variable range;
                        String[] parts = possibleRange.split(":");
                        if (parts.length != 2 || !Sheet.this.cells.containsKey((Object)parts[0]) || !Sheet.this.cells.containsKey((Object)parts[1]) || (range = v.getChild(graph, possibleRange)) == null || (rangeCells = (String[][])range.getPropertyValue(graph, "rangeCellNames")) == null) continue;
                        if (rangeCells[0].length > 1) {
                            clazz.append("    parameter Real[" + rangeCells.length + ", " + rangeCells[0].length + "] ");
                            clazz.append(possibleRange.replace(":", "_") + " = {");
                            i = 0;
                            while (i < rangeCells.length) {
                                clazz.append("{");
                                int j = 0;
                                while (j < rangeCells[i].length) {
                                    clazz.append(rangeCells[i][j]);
                                    usedCells.add(rangeCells[i][j]);
                                    if (j < rangeCells[i].length - 1) {
                                        clazz.append(", ");
                                    }
                                    ++j;
                                }
                                clazz.append("}");
                                if (i < rangeCells.length - 1) {
                                    clazz.append(", ");
                                }
                                ++i;
                            }
                            clazz.append("};\n");
                            continue;
                        }
                        clazz.append("    parameter Real[" + rangeCells.length + "] ");
                        clazz.append(possibleRange.replace(":", "_") + " = {");
                        i = 0;
                        while (i < rangeCells.length) {
                            clazz.append(rangeCells[i][0]);
                            usedCells.add(rangeCells[i][0]);
                            if (i < rangeCells.length - 1) {
                                clazz.append(", ");
                            }
                            ++i;
                        }
                        clazz.append("};\n");
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        clazz.append("end " + this.getModelicaName() + "_class;\n");
        return clazz.toString();
    }

    private void addRange(String key, HashSet<String> usedCells, StringBuilder clazz) {
        if (usedCells.add(key)) {
            Double d2;
            Object value = this.cells.get((Object)key);
            if (value instanceof String || value instanceof MutableString) {
                try {
                    d2 = Double.parseDouble(value.toString());
                    value = d2;
                }
                catch (NumberFormatException d2) {
                    // empty catch block
                }
            }
            if (value instanceof Double) {
                d2 = (Double)value;
                clazz.append("    parameter Real " + key + " = " + String.valueOf(d2) + " /* Actual value read from init file */;\n");
            }
        }
    }

    private ArrayList<String> getChildRanges(ReadGraph graph, String range) throws DatabaseException {
        ArrayList<String> ranges = new ArrayList<String>();
        if (range.contains(":")) {
            org.simantics.db.layer0.variable.Variable v = (org.simantics.db.layer0.variable.Variable)graph.adapt(this.resource, org.simantics.db.layer0.variable.Variable.class);
            String[] parts = range.split(":");
            if (parts.length != 2 || !this.cells.containsKey((Object)parts[0]) || !this.cells.containsKey((Object)parts[1])) {
                return ranges;
            }
            org.simantics.db.layer0.variable.Variable rangeVariable = v.getChild(graph, range);
            if (rangeVariable == null) {
                return ranges;
            }
            String[][] rangeCells = (String[][])rangeVariable.getPropertyValue(graph, "rangeCellNames");
            if (rangeCells == null) {
                return ranges;
            }
            int i = 0;
            while (i < rangeCells.length) {
                int j = 0;
                while (j < rangeCells[i].length) {
                    ranges.add(rangeCells[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        return ranges;
    }

    public THashMap<String, Object> getCells() {
        return this.cells;
    }

    @Override
    public void accept(IElementVisitorVoid v) {
    }

    public void use(String usedRange) {
        this.usedRanges.add((Object)usedRange);
    }

    @Override
    public String getDocumentationDefinition(ReadGraph graph) throws DatabaseException {
        org.simantics.db.layer0.variable.Variable v = Variables.getVariable((ReadGraph)graph, (Resource)this.resource);
        Collection children = v.getChildren(graph);
        HashMap<org.simantics.db.layer0.variable.Variable, Range> map = new HashMap<org.simantics.db.layer0.variable.Variable, Range>();
        int minColumn = -1;
        int maxColumn = -1;
        int minRow = -1;
        int maxRow = -1;
        for (org.simantics.db.layer0.variable.Variable child : children) {
            String value;
            Variant valueVariant;
            Object valueObject;
            Range range = SpreadsheetUtils.decodePossibleCellAbsolute((String)child.getName(graph));
            if (range == null || !((valueObject = (valueVariant = (Variant)child.getPropertyValue(graph, "content", (Binding)Bindings.VARIANT)).getValue()) instanceof String) || (value = (String)valueObject).isEmpty()) continue;
            map.put(child, range);
            if (minColumn < 0 || range.startColumn < minColumn) {
                minColumn = range.startColumn;
            }
            if (range.startColumn > maxColumn) {
                maxColumn = range.startColumn;
            }
            if (minRow < 0 || range.startRow < minRow) {
                minRow = range.startRow;
            }
            if (range.startRow <= maxRow) continue;
            maxRow = range.startRow;
        }
        int nColumns = maxColumn - minColumn + 1;
        int nRows = maxRow - minRow + 1;
        String[][] table = new String[nRows][nColumns];
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nColumns) {
                table[i][j] = "";
                ++j;
            }
            ++i;
        }
        for (org.simantics.db.layer0.variable.Variable cell : map.keySet()) {
            Range range = (Range)map.get(cell);
            Variant valueVariant = (Variant)cell.getPropertyValue(graph, "content", (Binding)Bindings.VARIANT);
            Object valueObject = valueVariant.getValue();
            table[range.startRow - minRow][range.startColumn - minColumn] = valueObject.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append("<table style='border-collapse:collapse;'>");
        int i2 = -1;
        while (i2 < nRows) {
            result.append("<tr>");
            int j = -1;
            while (j < nColumns) {
                result.append("<td style='border: 1px solid black;'>");
                if (i2 == -1 || j == -1) {
                    result.insert(result.length() - 2, "background-color:#D3D3D3; text-align:center;");
                }
                if (i2 != -1 || j != -1) {
                    if (i2 == -1) {
                        result.append(SpreadsheetUtils.columnName((int)(j + minColumn)));
                    } else if (j == -1) {
                        result.append(i2 + minRow + 1);
                    } else {
                        result.append(table[i2][j]);
                    }
                }
                result.append("</td>");
                ++j;
            }
            result.append("</tr>");
            ++i2;
        }
        result.append("</table>");
        return result.toString();
    }

    public Resource getResource() {
        return this.resource;
    }
}

