/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.objmap.annotations.UpdateMethod;
import org.simantics.sysdyn.SysdynResource;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/SysdynModelicaFunction")
public class Function {
    @RelatedValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    private String name;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModelicaFunction/modelicaFunctionCode")
    private String code;
    private boolean hasTimeReference = false;

    public String getCode() {
        return "function " + this.name + "\n" + this.code + "end " + this.name + ";\n";
    }

    public String getName() {
        return this.name;
    }

    @UpdateMethod
    public boolean update(ReadGraph g, Resource r) throws DatabaseException {
        String[] elements;
        this.hasTimeReference = false;
        String code = (String)g.getPossibleRelatedValue(r, SysdynResource.getInstance((ReadGraph)g).SysdynModelicaFunction_modelicaFunctionCode);
        if (code == null) {
            return true;
        }
        String[] stringArray = elements = code.split("[\\+\\-\\*\\/\\(\\)\\[\\]\\{\\}=;\\s]");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if ("time".equals(element)) {
                this.hasTimeReference = true;
                break;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasTimeReference() {
        return this.hasTimeReference;
    }
}

