/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.mdl.Lookup;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;

public class MdlUtil {
    private static final double SCALE_MULTIPLIER = 0.45;
    public static final String DBL = "[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)";
    public static final String DBL_G = "([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))";
    public static final String INT = "[+-]?\\d+";
    public static final String INT_G = "([+-]?\\d+)";
    public static final String FORBIDDEN_VARIABLE_CHAR = "\\W";
    public static final String BASIC_NAME = "[A-Za-z]\\w*(?:\\s+\\w+)*";
    public static final String SPECIAL_NAME = "\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"";
    public static final String VARIABLE = "([A-Za-z]\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")";
    public static final String VARIABLE_EXPRESSION = "([A-Za-z](?![\\s\\w]*\\()\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")";
    public static final String SUBSCRIPT = "([A-Za-z]\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")\\[([A-Za-z]\\w*(?:\\s+\\w+)*\\!?(?:,[A-Za-z]\\w*(?:\\s+\\w+)*\\!?)*)\\]";
    public static final String FUNCTION = "([A-Za-z]\\w*(?:\\s+\\w+)*)\\s*\\(";

    public static String normalize(String str) {
        str = str.replaceAll("\t", "");
        str = MdlUtil.normalizeFunctions(str);
        str = MdlUtil.normalizeVariables(str);
        str = str.replaceAll(":AND:", " and ");
        str = str.replaceAll(":OR:", " or ");
        str = MdlUtil.addParenthesesToExponents(str);
        str = str.replaceAll("=", "==");
        str = str.replaceAll(">==", ">=");
        str = str.replaceAll("<==", "<=");
        return str;
    }

    private static String normalizeVariables(String expression) {
        StringBuilder result = new StringBuilder();
        int offset = 0;
        Matcher matcher = Pattern.compile(VARIABLE_EXPRESSION).matcher(expression);
        while (matcher.find()) {
            result.append(expression.substring(offset, matcher.start()));
            String variable = matcher.group(1);
            if (variable.equalsIgnoreCase("time")) {
                result.append("time");
            } else if (variable.startsWith("\"") && variable.endsWith("\"")) {
                variable = variable.replaceAll(FORBIDDEN_VARIABLE_CHAR, "_");
                result.append(variable);
            } else {
                variable = variable.replaceAll(FORBIDDEN_VARIABLE_CHAR, "_");
                String[] parts = variable.split("\\s+");
                int i = 0;
                while (i < parts.length) {
                    if (i > 0 && !Character.isDigit(parts[i].charAt(0))) {
                        result.append(' ');
                    }
                    result.append(parts[i].substring(0, 1).toUpperCase() + parts[i].substring(1));
                    ++i;
                }
            }
            offset = matcher.end();
        }
        if (offset < expression.length()) {
            result.append(expression.substring(offset));
        }
        return result.toString();
    }

    private static String normalizeFunctions(String expression) {
        StringBuilder result = new StringBuilder();
        int offset = 0;
        Matcher matcher = Pattern.compile(FUNCTION).matcher(expression);
        while (matcher.find()) {
            result.append(expression.substring(offset, matcher.start()));
            String function = matcher.group(1);
            if (function.equalsIgnoreCase("sum")) {
                result.append("sum(");
                int closing = expression.indexOf(41, matcher.end());
                String parameters = expression.substring(matcher.end(), closing);
                parameters = parameters.replaceAll("\\*", ".*");
                parameters = parameters.replaceAll("/", "./");
                parameters = parameters.replaceAll("\\+", ".+");
                parameters = parameters.replaceAll("-", ".-");
                result.append(parameters);
                offset = closing;
                continue;
            }
            if (function.equalsIgnoreCase("if then else")) {
                result.append("IFTHENELSE(");
                offset = matcher.end();
                continue;
            }
            result.append(function.toUpperCase() + "(");
            offset = matcher.end();
        }
        if (offset < expression.length()) {
            result.append(expression.substring(offset));
        }
        return result.toString();
    }

    private static String addParenthesesToExponents(String expression) {
        if (!expression.contains("^")) {
            return expression;
        }
        StringBuilder result = new StringBuilder();
        int offset = 0;
        Matcher matcher = Pattern.compile("\\^\\s*-\\s*([A-Za-z](?![\\s\\w]*\\()\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")").matcher(expression);
        while (matcher.find()) {
            result.append(expression.substring(offset, matcher.start()));
            result.append("^(-").append(matcher.group(1)).append(")");
            offset = matcher.end();
        }
        if (offset < expression.length()) {
            result.append(expression.substring(offset));
        }
        return result.toString();
    }

    public static String finalize(String expression, MdlModel mdl) {
        expression = MdlUtil.expandIterations(expression, mdl);
        expression = MdlUtil.renameLookups(expression, mdl);
        return expression;
    }

    private static String expandIterations(String expression, MdlModel mdl) {
        StringBuilder result = new StringBuilder();
        int offset = 0;
        Matcher matcher = Pattern.compile(SUBSCRIPT).matcher(expression);
        while (matcher.find()) {
            result.append(expression.substring(offset, matcher.start()));
            String name = matcher.group(1);
            String[] indices = matcher.group(2).split(",");
            result.append(name);
            result.append('[');
            int i = 0;
            while (i < indices.length) {
                if (i > 0) {
                    result.append(',');
                }
                if (indices[i].endsWith("!")) {
                    String subscript = indices[i].substring(0, indices[i].length() - 1);
                    List<String> values = mdl.getSubscript(subscript).getValues();
                    result.append('{');
                    int j = 0;
                    while (j < values.size()) {
                        if (j > 0) {
                            result.append(',');
                        }
                        result.append(values.get(j));
                        ++j;
                    }
                    result.append('}');
                } else {
                    result.append(indices[i]);
                }
                ++i;
            }
            result.append(']');
            offset = matcher.end();
        }
        if (offset < expression.length()) {
            result.append(expression.substring(offset));
        }
        return result.toString();
    }

    private static String renameLookups(String expression, MdlModel mdl) {
        StringBuilder result = new StringBuilder();
        int offset = 0;
        Matcher matcher = Pattern.compile(FUNCTION).matcher(expression);
        while (matcher.find()) {
            result.append(expression.substring(offset, matcher.start()));
            String name = matcher.group(1);
            Lookup potential = mdl.getLookup(name);
            if (potential != null) {
                name = name.replaceAll("\\s+", "");
            }
            result.append(name + "(");
            offset = matcher.end();
        }
        if (offset < expression.length()) {
            result.append(expression.substring(offset));
        }
        return result.toString();
    }

    public static String replaceSubscripts(String expression, String subscript, String replacement) {
        StringBuilder result = new StringBuilder();
        int offset = 0;
        Matcher matcher = Pattern.compile(SUBSCRIPT).matcher(expression);
        while (matcher.find()) {
            result.append(expression.substring(offset, matcher.start()));
            String name = matcher.group(1);
            String[] indices = matcher.group(2).split(",");
            result.append(name);
            result.append('[');
            int i = 0;
            while (i < indices.length) {
                if (i > 0) {
                    result.append(',');
                }
                if (indices[i].equals(subscript)) {
                    result.append(replacement);
                } else {
                    result.append(indices[i]);
                }
                ++i;
            }
            result.append(']');
            offset = matcher.end();
        }
        if (offset < expression.length()) {
            result.append(expression.substring(offset));
        }
        return result.toString();
    }

    public static double[] getSysdynDimensions(int x, int y, int width, int height) {
        return new double[]{(double)x * 0.45, (double)y * 0.45, (double)width * 0.45, (double)height * 0.45};
    }
}

