/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.IndexVariable;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.solver.ISolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValueIndexVariableBase<T>
extends IndexVariable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueIndexVariableBase.class);
    public static double[] UNRESOLVED = new double[0];

    public ValueIndexVariableBase(String indexes) throws DatabaseException {
        super(null, indexes);
    }

    @Override
    public void setIndexedValue(WriteGraph graph, Object value) throws DatabaseException {
        Variable var = this.parent.getParent((ReadGraph)graph);
        Resource resource = var.getRepresents((ReadGraph)graph);
        if (!(value instanceof Double) && !(value instanceof double[]) || resource == null) {
            return;
        }
        double[] values = null;
        if (value instanceof Double) {
            values = new double[]{(Double)value};
        } else if (value instanceof double[]) {
            values = (double[])value;
        }
        if (this.data.experiment instanceof SysdynGameExperimentBase) {
            SysdynGameExperimentBase exp = (SysdynGameExperimentBase)this.data.experiment;
            ExperimentState state = exp.getSysdynExperimentState();
            if (!ExperimentState.RUNNING.equals((Object)state) && !ExperimentState.STOPPED.equals((Object)state)) {
                return;
            }
            ISolver solver = exp.getSolver();
            try {
                List<String> variableNames = this.getVariableNamesWithIndexNumbers();
                int i = 0;
                while (i < variableNames.size() && i < values.length) {
                    if (values[i] != Double.NaN) {
                        String name = variableNames.get(i);
                        solver.setRealValue(name, values[i]);
                        SysdynGameExperimentBase.Subscription s = ((SysdynGameExperimentBase)this.data.experiment).subscribe(this.getVariableNamesWithIndexNumbers());
                        if (s != null) {
                            s.setValue(i, values[i]);
                        }
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        for (Resource dependency : graph.getObjects(resource, sr.Variable_isTailOf)) {
                            Resource head = graph.getPossibleObject(dependency, sr.Variable_HasHead);
                            Resource ref = graph.getPossibleObject(dependency, sr.Dependency_refersTo);
                            if (ref == null || head == null) continue;
                            String module = "";
                            if (name.indexOf(".") > 0) {
                                module = name.substring(0, name.lastIndexOf(".") + 1);
                            }
                            String refName = module + NameUtils.getSafeName((ReadGraph)graph, (Resource)head) + "." + NameUtils.getSafeName((ReadGraph)graph, (Resource)ref);
                            solver.setRealValue(refName, values[i]);
                        }
                    }
                    ++i;
                }
                exp.refresh();
                exp.updateSubscriptions();
            }
            catch (Exception e) {
                LOGGER.error("Error while setting experiment value", (Throwable)e);
            }
        }
    }
}

