/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.sysdyn.nodemanager.SysdynValueData;
import org.simantics.utils.datastructures.Triple;

public abstract class IndexVariable<T>
extends AbstractPropertyVariable {
    protected Variable parent;
    protected String indexes;
    protected SysdynValueData data;
    private Triple<List<String>, List<String>, List<Integer>> variableNameArrays;

    public IndexVariable(Variable parent, String indexes) throws DatabaseException {
        this.parent = parent;
        this.indexes = indexes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IndexVariable other = (IndexVariable)((Object)obj);
        if (this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String getIndexes() {
        return this.indexes;
    }

    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public <U> U getValue(ReadGraph graph) throws DatabaseException {
        return this.getValue(graph, (Binding)Bindings.DOUBLE);
    }

    public <U> U getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        return (U)this.getValue();
    }

    protected void beforeRequest(ReadGraph graph) throws DatabaseException {
    }

    private Triple<List<String>, List<String>, List<Integer>> getVariableNameArrays() {
        if (this.variableNameArrays == null && this.data.rvi != null && this.data.rvis != null) {
            if (this.data.rvi.indexOf(35) > 0) {
                this.data.rvi = this.data.rvi.substring(0, this.data.rvi.indexOf(35));
            }
            boolean regexp = false;
            Object test = this.data.rvi;
            if (this.indexes != null && !this.indexes.isEmpty()) {
                regexp = this.indexes.contains(":");
                if (regexp) {
                    String regexIndexes = this.indexes.trim().replaceAll(":", "[a-zA-Z0-9_]*");
                    test = this.data.rvi + "\\[" + regexIndexes + "\\]";
                } else {
                    test = this.data.rvi + "[" + this.indexes + "]";
                }
            } else {
                test = this.data.rvi + "(\\[.*\\])?";
                regexp = true;
            }
            Triple result = null;
            if (regexp) {
                Pattern p = Pattern.compile((String)test);
                result = new Triple(new ArrayList(), new ArrayList(), new ArrayList());
                for (String k : this.data.rvis.keySet()) {
                    Tuple2 value = this.data.rvis.get(k);
                    if (!p.matcher(k).matches() && !p.matcher((String)value.c1).matches()) continue;
                    ((List)result.first).add(this.transform(k));
                    ((List)result.second).add(this.transform((String)value.c1));
                    ((List)result.third).add((Integer)value.c0);
                }
            } else {
                Tuple2 value = this.data.rvis.get(test);
                if (value != null) {
                    result = new Triple(Collections.singletonList(this.transform((String)test)), Collections.singletonList(this.transform((String)value.c1)), Collections.singletonList((Integer)value.c0));
                } else {
                    for (String k : this.data.rvis.keySet()) {
                        value = this.data.rvis.get(k);
                        if (!value.c1.equals(test)) continue;
                        result = new Triple(Collections.singletonList(this.transform(k)), Collections.singletonList(this.transform((String)value.c1)), Collections.singletonList((Integer)value.c0));
                        break;
                    }
                }
            }
            this.variableNameArrays = result;
        }
        if (this.variableNameArrays == null) {
            return new Triple(new ArrayList(), new ArrayList(), new ArrayList());
        }
        return this.variableNameArrays;
    }

    private String transform(String s) {
        return s.substring(1).replace("/", ".").replace("%20", "_");
    }

    protected List<String> getVariableNames() {
        return (List)this.getVariableNameArrays().second;
    }

    protected List<String> getVariableNamesWithIndexNumbers() {
        return (List)this.getVariableNameArrays().first;
    }

    protected List<Integer> getVariableArrayIndices() {
        return (List)this.getVariableNameArrays().third;
    }

    public abstract T getValue();

    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.setValue(graph, value);
    }

    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.setIndexedValue(graph, value);
    }

    protected abstract void setIndexedValue(WriteGraph var1, Object var2) throws DatabaseException;

    public String getName(ReadGraph graph) throws DatabaseException {
        return this.indexes;
    }

    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }
}

