/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.rules.domain;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.domain.IDomainAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedObjectAccessor
implements IDomainAccessor<Resource> {
    static Logger LOGGER = LoggerFactory.getLogger((String)"org.simantics.objmap");
    Resource relation;

    public RelatedObjectAccessor(Resource relation) {
        this.relation = relation;
    }

    @Override
    public Resource get(ReadGraph g, Resource element) throws MappingException {
        try {
            LOGGER.trace("        RelatedObjectAccessor.get");
            return g.getPossibleObject(element, this.relation);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Resource value) throws MappingException {
        block8: {
            Resource resource;
            block6: {
                block7: {
                    try {
                        LOGGER.trace("        RelatedObjectAccessor.set");
                        resource = g.getPossibleObject(element, this.relation);
                        if (resource != null) break block6;
                        if (value != null) break block7;
                        return false;
                    }
                    catch (DatabaseException e) {
                        throw new MappingException(e);
                    }
                }
                g.claim(element, this.relation, value);
                return true;
            }
            if (!resource.equals(value)) break block8;
            return false;
        }
        g.deny(element, this.relation);
        if (value != null) {
            g.claim(element, this.relation, value);
        }
        return true;
    }
}

