/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.common.modifiers.EnumerationValue;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.GetEnumerationValue;
import org.simantics.browsing.ui.graph.impl.GraphEnumerationModifier;
import org.simantics.browsing.ui.graph.impl.GraphFactoryStringModifier;
import org.simantics.browsing.ui.graph.impl.GraphPropertyUtil;
import org.simantics.browsing.ui.graph.impl.GraphStringIndexModifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringIndexModifier;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.TObjectIntPair;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.datastructures.slice.ValueRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayPropertyLabelerFactory
implements LabelerFactory {
    public Labeler create(PrimitiveQueryUpdater manager, NodeContext context, BuiltinKeys.LabelerKey key) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o instanceof IArrayProperty) {
            return new ArrayPropertyLabeler(manager, context, key);
        }
        if (o instanceof IProperty) {
            return new PropertyLabeler(manager, context, key);
        }
        return null;
    }

    static class ArrayPropertyLabeler
    extends LazyGraphLabeler {
        NodeContext context;

        public ArrayPropertyLabeler(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.LabelerKey key) {
            super(updater, context, key);
            this.context = context;
        }

        @Override
        public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
            IArrayProperty prop = (IArrayProperty)this.context.getConstant(BuiltinKeys.INPUT);
            ValueRange range = prop.getRange();
            Resource[] r = (Resource[])prop.adapt(Resource[].class);
            if (r == null) {
                return new ArrayMap((Object[])ColumnKeys.KEYS_PROPERTY_VALUE, (Object[])new String[]{prop.toString(), "N/A"});
            }
            String property = "";
            String value = "";
            if (!prop.isSlice()) {
                String valueType;
                property = LabelerUtil.safeStringRepresentation(graph, r[1]);
                value = valueType = GraphPropertyUtil.tryGetValueTypeString(graph, r[2], range.size());
            } else if (range.isSingle()) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                property = range.toString();
                value = LabelerUtil.safeStringRepresentation(graph, r[2], range.start());
                Datatype dt = (Datatype)graph.getPossibleRelatedValue(r[2], L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                if (dt != null && dt instanceof RecordType) {
                    RecordType rt = (RecordType)dt;
                    if (range.start() < rt.getComponentCount()) {
                        Component comp = rt.getComponent(range.start());
                        property = comp.name;
                    }
                }
            } else {
                property = range.toString();
            }
            return new ArrayMap((Object[])ColumnKeys.KEYS_PROPERTY_VALUE, (Object[])new String[]{property, value});
        }

        public Labeler.Modifier getModifier(GraphExplorer.ModificationContext modificationContext, String key) {
            ISessionContext session = Simantics.getSessionContext();
            if (session == null) {
                return null;
            }
            final IArrayProperty prop = (IArrayProperty)this.context.getConstant(BuiltinKeys.INPUT);
            if (!prop.getRange().isSingle()) {
                return null;
            }
            final Resource[] data = (Resource[])prop.getData(Resource[].class);
            if (data == null) {
                return null;
            }
            if (data.length != 3) {
                return null;
            }
            if ("Value".equals(key)) {
                block8: {
                    try {
                        Layer0 L0 = Layer0.getInstance((RequestProcessor)session.getSession());
                        Boolean readOnly = (Boolean)session.getSession().syncRequest((Read)new PossibleRelatedValue2(data[1], L0.readOnly, (Binding)Bindings.BOOLEAN));
                        if (!Boolean.TRUE.equals(readOnly)) break block8;
                        return null;
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return new GraphStringIndexModifier(this.context, session.getSession(), prop.getRange().start()){

                    @Override
                    protected void initializeGraphModifier(ReadGraph g) {
                    }

                    @Override
                    public TObjectIntPair<String> createModifierInput(String fromLabel) {
                        return new TObjectIntPair((Object)fromLabel, prop.getRange().start());
                    }

                    @Override
                    public void doModify(WriteGraph graph, TObjectIntPair<String> label) throws DatabaseException {
                        if (IProperty.ASSERTED.contains(prop.getType())) {
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Resource module = data[0];
                            Resource attribute = data[1];
                            Resource defaultValue = data[2];
                            Resource newValue = graph.newResource();
                            for (Resource type : graph.getObjects(defaultValue, L0.InstanceOf)) {
                                graph.claim(newValue, L0.InstanceOf, null, type);
                            }
                            graph.claim(module, attribute, newValue);
                            Object defaultValueValue = graph.getValue(defaultValue);
                            graph.claimValue(newValue, defaultValueValue);
                            StringIndexModifier sm = (StringIndexModifier)graph.adapt(newValue, StringIndexModifier.class);
                            sm.modify(graph, label);
                        } else {
                            this.getModifier().modify(graph, label);
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public Logger getLogger() {
            return LoggerFactory.getLogger(ArrayPropertyLabeler.class);
        }
    }

    static class PropertyLabeler
    extends LazyGraphLabeler {
        NodeContext context;

        public PropertyLabeler(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.LabelerKey key) {
            super(updater, context, key);
            this.context = context;
        }

        @Override
        public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
            IProperty prop = (IProperty)this.context.getConstant(BuiltinKeys.INPUT);
            Resource[] r = (Resource[])prop.adapt(Resource[].class);
            if (r == null) {
                return new ArrayMap((Object[])ColumnKeys.KEYS_PROPERTY_VALUE, (Object[])new String[]{prop.toString(), "N/A"});
            }
            String property = "";
            String value = "";
            if (r.length == 3) {
                property = LabelerUtil.safeStringRepresentation(graph, r[1]);
                value = (String)graph.getPossibleRelatedAdapter(r[0], r[1], String.class);
                if (value == null) {
                    value = LabelerUtil.safeStringRepresentation(graph, r[2]);
                }
            }
            return new ArrayMap((Object[])ColumnKeys.KEYS_PROPERTY_VALUE, (Object[])new String[]{property, value});
        }

        public Labeler.Modifier getModifier(GraphExplorer.ModificationContext modificationContext, String key) {
            ISessionContext session = Simantics.getSessionContext();
            if (session == null) {
                return null;
            }
            final IProperty prop = (IProperty)this.context.getConstant(BuiltinKeys.INPUT);
            Resource[] data = (Resource[])prop.adapt(Resource[].class);
            if (data == null) {
                return null;
            }
            if (data.length != 3) {
                return null;
            }
            if ("Value".equals(key)) {
                block8: {
                    try {
                        Layer0 L0 = Layer0.getInstance((RequestProcessor)session.getSession());
                        Boolean readOnly = (Boolean)session.getSession().syncRequest((Read)new PossibleRelatedValue2(data[1], L0.readOnly, (Binding)Bindings.BOOLEAN));
                        if (!Boolean.TRUE.equals(readOnly)) break block8;
                        return null;
                    }
                    catch (DatabaseException e) {
                        throw new RuntimeException(e);
                    }
                }
                EnumerationValue enu = (EnumerationValue)session.getSession().syncRequest((Read)new GetEnumerationValue(data[2]));
                if (enu != null) {
                    return new GraphEnumerationModifier(session.getSession(), data[0], data[1], (Enumeration<Resource>)enu.getEnumeration(), (EnumeratedValue<Resource>)enu.getEnumeratedValue());
                }
                Resource subject = data[0];
                Resource predicate = data[1];
                Resource object = data[2];
                return new GraphFactoryStringModifier(subject, predicate, object, (RequestProcessor)session.getSession()){

                    @Override
                    public void doModify(WriteGraph graph, String label) throws DatabaseException {
                        if (IProperty.ASSERTED.contains(prop.getType())) {
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Resource newValue = graph.newResource();
                            for (Resource type : graph.getObjects(this.object, L0.InstanceOf)) {
                                graph.claim(newValue, L0.InstanceOf, null, type);
                            }
                            if (!graph.hasStatement(newValue, L0.HasDataType)) {
                                Binding b = Bindings.getBindingUnchecked(Datatype.class);
                                Datatype dt = (Datatype)graph.getRelatedValue(this.object, L0.HasDataType, b);
                                graph.addLiteral(newValue, L0.HasDataType, L0.HasDataType_Inverse, L0.DataType, (Object)dt, b);
                            }
                            graph.claim(this.subject, this.predicate, newValue);
                            StringModifier sm = (StringModifier)graph.adapt(newValue, StringModifier.class);
                            sm.modify(graph, (Object)label);
                        } else {
                            this.getModifier().modify(graph, (Object)label);
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public Logger getLogger() {
            return LoggerFactory.getLogger(PropertyLabeler.class);
        }
    }
}

