/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.request.Read;

public abstract class AbstractStringModifier
implements Labeler.Modifier {
    protected NodeContext context;
    protected Session session;
    protected String initialValue;
    protected StringModifier modifier;
    protected Throwable modifierFailed;

    public AbstractStringModifier(NodeContext context, RequestProcessor processor) {
        this.context = context;
        this.session = processor.getSession();
        final Resource r = this.getResourceToModify();
        if (r == null) {
            throw new IllegalArgumentException("This modifier does not work for INodeContexts that are not adaptable to a Resource. The context input is: " + String.valueOf(context.getConstant(BuiltinKeys.INPUT)));
        }
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) throws DatabaseException {
                    AbstractStringModifier.this.initialValue = AbstractStringModifier.this.getInitialValue(g);
                    AbstractStringModifier.this.modifier = (StringModifier)g.adapt(r, StringModifier.class);
                    AbstractStringModifier.this.initializeModifier(g);
                }
            });
        }
        catch (DatabaseException e) {
            this.modifierFailed = e;
        }
    }

    protected void initializeModifier(ReadGraph g) {
    }

    protected String getInitialValue(ReadGraph g) throws DatabaseException {
        return (String)g.adapt(this.getResourceToModify(), String.class);
    }

    protected Resource getResourceToModify() {
        return (Resource)this.context.getAdapter(Resource.class);
    }

    protected StringModifier getModifier() {
        return this.modifier;
    }

    public String getValue() {
        return this.initialValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        String t = this.createModifierInput(label);
        return this.modifier.isValid((Object)t);
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            return;
        }
        String t = this.createModifierInput(label);
        if (!this.verifyModification(t)) {
            return;
        }
        this.doModify(t);
    }

    protected boolean verifyModification(String label) {
        return true;
    }

    public abstract void doModify(String var1);

    public String createModifierInput(String label) {
        return label;
    }
}

