/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.simantics.diagram.connection.DegeneratedRoutePoint;
import org.simantics.diagram.connection.Directions;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.RouteTerminalPosition;
import org.simantics.diagram.connection.SimpleConnectionUtility;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;
import org.simantics.diagram.connection.segments.Segment;
import org.simantics.diagram.connection.splitting.SplittedRouteGraph;

public class RouteGraph
implements Serializable {
    private static final long serialVersionUID = 2004022454972623908L;
    public static final boolean RETURN_UNMODIFIABLE_COLLECTIONS = false;
    public static final boolean CHECK_PARAMERS = true;
    protected ArrayList<RouteLine> lines = new ArrayList(4);
    protected ArrayList<RouteTerminal> terminals = new ArrayList(4);
    protected ArrayList<RouteLine> transientLines = new ArrayList(4);
    protected int caseId;
    protected boolean isSimpleConnection;
    protected boolean needsUpdate = false;
    public static final int PICK_INTERIOR_POINTS = 1;
    public static final int PICK_TERMINALS = 2;
    public static final int PICK_POINTS = 3;
    public static final int PICK_PERSISTENT_LINES = 4;
    public static final int PICK_TRANSIENT_LINES = 8;
    public static final int PICK_DIRECT_LINES = 16;
    public static final int PICK_LINES = 28;
    public static final int PICK_ALL = 31;
    private static final Comparator<RoutePoint> RG_COMP = (o1, o2) -> {
        if (o1.getX() < o2.getX()) {
            return -1;
        }
        if (o1.getX() > o2.getX()) {
            return 1;
        }
        if (o1.getY() < o2.getY()) {
            return -1;
        }
        if (o1.getY() > o2.getY()) {
            return 1;
        }
        return 0;
    };

    public void updateTerminals() {
        boolean changed = false;
        for (RouteTerminal terminal : this.terminals) {
            changed |= terminal.updateDynamicPosition();
        }
        if (changed) {
            this.update();
        }
    }

    public RouteLine addLine(boolean isHorizontal, double position) {
        RouteLine line = new RouteLine(isHorizontal, position);
        this.lines.add(line);
        return line;
    }

    public RouteTerminal addTerminal(double x, double y, double minX, double minY, double maxX, double maxY, int allowedDirections, ILineEndStyle style, RouteTerminalPosition position) {
        return this.addTerminal(x, y, minX, minY, maxX, maxY, allowedDirections, style, null, position);
    }

    public RouteTerminal addTerminal(double x, double y, double minX, double minY, double maxX, double maxY, int allowedDirections, ILineEndStyle style) {
        return this.addTerminal(x, y, minX, minY, maxX, maxY, allowedDirections, style, null, null);
    }

    public RouteTerminal addTerminal(double x, double y, double minX, double minY, double maxX, double maxY, int allowedDirections, ILineEndStyle style, ILineEndStyle dynamicStyle, RouteTerminalPosition position) {
        if (allowedDirections > 31) {
            throw new IllegalArgumentException("Illegal allowedDirection flags.");
        }
        if (minX > x || x > maxX || minY > y || y > maxY) {
            throw new IllegalArgumentException("Illegal position attributes for a terminal, (" + x + ", " + y + ") is outside of (" + minX + ", " + minY + ")x(" + maxX + ", " + maxY + ").");
        }
        if (style == null) {
            style = PlainLineEndStyle.INSTANCE;
        }
        RouteTerminal terminal = new RouteTerminal(x, y, minX, minY, maxX, maxY, allowedDirections, false, style, position);
        terminal.setDynamicStyle(dynamicStyle);
        this.terminals.add(terminal);
        return terminal;
    }

    public RouteTerminal addBigTerminal(double minX, double minY, double maxX, double maxY, ILineEndStyle style) {
        return this.addBigTerminal(minX, minY, maxX, maxY, style, null);
    }

    public RouteTerminal addBigTerminal(double minX, double minY, double maxX, double maxY, ILineEndStyle style, ILineEndStyle dynamicStyle) {
        if (style == null) {
            style = PlainLineEndStyle.INSTANCE;
        }
        RouteTerminal terminal = new RouteTerminal(0.5 * (minX + maxX), 0.5 * (minY + maxY), minX, minY, maxX, maxY, 15, true, style, null);
        terminal.setDynamicStyle(dynamicStyle);
        this.terminals.add(terminal);
        return terminal;
    }

    public RouteTerminal addTerminal(double x, double y, Rectangle2D bounds, int allowedDirections, ILineEndStyle style) {
        return this.addTerminal(x, y, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), allowedDirections, style, null);
    }

    public RouteTerminal addTerminal(RouteTerminal terminal) {
        RouteTerminal newTerminal = this.addTerminal(terminal.x, terminal.y, terminal.getMinX(), terminal.getMinY(), terminal.getMaxX(), terminal.getMaxY(), terminal.getAllowedDirections(), terminal.getStyle(), terminal.getDynamicStyle(), terminal.getDynamicPosition());
        newTerminal.setData(terminal.getData());
        return terminal;
    }

    public RouteTerminal addTerminal(double x, double y, double minX, double minY, double maxX, double maxY, int allowedDirections) {
        return this.addTerminal(x, y, minX, minY, maxX, maxY, allowedDirections, PlainLineEndStyle.INSTANCE, null);
    }

    public void link(RouteNode node1, RouteNode node2) {
        if (node1 instanceof RouteLine) {
            if (node2 instanceof RouteLine) {
                this.link((RouteLine)node1, (RouteLine)node2);
            } else {
                this.link((RouteLine)node1, (RouteTerminal)node2);
            }
        } else if (node2 instanceof RouteLine) {
            this.link((RouteTerminal)node1, (RouteLine)node2);
        } else {
            this.link((RouteTerminal)node1, (RouteTerminal)node2);
        }
    }

    public void link(RouteNode ... nodes) {
        int i = 1;
        while (i < nodes.length) {
            this.link(nodes[i - 1], nodes[i]);
            ++i;
        }
    }

    public void link(RouteLine node1, RouteLine node2) {
        new RouteLink(node1, node2);
        this.needsUpdate = true;
    }

    public void link(RouteTerminal node1, RouteLine node2) {
        if (node2 == null) {
            throw new NullPointerException();
        }
        if (node1.line != null) {
            throw new IllegalStateException("Terminal is already connected.");
        }
        node1.line = node2;
        this.needsUpdate = true;
    }

    public void link(RouteLine node1, RouteTerminal node2) {
        if (node1 == null) {
            throw new NullPointerException();
        }
        if (node2.line != null) {
            throw new IllegalStateException("Terminal is already connected.");
        }
        node2.line = node1;
        this.needsUpdate = true;
    }

    public void link(RouteTerminal node1, RouteTerminal node2) {
        if (node1 == null) {
            throw new NullPointerException();
        }
        if (node2 == null) {
            throw new NullPointerException();
        }
        this.isSimpleConnection = true;
        this.needsUpdate = true;
    }

    protected void removeTransientRouteLines() {
        for (RouteLine line : this.transientLines) {
            line.remove();
        }
        this.transientLines.clear();
    }

    protected void removeRouteTerminalsFromRouteLines() {
        for (RouteLine line : this.lines) {
            line.removeRouteTerminals();
        }
    }

    public void rotate(RouteTerminal terminal, int amount) {
        terminal.rotate(amount);
        this.needsUpdate = true;
    }

    public void setLocation(RouteLine line, double x, double y) {
        this.makePersistent(line);
        line.setLocation(x, y);
        this.needsUpdate = true;
    }

    public void setLocation(RouteTerminal terminal, double x, double y) {
        terminal.setLocation(x, y);
        this.needsUpdate = true;
    }

    private boolean isDirectDirectConnection() {
        return !this.isSimpleConnection && this.terminals.size() == 2 && this.terminals.get(0).hasDirectConnection() && this.terminals.get(1).hasDirectConnection() && this.lines.size() <= 1;
    }

    public void update() {
        this.needsUpdate = false;
        this.removeTransientRouteLines();
        this.removeRouteTerminalsFromRouteLines();
        for (RouteLine line : this.lines) {
            line.hidden = false;
        }
        for (RouteTerminal terminal : this.terminals) {
            if (!terminal.hasDirectConnection() || terminal.line == null) continue;
            terminal.line.hidden = true;
        }
        if (this.isSimpleConnection) {
            RouteTerminal a = this.terminals.get(0);
            RouteTerminal b = this.terminals.get(1);
            if (a.hasDirectConnection() || b.hasDirectConnection()) {
                return;
            }
            this.caseId = SimpleConnectionUtility.simpleConnectionCase(a, b);
            switch (this.caseId) {
                case 0: 
                case 1: {
                    boolean horiz = this.caseId == 0;
                    RouteLine line = new RouteLine(horiz, horiz ? a.y : a.x);
                    line.addPoint(a);
                    line.addPoint(b);
                    line.terminal = a;
                    this.transientLines.add(line);
                    a.line = line;
                    b.line = line;
                    break;
                }
                case 2: {
                    RouteLine line1 = new RouteLine(true, a.y);
                    RouteLine line2 = new RouteLine(false, b.x);
                    new RouteLink(line1, line2);
                    line1.addPoint(a);
                    line2.addPoint(b);
                    line1.terminal = a;
                    line2.terminal = b;
                    this.transientLines.add(line1);
                    this.transientLines.add(line2);
                    a.line = line1;
                    b.line = line2;
                    break;
                }
                case 3: {
                    RouteLine line1 = new RouteLine(false, a.x);
                    RouteLine line2 = new RouteLine(true, b.y);
                    new RouteLink(line1, line2);
                    line1.addPoint(a);
                    line2.addPoint(b);
                    line1.terminal = a;
                    line2.terminal = b;
                    this.transientLines.add(line1);
                    this.transientLines.add(line2);
                    a.line = line1;
                    b.line = line2;
                    break;
                }
                case 4: 
                case 5: {
                    RouteLine line;
                    this.terminals.get((int)0).line = line = SimpleConnectionUtility.findRouteLine(this.terminals.get(0), this.terminals.get(1), this.caseId == 5);
                    this.terminals.get((int)1).line = line;
                    this.transientLines.add(line);
                    this.routeFromTerminals(this.caseId == 5);
                }
            }
        } else {
            if (this.isFullyDirectConnectionCase()) {
                this.routeDirectDirectOneLineCase();
                return;
            }
            this.caseId = 6;
            this.routeFromTerminals(false);
        }
        for (RouteLine line : this.lines) {
            line.setPointPositions();
        }
        for (RouteLine line : this.transientLines) {
            line.setPointPositions();
        }
        for (RouteLine line : this.lines) {
            line.sortPoints();
        }
        for (RouteLine line : this.transientLines) {
            line.sortPoints();
        }
    }

    private boolean isFullyDirectConnectionCase() {
        if (this.lines.size() != 1 && this.terminals.size() > 0) {
            return false;
        }
        for (RouteTerminal t : this.terminals) {
            if (t.hasDirectConnection()) continue;
            return false;
        }
        return true;
    }

    private void routeDirectDirectOneLineCase() {
        RouteLine line = this.lines.get(0);
        double x = 0.0;
        double y = 0.0;
        double scale = 1 / this.terminals.size();
        if (line.isHorizontal) {
            y = line.position;
            for (RouteTerminal t : this.terminals) {
                x += t.x;
            }
            x *= scale;
        } else {
            x = line.position;
            for (RouteTerminal t : this.terminals) {
                y += t.y;
            }
            y *= scale;
        }
        line.addPoint(new DegeneratedRoutePoint(x, y));
    }

    protected void routeFromTerminals(boolean boundingBoxesIntersect) {
        IntervalCache cache = new IntervalCache();
        for (RouteTerminal terminal : this.terminals) {
            if (terminal.line == null || terminal.hasDirectConnection()) continue;
            terminal.route(this.transientLines, cache, boundingBoxesIntersect);
        }
    }

    public boolean intersects(Rectangle2D r, int mask) {
        RouteTerminal terminal;
        if (this.needsUpdate) {
            this.update();
        }
        if ((this.isSimpleConnection && this.transientLines.isEmpty() || this.isDirectDirectConnection()) && this.terminals.size() == 2) {
            if ((mask & 8) == 0) {
                return false;
            }
            RouteTerminal a = this.terminals.get(0);
            RouteTerminal b = this.terminals.get(1);
            if (a.hasDirectConnection() || b.hasDirectConnection()) {
                return r.intersectsLine(a.x, a.y, b.x, b.y);
            }
        }
        if ((mask & 4) != 0) {
            for (RouteLine line : this.lines) {
                if (!line.intersects(r)) continue;
                return true;
            }
        }
        if ((mask & 8) != 0) {
            for (RouteLine line : this.transientLines) {
                if (!line.intersects(r)) continue;
                return true;
            }
        }
        return (mask & 0x10) != 0 && (terminal = this.intersectsDirectLine(r)) != null;
    }

    private RouteTerminal intersectsDirectLine(Rectangle2D r) {
        for (RouteTerminal terminal : this.terminals) {
            if ((terminal.getAllowedDirections() & 0x10) == 0) continue;
            try {
                RouteLine line = terminal.getLine();
                if (line == null) continue;
                RoutePoint b = line.getBegin();
                if (!r.intersects(terminal.x, terminal.y, b.x, b.y)) continue;
                return terminal;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public RouteLine pickLine(double x, double y, double tolerance, int mask) {
        RouteTerminal terminal;
        if (this.needsUpdate) {
            this.update();
        }
        if ((this.isSimpleConnection && this.transientLines.isEmpty() || this.isDirectDirectConnection()) && this.terminals.size() == 2) {
            if ((mask & 8) == 0) {
                return null;
            }
            RouteTerminal a = this.terminals.get(0);
            RouteTerminal b = this.terminals.get(1);
            if (a.hasDirectConnection() || b.hasDirectConnection()) {
                if (Line2D.ptSegDistSq(a.x, a.y, b.x, b.y, x, y) <= tolerance * tolerance) {
                    RouteLine dummy = new RouteLine(false, y);
                    return dummy;
                }
                return null;
            }
        }
        if ((mask & 4) != 0) {
            for (RouteLine line : this.lines) {
                if (!line.isNear(x, y, tolerance)) continue;
                return line;
            }
        }
        if ((mask & 8) != 0) {
            for (RouteLine line : this.transientLines) {
                if (!line.isNear(x, y, tolerance)) continue;
                return line;
            }
        }
        if ((mask & 0x10) != 0 && (terminal = this.pickDirectLine(x, y, tolerance)) != null) {
            return terminal.line;
        }
        return null;
    }

    public RouteLine pickLine(double x, double y, double tolerance) {
        return this.pickLine(x, y, tolerance, 28);
    }

    private RouteTerminal pickDirectLine(double x, double y, double tolerance) {
        double toleranceSq = tolerance * tolerance;
        for (RouteTerminal terminal : this.terminals) {
            if ((terminal.getAllowedDirections() & 0x10) == 0) continue;
            try {
                RouteLine line = terminal.getLine();
                if (line == null) continue;
                RoutePoint b = line.getBegin();
                double distSq = Line2D.ptSegDistSq(terminal.x, terminal.y, b.x, b.y, x, y);
                if (!(distSq <= toleranceSq)) continue;
                return terminal;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public RouteLineHalf pickLineHalf(double x, double y, double tolerance) {
        RouteLine line;
        if (this.isSimpleConnection) {
            return null;
        }
        if (this.needsUpdate) {
            this.update();
        }
        if ((line = this.pickLine(x, y, tolerance)) == null) {
            return null;
        }
        RouteLink link = null;
        RoutePoint begin = line.getBegin();
        RoutePoint end = line.getEnd();
        if (line.isHorizontal) {
            double mx = 0.5 * (begin.getX() + end.getX());
            if (x < mx) {
                if (begin instanceof RouteLink) {
                    link = (RouteLink)begin;
                }
            } else if (end instanceof RouteLink) {
                link = (RouteLink)line.getEnd();
            }
        } else {
            double my = 0.5 * (begin.getY() + end.getY());
            if (y < my) {
                if (begin instanceof RouteLink) {
                    link = (RouteLink)begin;
                }
            } else if (end instanceof RouteLink) {
                link = (RouteLink)end;
            }
        }
        if (link == null) {
            return null;
        }
        if (link.getOther(line).isTransient()) {
            return null;
        }
        return new RouteLineHalf(line, link);
    }

    public Collection<RouteLineHalf> getLineHalves() {
        return this.getLineHalves(new ArrayList<RouteLineHalf>());
    }

    public Collection<RouteLineHalf> getLineHalves(Collection<RouteLineHalf> result) {
        for (RouteLine line : this.getAllLines()) {
            RouteLink link;
            RoutePoint p = line.getBegin();
            if (p instanceof RouteLink && !(link = (RouteLink)p).getOther(line).isTransient()) {
                result.add(new RouteLineHalf(line, link));
            }
            if (!((p = line.getEnd()) instanceof RouteLink) || (link = (RouteLink)p).getOther(line).isTransient()) continue;
            result.add(new RouteLineHalf(line, link));
        }
        return result;
    }

    public RoutePoint pickPoint(double x, double y, double tolerance, int mask) {
        if (this.needsUpdate) {
            this.update();
        }
        if ((mask & 2) != 0) {
            for (RouteTerminal terminal : this.terminals) {
                if (!terminal.isNear(x, y)) continue;
                return terminal;
            }
        }
        if ((mask & 1) != 0) {
            for (RouteLine line : this.lines) {
                for (RoutePoint point : line.points) {
                    if (!point.isNear(x, y, tolerance)) continue;
                    return point;
                }
            }
            for (RouteLine line : this.transientLines) {
                for (RoutePoint point : line.points) {
                    if (!point.isNear(x, y, tolerance)) continue;
                    return point;
                }
            }
        }
        return null;
    }

    public RoutePoint pickPoint(double x, double y, double tolerance) {
        return this.pickPoint(x, y, tolerance, 3);
    }

    public Object pick(double x, double y, double tolerance, int mask) {
        RoutePoint point;
        if ((mask & 3) != 0 && (point = this.pickPoint(x, y, tolerance, mask)) != null) {
            return point;
        }
        if ((mask & 0x1C) != 0) {
            return this.pickLine(x, y, tolerance, mask);
        }
        return null;
    }

    public Object pick(double x, double y, double tolerance) {
        return this.pick(x, y, tolerance, 31);
    }

    public Object pick(double x, double y) {
        return this.pick(x, y, 0.0);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        RouteLink link;
        RoutePoint routePoint;
        if (this.needsUpdate) {
            this.update();
        }
        if (this.isSimpleConnection) {
            out.println("=== SIMPLE CONNECTION ===");
        } else {
            out.println("=== COMPLEX CONNECTION ===");
        }
        for (RouteLine line : this.lines) {
            out.print("perst");
            line.print(out);
            for (RoutePoint pt : line.getPoints()) {
                routePoint = pt;
                if (!(routePoint instanceof RouteLink)) continue;
                RouteLink cfr_ignored_0 = (RouteLink)routePoint;
                RouteLink cfr_ignored_1 = (RouteLink)routePoint;
                out.println("\tlink: " + link.x + "," + link.y);
                out.print("\t\t");
                ((RouteLink)pt).getA().print(out);
                out.print("\t\t");
                ((RouteLink)pt).getB().print(out);
            }
        }
        for (RouteLine line : this.transientLines) {
            out.print("trans");
            line.print(out);
            for (RoutePoint pt : line.getPoints()) {
                routePoint = pt;
                if (!(routePoint instanceof RouteLink)) continue;
                RouteLink cfr_ignored_2 = (RouteLink)routePoint;
                RouteLink cfr_ignored_3 = (RouteLink)routePoint;
                out.println("\tlink: " + link.x + "," + link.y);
                out.print("\t\t");
                ((RouteLink)pt).getA().print(out);
                out.print("\t\t");
                ((RouteLink)pt).getB().print(out);
            }
        }
        for (RouteTerminal terminal : this.terminals) {
            out.print("term");
            terminal.print(out);
        }
    }

    public void makePersistent(RouteLine line) {
        this.prepareForModification();
        if (this.isSimpleConnection || line.isTransient()) {
            if (this.isSimpleConnection) {
                this.isSimpleConnection = false;
                for (RouteTerminal terminal : this.terminals) {
                    terminal.line = line;
                }
                this.transientLines.remove(line);
                this.lines.add(line);
                Iterator<RoutePoint> it = line.points.iterator();
                while (it.hasNext()) {
                    RoutePoint point = it.next();
                    if (!(point instanceof RouteTerminal)) continue;
                    it.remove();
                }
                line.terminal = null;
                line.nextTransient = null;
            } else {
                RouteLine temp;
                line.terminal.line = line;
                do {
                    this.transientLines.remove(line);
                    this.lines.add(line);
                    Iterator<RoutePoint> it = line.points.iterator();
                    while (it.hasNext()) {
                        RoutePoint point = it.next();
                        if (!(point instanceof RouteTerminal)) continue;
                        it.remove();
                    }
                    line.terminal = null;
                    temp = line.nextTransient;
                    line.nextTransient = null;
                } while ((line = temp) != null);
            }
            this.needsUpdate = true;
        }
    }

    void prepareForModification() {
        if (this.caseId == 4) {
            RouteLine line = this.transientLines.remove(0);
            line.terminal = null;
            this.lines.add(line);
            for (RouteTerminal terminal : this.terminals) {
                terminal.line = line;
            }
            this.isSimpleConnection = false;
            this.caseId = 6;
        }
    }

    public double[] getLineLengths(RouteTerminal terminal) {
        if (this.needsUpdate) {
            this.update();
        }
        if (this.lines.size() == 0 && this.transientLines.size() == 1) {
            return new double[]{this.transientLines.get(0).getLength()};
        }
        RouteLine line = null;
        block0: for (RouteLine l : this.transientLines) {
            if (!l.isTransient()) continue;
            for (RoutePoint p : l.points) {
                if (p instanceof RouteLink) continue;
                line = l;
                break block0;
            }
        }
        TDoubleArrayList result = new TDoubleArrayList();
        THashSet set = new THashSet();
        set.add(line);
        block2: while (true) {
            result.add(line.getLength());
            for (RoutePoint point : line.points) {
                if (!(point instanceof RouteLink)) continue;
                RouteLink link = (RouteLink)point;
                if (set.add((Object)link.a)) {
                    line = link.a;
                    continue block2;
                }
                if (!set.add((Object)link.b)) continue;
                line = link.b;
                continue block2;
            }
            break;
        }
        return result.toArray();
    }

    public void split(RouteLine rl1, double splitPosition) {
        if (this.needsUpdate) {
            this.update();
        }
        boolean isHorizontal = rl1.isHorizontal();
        if (this.isSimpleConnection) {
            this.isSimpleConnection = false;
            if (this.caseId < 2) {
                RouteLine sp = this.addLine(!isHorizontal, splitPosition);
                for (RouteTerminal terminal : this.terminals) {
                    terminal.line = sp;
                }
                this.update();
                return;
            }
            if (this.caseId < 4) {
                RouteLine sp = this.addLine(!isHorizontal, splitPosition);
                RouteLine l = this.addLine(isHorizontal, rl1.position);
                this.link(l, sp);
                rl1.terminal.line = sp;
                for (RouteTerminal terminal : this.terminals) {
                    if (terminal == rl1.terminal) continue;
                    terminal.line = l;
                }
                this.update();
                return;
            }
            this.prepareForModification();
        }
        RouteLine rl2 = new RouteLine(isHorizontal, rl1.getPosition());
        RouteLine sp = new RouteLine(!isHorizontal, splitPosition);
        ArrayList<RoutePoint> points = rl1.points;
        int minPos = 0;
        int maxPos = points.size();
        while (minPos != maxPos) {
            int c = (minPos + maxPos) / 2;
            if (isHorizontal ? points.get(c).getX() > splitPosition : points.get(c).getY() > splitPosition) {
                maxPos = c;
                continue;
            }
            minPos = c + 1;
        }
        int splitPos = minPos;
        int i = points.size() - 1;
        while (i >= splitPos) {
            RoutePoint point = points.remove(i);
            if (point instanceof RouteLink) {
                RouteLink link = (RouteLink)point;
                link.replace(rl1, rl2);
            }
            --i;
        }
        if (rl1.isTransient()) {
            boolean p1 = rl1.isConnectedToPeristentLine();
            boolean p2 = rl2.isConnectedToPeristentLine();
            RouteTerminal terminal = rl1.terminal;
            if (p1) {
                this.makePersistent(rl1);
                this.transientLines.add(rl2);
            } else if (p2) {
                this.lines.add(rl2);
            } else {
                this.transientLines.add(rl2);
                if (this.lines.isEmpty()) {
                    for (RouteTerminal t : this.terminals) {
                        t.line = sp;
                    }
                }
            }
            terminal.line = sp;
        } else {
            this.lines.add(rl2);
        }
        new RouteLink(rl1, sp);
        new RouteLink(sp, rl2);
        this.lines.add(sp);
        this.update();
    }

    public boolean merge(RouteLine line) {
        int count = 0;
        double sum = 0.0;
        for (RoutePoint point : line.points) {
            RouteLink link;
            RouteLine other;
            if (!(point instanceof RouteLink) || (other = (link = (RouteLink)point).getOther(line)).isTransient()) continue;
            sum += other.position;
            ++count;
        }
        return this.merge(line, sum / (double)count);
    }

    public boolean merge(RouteLine line, double position) {
        if (this.needsUpdate) {
            this.update();
        }
        if (this.isSimpleConnection || line.isTransient()) {
            return false;
        }
        if (this.lines.size() == 1) {
            if (this.terminals.size() != 2) {
                return false;
            }
            this.lines.remove(0);
            this.isSimpleConnection = true;
            for (RouteTerminal terminal : this.terminals) {
                terminal.line = null;
            }
            this.update();
            return true;
        }
        ArrayList<Object> nLines = new ArrayList<Object>();
        for (RoutePoint point : line.points) {
            if (!(point instanceof RouteLink)) continue;
            RouteLine l = ((RouteLink)point).getOther(line);
            l.points.remove(point);
            if (l.isTransient()) continue;
            nLines.add(l);
        }
        if (nLines.isEmpty()) {
            return false;
        }
        RouteLine merged = (RouteLine)nLines.remove(nLines.size() - 1);
        merged.position = position;
        for (RouteLine routeLine : nLines) {
            for (RoutePoint point : routeLine.points) {
                if (!(point instanceof RouteLink)) continue;
                RouteLink link = (RouteLink)point;
                link.replace(routeLine, merged);
            }
        }
        THashSet tHashSet = new THashSet();
        tHashSet.addAll(nLines);
        this.lines.removeAll((Collection<?>)tHashSet);
        tHashSet.add((Object)line);
        this.lines.remove(line);
        for (RouteTerminal terminal : this.terminals) {
            if (!tHashSet.contains((Object)terminal.line)) continue;
            terminal.line = merged;
        }
        this.update();
        return true;
    }

    public void deleteCorner(RouteLink link) {
        RouteLink l;
        if (this.needsUpdate) {
            this.update();
        }
        RouteLine a = link.getA();
        RouteLine b = link.getB();
        if (a.isTransient() || b.isTransient() || a.points.size() != 2 || b.points.size() != 2) {
            return;
        }
        RouteLine na = null;
        RouteLine nb = null;
        for (RoutePoint p : a.points) {
            l = (RouteLink)p;
            if (l.a == a && l.b != b) {
                na = l.b;
                break;
            }
            if (l.b != a || l.a == b) continue;
            na = l.a;
            break;
        }
        for (RoutePoint p : b.points) {
            l = (RouteLink)p;
            if (l.a == b && l.b != a) {
                nb = l.b;
                break;
            }
            if (l.b != b || l.a == a) continue;
            nb = l.a;
            break;
        }
        if (na == null || nb == null) {
            System.err.println("Internal error in router.");
            return;
        }
        a.remove();
        b.remove();
        this.lines.remove(a);
        this.lines.remove(b);
        this.link(na, nb);
        if (na.terminal != null) {
            na.terminal.line = nb;
        }
        if (nb.terminal != null) {
            nb.terminal.line = na;
        }
        this.update();
    }

    public boolean connectTerminal(RouteTerminal terminal, double x, double y, double tolerance) {
        Object target = this.pick(x, y, tolerance);
        if (target instanceof RouteLine) {
            int lineDir;
            RouteLine line = (RouteLine)target;
            RouteTerminal involvedTerminal = line.isTransient() ? line.terminal : null;
            this.makePersistent(line);
            terminal.line = null;
            int n = line.isHorizontal ? (line.position < terminal.y ? 3 : 1) : (lineDir = line.position < terminal.x ? 2 : 0);
            if (line.isHorizontal && Math.abs(x - terminal.x) > 30.0) {
                RouteLine l2;
                if (Directions.isAllowed(terminal.getAllowedDirections(), lineDir)) {
                    RouteLine l1 = this.addLine(true, 0.5 * (y + terminal.y));
                    l2 = this.addLine(false, x);
                    this.link(terminal, l1, l2, line);
                } else {
                    l2 = this.addLine(false, x);
                    this.link(terminal, l2, line);
                }
                if (involvedTerminal != null) {
                    involvedTerminal.line = l2;
                }
            } else if (!line.isHorizontal && Math.abs(y - terminal.y) > 30.0) {
                RouteLine l2;
                if (Directions.isAllowed(terminal.getAllowedDirections(), lineDir)) {
                    RouteLine l1 = this.addLine(false, 0.5 * (x + terminal.x));
                    l2 = this.addLine(true, y);
                    this.link(terminal, l1, l2, line);
                } else {
                    l2 = this.addLine(true, y);
                    this.link(terminal, l2, line);
                }
                if (involvedTerminal != null) {
                    involvedTerminal.line = l2;
                }
            } else {
                this.link(terminal, line);
            }
            this.update();
            return true;
        }
        return false;
    }

    public boolean connectLine(RouteLine sLine, double x, double y, double tolerance) {
        Object target = this.pick(x, y, tolerance);
        if (target instanceof RouteLine) {
            RouteLine line = (RouteLine)target;
            RouteTerminal involvedTerminal = line.isTransient() ? line.terminal : null;
            this.makePersistent(line);
            if (line.isHorizontal == sLine.isHorizontal) {
                RouteLine l = this.addLine(!sLine.isHorizontal, sLine.isHorizontal ? x : y);
                this.link(sLine, l, line);
                if (involvedTerminal != null) {
                    involvedTerminal.line = l;
                }
            } else {
                this.link(sLine, line);
                if (involvedTerminal != null) {
                    involvedTerminal.line = sLine;
                }
            }
            this.update();
            return true;
        }
        return false;
    }

    public RouteGraph copy(THashMap<Object, Object> map) {
        RouteGraph copy = new RouteGraph();
        copy.isSimpleConnection = this.isSimpleConnection;
        copy.caseId = this.caseId;
        copy.needsUpdate = this.needsUpdate;
        for (RouteLine line : this.lines) {
            copy.lines.add(line.copy(map));
        }
        for (RouteLine line : this.transientLines) {
            copy.transientLines.add(line.copy(map));
        }
        for (RouteTerminal terminal : this.terminals) {
            copy.terminals.add((RouteTerminal)terminal.copy((THashMap)map));
        }
        return copy;
    }

    public RouteGraph copy() {
        THashMap map = new THashMap();
        return this.copy((THashMap<Object, Object>)map);
    }

    public void removeExtraConnections() {
        boolean removed;
        TObjectIntHashMap counts = new TObjectIntHashMap();
        this.removeTransientRouteLines();
        for (RouteLine line : this.lines) {
            int count = 0;
            for (RoutePoint point : line.points) {
                if (!(point instanceof RouteLink)) continue;
                ++count;
            }
            counts.put((Object)line, count);
        }
        for (RouteTerminal terminal : this.terminals) {
            counts.adjustOrPutValue((Object)terminal.line, 1, 1);
        }
        do {
            removed = false;
            Iterator<RouteLine> it = this.lines.iterator();
            while (it.hasNext()) {
                RouteLine line = it.next();
                if (counts.get((Object)line) > 1) continue;
                for (RoutePoint point : line.points) {
                    if (!(point instanceof RouteLink)) continue;
                    counts.adjustValue((Object)((RouteLink)point).getOther(line), -1);
                }
                line.remove();
                it.remove();
                removed = true;
            }
        } while (removed);
        this.update();
    }

    public void remove(RouteTerminal terminal) {
        this.terminals.remove(terminal);
        this.removeExtraConnections();
    }

    public void disconnect(RouteTerminal terminal) {
        terminal.line = null;
        this.removeExtraConnections();
    }

    public void remove(RouteLink link) {
        link.a.points.remove(link);
        link.b.points.remove(link);
    }

    public void toggleDirectLines(RouteTerminal terminal) {
        terminal.toggleDirectLines();
        this.needsUpdate = true;
    }

    public Collection<RouteLine> getLines() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.lines;
    }

    public Collection<RouteLine> getTransientLines() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.transientLines;
    }

    public Collection<RouteTerminal> getTerminals() {
        return this.terminals;
    }

    public Collection<RouteLine> getAllLines() {
        if (this.needsUpdate) {
            this.update();
        }
        ArrayList<RouteLine> allLines = new ArrayList<RouteLine>(this.lines.size() + this.transientLines.size());
        allLines.addAll(this.lines);
        allLines.addAll(this.transientLines);
        return allLines;
    }

    public Collection<RouteLine> getAllLines(Collection<RouteLine> result) {
        if (result == null) {
            throw new NullPointerException("null result collection");
        }
        if (this.needsUpdate) {
            this.update();
        }
        result.addAll(this.lines);
        result.addAll(this.transientLines);
        return result;
    }

    public boolean isTree() {
        if (this.isSimpleConnection) {
            return true;
        }
        for (RouteTerminal terminal : this.terminals) {
            if (terminal.line != null) continue;
            return false;
        }
        THashSet visited = new THashSet();
        ArrayList<RouteLine> stack = new ArrayList<RouteLine>();
        int linkCount = 0;
        visited.add((Object)this.lines.get(0));
        stack.add(this.lines.get(0));
        while (!stack.isEmpty()) {
            RouteLine cur = (RouteLine)stack.remove(stack.size() - 1);
            for (RouteLine n : cur.getPersistentNeighbors()) {
                ++linkCount;
                if (!visited.add((Object)n)) continue;
                stack.add(n);
            }
        }
        return visited.size() == this.lines.size() && linkCount == 2 * (this.lines.size() - 1);
    }

    public boolean isSimpleConnection() {
        return this.isSimpleConnection;
    }

    public void replaceBy(RouteGraph rg) {
        this.lines = rg.lines;
        this.terminals = rg.terminals;
        this.transientLines = rg.transientLines;
        this.caseId = rg.caseId;
        this.isSimpleConnection = rg.isSimpleConnection;
        this.needsUpdate = rg.needsUpdate;
        rg.reset();
    }

    private void reset() {
        this.lines = new ArrayList();
        this.terminals = new ArrayList();
        this.transientLines = new ArrayList();
        this.caseId = 0;
        this.isSimpleConnection = false;
        this.needsUpdate = false;
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        this.getBounds(bounds);
        return bounds;
    }

    public void getBounds(Rectangle2D bounds) {
        double position;
        if (this.needsUpdate) {
            this.update();
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (RouteLine line : this.lines) {
            position = line.position;
            if (line.isHorizontal) {
                minY = Math.min(minY, position);
                maxY = Math.max(maxY, position);
                continue;
            }
            minX = Math.min(minX, position);
            maxX = Math.max(maxX, position);
        }
        for (RouteLine line : this.transientLines) {
            position = line.position;
            if (line.isHorizontal) {
                minY = Math.min(minY, position);
                maxY = Math.max(maxY, position);
                continue;
            }
            minX = Math.min(minX, position);
            maxX = Math.max(maxX, position);
        }
        for (RouteTerminal terminal : this.terminals) {
            double x = terminal.x;
            double y = terminal.y;
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        bounds.setFrame(minX, minY, maxX - minX, maxY - minY);
    }

    private static void addPathBegin(Path2D path, RoutePoint cur, RouteLine line) {
        double x = cur.x;
        double y = cur.y;
        if (cur instanceof RouteTerminal) {
            ILineEndStyle style = ((RouteTerminal)cur).getRenderStyle();
            if (line.isHorizontal()) {
                x = cur == line.getBegin() ? (x += style.getLineEndLength(0)) : (x -= style.getLineEndLength(2));
            } else {
                y = cur == line.getBegin() ? (y += style.getLineEndLength(1)) : (y -= style.getLineEndLength(3));
            }
        }
        path.moveTo(x, y);
    }

    private static void addPathEnd(Path2D path, RoutePoint cur, RouteLine line) {
        double x = cur.x;
        double y = cur.y;
        if (cur instanceof RouteTerminal) {
            ILineEndStyle style = ((RouteTerminal)cur).getRenderStyle();
            if (line.isHorizontal()) {
                x = cur == line.getBegin() ? (x += style.getLineEndLength(0)) : (x -= style.getLineEndLength(2));
            } else {
                y = cur == line.getBegin() ? (y += style.getLineEndLength(1)) : (y -= style.getLineEndLength(3));
            }
        }
        path.lineTo(x, y);
    }

    public void getPath2D(Path2D path) {
        if (this.needsUpdate) {
            this.update();
        }
        if (this.isSimpleConnection && this.transientLines.isEmpty() && this.terminals.size() == 2 || this.isDirectDirectConnection()) {
            RouteTerminal a = this.terminals.get(0);
            RouteTerminal b = this.terminals.get(1);
            if (a.hasDirectConnection() || b.hasDirectConnection()) {
                path.moveTo(a.x, a.y);
                path.lineTo(b.x, b.y);
                return;
            }
        }
        HashMap<RoutePoint, RouteLine> begins = new HashMap<RoutePoint, RouteLine>();
        for (RouteLine line : this.lines) {
            RouteGraph.add(begins, line);
        }
        for (RouteLine line : this.transientLines) {
            RouteGraph.add(begins, line);
        }
        for (RouteTerminal terminal : this.terminals) {
            if ((terminal.getAllowedDirections() & 0x10) == 0 || terminal.line == null) continue;
            begins.remove(terminal.line.getBegin());
            this.drawContinuousPath(path, begins, terminal, terminal.line);
        }
        for (RoutePoint begin : begins.keySet().stream().sorted(RG_COMP).collect(Collectors.toList())) {
            RouteLine curLine = (RouteLine)begins.remove(begin);
            this.drawContinuousPath(path, begins, begin, curLine);
        }
    }

    private void drawContinuousPath(Path2D path, Map<RoutePoint, RouteLine> begins, RoutePoint cur, RouteLine curLine) {
        if (curLine == null) {
            return;
        }
        RouteGraph.addPathBegin(path, cur, curLine);
        while (true) {
            if (cur != curLine.getEnd()) {
                cur = curLine.getEnd();
            } else {
                RoutePoint next = curLine.getBegin();
                if (next == cur) {
                    return;
                }
                cur = next;
            }
            if (begins.remove(cur) != null || !(cur instanceof RouteLink)) {
                RouteGraph.addPathEnd(path, cur, curLine);
                return;
            }
            if (!(cur instanceof RouteLink)) continue;
            if (!curLine.isDegenerated() || path.getCurrentPoint().getX() != cur.x || path.getCurrentPoint().getY() != cur.y) {
                path.lineTo(cur.x, cur.y);
            }
            RouteLink link = (RouteLink)cur;
            if (link.a != curLine) {
                curLine = link.a;
                continue;
            }
            curLine = link.b;
        }
    }

    private static void add(Map<RoutePoint, RouteLine> begins, RouteLine line) {
        if (line.points.size() > 1) {
            RoutePoint p = line.getBegin();
            if (begins.remove(p) == null) {
                begins.put(p, line);
            }
            if (begins.remove(p = line.getEnd()) == null) {
                begins.put(p, line);
            }
        }
    }

    public Collection<Segment> getSegments() {
        if (this.needsUpdate) {
            this.update();
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (RouteLine routeLine : this.lines) {
            routeLine.collectSegments(segments);
        }
        for (RouteLine routeLine : this.transientLines) {
            routeLine.collectSegments(segments);
        }
        return segments;
    }

    public Segment findNearestSegment(double x, double y) {
        Segment nearest = null;
        double minDistanceSq = Double.MAX_VALUE;
        for (Segment segment : this.getSegments()) {
            RoutePoint p1 = segment.p1;
            RoutePoint p2 = segment.p2;
            double distanceSq = Line2D.ptSegDistSq(p1.x, p1.y, p2.x, p2.y, x, y);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            nearest = segment;
        }
        return nearest;
    }

    public Point2D findNearestPoint(double x, double y) {
        Segment nearest = this.findNearestSegment(x, y);
        if (nearest == null) {
            return null;
        }
        RoutePoint p1 = nearest.p1;
        RoutePoint p2 = nearest.p2;
        double d = Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0);
        if (d == 0.0) {
            return new Point2D.Double(p1.x, p1.y);
        }
        double u = ((x - p1.x) * (p2.x - p1.x) + (y - p1.y) * (p2.y - p1.y)) / d;
        if (u > 1.0) {
            return new Point2D.Double(p2.x, p2.y);
        }
        if (u <= 0.0) {
            return new Point2D.Double(p1.x, p1.y);
        }
        return new Point2D.Double(p2.x * u + p1.x * (1.0 - u), p2.y * u + p1.y * (1.0 - u));
    }

    public Path2D getPath2D() {
        Path2D.Double result = new Path2D.Double();
        this.getPath2D(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public SplittedRouteGraph splitGraph(RouteLine splitLine, double position) {
        THashSet interfaceNodes1 = new THashSet();
        THashSet lines1 = new THashSet();
        THashSet terminals1 = new THashSet();
        THashSet interfaceNodes2 = new THashSet();
        THashSet lines2 = new THashSet();
        THashSet terminals2 = new THashSet();
        if (splitLine.isTransient()) {
            RouteTerminal terminal = splitLine.terminal;
            if (splitLine.beginsWithTerminal()) {
                lines2.addAll(this.getLines());
                terminals2.addAll(this.getTerminals());
                terminals1.add((Object)terminal);
                terminals2.remove((Object)terminal);
                interfaceNodes1.add((Object)terminal);
                if (this.isSimpleConnection()) {
                    interfaceNodes2.addAll((Collection)terminals2);
                } else {
                    interfaceNodes2.add((Object)terminal.line);
                }
            } else {
                lines1.addAll(this.getLines());
                terminals1.addAll(this.getTerminals());
                terminals2.add((Object)terminal);
                terminals1.remove((Object)terminal);
                interfaceNodes2.add((Object)terminal);
                if (this.isSimpleConnection()) {
                    interfaceNodes1.addAll((Collection)terminals1);
                } else {
                    interfaceNodes1.add((Object)terminal.line);
                }
            }
        } else {
            List<RouteLine> linesNotProcessed;
            double p;
            for (RoutePoint rp : splitLine.getPoints()) {
                void link;
                RouteLine otherLine;
                p = splitLine.isHorizontal ? rp.x : rp.y;
                RoutePoint routePoint = rp;
                if (!(routePoint instanceof RouteLink)) continue;
                RouteLink cfr_ignored_0 = (RouteLink)routePoint;
                RouteLink cfr_ignored_1 = (RouteLink)routePoint;
                RouteLine routeLine = otherLine = link.getA() != splitLine ? link.getA() : link.getB();
                if (otherLine.isTransient()) {
                    if (p < position) {
                        interfaceNodes1.add((Object)otherLine.terminal);
                        terminals1.add((Object)otherLine.terminal);
                        continue;
                    }
                    interfaceNodes2.add((Object)otherLine.terminal);
                    terminals2.add((Object)otherLine.terminal);
                    continue;
                }
                if (p < position) {
                    interfaceNodes1.add((Object)otherLine);
                    this.traverseGraph((RoutePoint)link, otherLine, (THashSet<RouteLine>)lines1);
                    continue;
                }
                interfaceNodes2.add((Object)otherLine);
                this.traverseGraph((RoutePoint)link, otherLine, (THashSet<RouteLine>)lines2);
            }
            for (RouteTerminal rt : this.getTerminals()) {
                if (terminals1.contains((Object)rt) || terminals2.contains((Object)rt)) continue;
                if (lines1.contains((Object)rt.line)) {
                    terminals1.add((Object)rt);
                    continue;
                }
                if (lines2.contains((Object)rt.line)) {
                    terminals2.add((Object)rt);
                    continue;
                }
                double d = p = splitLine.isHorizontal ? rt.x : rt.y;
                if (rt.line == splitLine) {
                    if (p < position) {
                        interfaceNodes1.add((Object)rt);
                        terminals1.add((Object)rt);
                        continue;
                    }
                    terminals2.add((Object)rt);
                    interfaceNodes2.add((Object)rt);
                    continue;
                }
                THashSet lines = new THashSet();
                int side = this.findSplitSide(position, splitLine, rt, rt.line, (THashSet<RouteLine>)lines);
                if (side == 1) {
                    interfaceNodes1.add((Object)rt);
                    terminals1.add((Object)rt);
                    lines1.addAll((Collection)lines);
                    continue;
                }
                if (side != 2) continue;
                terminals2.add((Object)rt);
                interfaceNodes2.add((Object)rt);
                lines2.addAll((Collection)lines);
            }
            if (!splitLine.isTransient()) {
                lines1.add((Object)splitLine);
            }
            if (!(linesNotProcessed = this.getLines().stream().filter(rl -> !lines1.contains(rl) && !lines2.contains(rl)).toList()).isEmpty()) {
                throw new IllegalStateException("Not all route lines were processed while splitting the connection. Split failed.");
            }
            List<RouteLine> invalidlySplit = this.getLines().stream().filter(rl -> !(lines1.contains(rl) ^ lines2.contains(rl))).toList();
            if (!invalidlySplit.isEmpty()) {
                throw new IllegalStateException("BUG: Some route lines were added to both sides of the split connection during splitting. Split failed.");
            }
        }
        return new SplittedRouteGraph(splitLine, (THashSet<RouteNode>)interfaceNodes1, (THashSet<RouteLine>)lines1, (THashSet<RouteTerminal>)terminals1, (THashSet<RouteNode>)interfaceNodes2, (THashSet<RouteLine>)lines2, (THashSet<RouteTerminal>)terminals2);
    }

    /*
     * WARNING - void declaration
     */
    private void traverseGraph(RoutePoint previousPoint, RouteLine line, THashSet<RouteLine> lines) {
        if (lines.add((Object)line)) {
            for (RoutePoint rp : line.getPoints()) {
                void link;
                RouteLine otherLine;
                RoutePoint routePoint;
                if (rp == previousPoint || !((routePoint = rp) instanceof RouteLink)) continue;
                RouteLink cfr_ignored_0 = (RouteLink)routePoint;
                RouteLink cfr_ignored_1 = (RouteLink)routePoint;
                RouteLine routeLine = otherLine = line != link.getA() ? link.getA() : link.getB();
                if (otherLine.isTransient()) continue;
                this.traverseGraph(rp, otherLine, lines);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int findSplitSide(double splitPosition, RouteLine splitLine, RoutePoint previousPoint, RouteLine line, THashSet<RouteLine> lines) {
        int ret = 0;
        if (lines.add((Object)line)) {
            for (RoutePoint rp : line.getPoints()) {
                void link;
                RouteLine otherLine;
                RoutePoint routePoint;
                if (rp == previousPoint || !((routePoint = rp) instanceof RouteLink)) continue;
                RouteLink cfr_ignored_0 = (RouteLink)routePoint;
                RouteLink cfr_ignored_1 = (RouteLink)routePoint;
                RouteLine routeLine = otherLine = line != link.getA() ? link.getA() : link.getB();
                if (otherLine.isTransient()) continue;
                if (otherLine == splitLine) {
                    double p = splitLine.isHorizontal ? link.x : link.y;
                    ret = p < splitPosition ? 1 : 2;
                }
                int r = this.findSplitSide(splitPosition, splitLine, rp, otherLine, lines);
                if (ret != 0 || r == 0) continue;
                ret = r;
            }
        }
        return ret;
    }

    public void reclaimTransientMemory() {
        this.removeTransientRouteLines();
        this.needsUpdate = true;
    }

    public static class Interval {
        public final double min;
        public final double max;

        public Interval(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }

    public class IntervalCache {
        THashMap<RouteLine, Interval> cache = new THashMap();

        public Interval get(RouteLine line) {
            Interval result = (Interval)this.cache.get((Object)line);
            if (result != null) {
                return result;
            }
            result = this.create(line);
            this.cache.put((Object)line, (Object)result);
            return result;
        }

        private Interval create(RouteLine line) {
            double temp;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (RoutePoint point : line.points) {
                if (point instanceof RouteLink) {
                    RouteLink link = (RouteLink)point;
                    temp = link.a == line ? link.b.position : link.a.position;
                } else {
                    RouteTerminal terminal = (RouteTerminal)point;
                    temp = line.isHorizontal ? terminal.x : terminal.y;
                }
                if (temp < min) {
                    min = temp;
                }
                if (!(temp > max)) continue;
                max = temp;
            }
            for (RouteTerminal terminal : RouteGraph.this.terminals) {
                if (terminal.line != line) continue;
                temp = terminal.approximatePositionToLine();
                if (temp < min) {
                    min = temp;
                }
                if (!(temp > max)) continue;
                max = temp;
            }
            return new Interval(min, max);
        }
    }
}

