/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import java.io.File;
import java.io.FileInputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ChunkedRequests {
    public static Response chunkedPost(Client httpClient, String url, File f, int chunk_size) throws Exception {
        FileInputStream fileInStream = new FileInputStream(f);
        String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";
        WebTarget webTarget = ChunkedRequests.prepare(httpClient, url, f, chunk_size);
        Response r = webTarget.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header("Content-Disposition", (Object)contentDisposition).header("Content-Length", (Object)((int)f.length())).post(Entity.entity((Object)fileInStream, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        return r;
    }

    public static Response chunkedPostAuth(Client httpClient, String url, File f, int chunk_size, String authHeaderField) throws Exception {
        FileInputStream fileInStream = new FileInputStream(f);
        String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";
        WebTarget webTarget = ChunkedRequests.prepare(httpClient, url, f, chunk_size);
        Response r = webTarget.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header("Content-Disposition", (Object)contentDisposition).header("Content-Length", (Object)((int)f.length())).header("Authorization", (Object)authHeaderField).post(Entity.entity((Object)fileInStream, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        return r;
    }

    public static Response chunkedPut(Client httpClient, String url, File f, int chunk_size) throws Exception {
        FileInputStream fileInStream = new FileInputStream(f);
        String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";
        WebTarget webTarget = ChunkedRequests.prepare(httpClient, url, f, chunk_size);
        Response r = webTarget.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header("Content-Disposition", (Object)contentDisposition).header("Content-Length", (Object)((int)f.length())).put(Entity.entity((Object)fileInStream, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        return r;
    }

    public static Response chunkedPutAuth(Client httpClient, String url, File f, int chunk_size, String authHeaderField) throws Exception {
        FileInputStream fileInStream = new FileInputStream(f);
        String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";
        WebTarget webTarget = ChunkedRequests.prepare(httpClient, url, f, chunk_size);
        Response r = webTarget.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header("Content-Disposition", (Object)contentDisposition).header("Content-Length", (Object)((int)f.length())).header("Authorization", (Object)authHeaderField).put(Entity.entity((Object)fileInStream, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        return r;
    }

    private static WebTarget prepare(Client httpClient, String url, File f, int chunk_size) {
        httpClient.property("jersey.config.client.chunkedEncodingSize", (Object)("" + chunk_size));
        httpClient.property("jersey.config.client.request.entity.processing", (Object)"CHUNKED");
        WebTarget webTarget = httpClient.target(url);
        Invocation.Builder builder = webTarget.request();
        builder.accept(new MediaType[]{MediaType.WILDCARD_TYPE});
        return webTarget;
    }
}

