/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.units.internal.parser;

import org.simantics.databoard.units.internal.UnitParseException;

public abstract class UnitParser {
    String string;
    int pos;
    int nextChar;
    int sign;

    void next() {
        ++this.pos;
        this.nextChar = this.pos >= this.string.length() ? -1 : (int)this.string.charAt(this.pos);
    }

    public void unit(String string, int sign) throws UnitParseException {
        this.string = string;
        this.pos = -1;
        this.sign = sign;
        this.next();
        this.expression();
        this.expect(-1);
    }

    void expression() throws UnitParseException {
        this.numerator();
        if (this.nextChar == 47) {
            this.next();
            this.denominator();
        }
    }

    void numerator() throws UnitParseException {
        if (this.nextChar == 49) {
            this.next();
        } else if (this.nextChar == 40) {
            this.next();
            this.expression();
            this.skip(')');
        } else {
            this.factors();
        }
    }

    void denominator() throws UnitParseException {
        this.sign = -this.sign;
        if (this.nextChar == 40) {
            this.next();
            this.expression();
            this.skip(')');
        } else {
            this.factor();
        }
        this.sign = -this.sign;
    }

    void factors() throws UnitParseException {
        while (true) {
            this.factor();
            if (this.nextChar != 46) break;
            this.next();
        }
    }

    void factor() throws UnitParseException {
        int exponentEnd;
        int factorBegin = this.pos;
        while (this.nextChar >= 97 && this.nextChar <= 122 || this.nextChar >= 65 && this.nextChar <= 90 || this.nextChar == 65533 || this.nextChar == 40 || this.nextChar == 41 || this.nextChar == 37) {
            this.next();
        }
        int exponentBegin = this.pos;
        if (factorBegin == exponentBegin) {
            throw new UnitParseException(this.string, "Expected base unit name, but got " + UnitParser.charName(this.nextChar) + " at position " + this.pos + ".");
        }
        String baseUnit = this.string.substring(factorBegin, exponentBegin);
        if (this.nextChar == 45 || this.nextChar == 43 || this.nextChar >= 48 && this.nextChar <= 57) {
            this.next();
            while (this.nextChar >= 48 && this.nextChar <= 57) {
                this.next();
            }
        }
        if ((exponentEnd = this.pos) > exponentBegin) {
            String exponentString = this.string.substring(exponentBegin, exponentEnd);
            try {
                this.visit(baseUnit, this.sign * Integer.parseInt(exponentString));
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnitParseException(this.string, "Invalid exponent \"" + exponentString + "\" at position " + this.pos + ".");
            }
        } else {
            this.visit(baseUnit, this.sign);
        }
    }

    private void skip(char c) throws UnitParseException {
        this.expect(c);
        this.next();
    }

    private static String charName(int c) {
        if (c >= 0) {
            return "'" + Character.toString((char)c) + "'";
        }
        return "end of unit";
    }

    private void expect(int c) throws UnitParseException {
        if (this.nextChar != c) {
            throw new UnitParseException(this.string, "Expected " + UnitParser.charName(c) + ", but got " + UnitParser.charName(this.nextChar) + " at position " + this.pos + ".");
        }
    }

    public abstract void visit(String var1, int var2);
}

