/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Objects;
import java.util.Set;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;

public class MapType
extends Datatype {
    public static final String KEY_ORDERED = "ordered";
    public Datatype keyType;
    public Datatype valueType;

    public MapType() {
    }

    public MapType(Datatype keyType, Datatype valueType) {
        if (keyType == null || valueType == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public int getComponentCount() {
        return 2;
    }

    @Override
    public Datatype getComponentType(int index) {
        if (index == 0) {
            return this.keyType;
        }
        if (index == 1) {
            return this.valueType;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype getComponentType(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            if (ir.index == 0) {
                return this.keyType.getComponentType(path.childReference);
            }
            if (ir.index == 1) {
                return this.valueType.getComponentType(path.childReference);
            }
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            if (lr.label.equals("0") || lr.label.equals("key")) {
                return this.keyType.getComponentType(path.childReference);
            }
            if (lr.label.equals("1") || lr.label.equals("value")) {
                return this.valueType.getComponentType(path.childReference);
            }
        }
        if (path instanceof NameReference) {
            NameReference nr = (NameReference)path;
            if (nr.name.equals("key")) {
                return this.keyType.getComponentType(path.childReference);
            }
            if (nr.name.equals("value")) {
                return this.valueType.getComponentType(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        if (!(obj instanceof MapType)) {
            return false;
        }
        MapType other = (MapType)obj;
        return this.keyType.deepEquals(other.keyType, compareHistory) && this.valueType.deepEquals(other.valueType, compareHistory);
    }

    @Override
    protected void collectSubtypes(Set<Datatype> subtypes, Set<Datatype> recursiveSubtypes) {
        this.keyType.collectSubtypes(subtypes, recursiveSubtypes);
        this.valueType.collectSubtypes(subtypes, recursiveSubtypes);
    }

    @Override
    public int hashCode() {
        if (this.keyType == this) {
            return 0;
        }
        if (this.valueType == this) {
            return 0;
        }
        return 144046 + Objects.hashCode(this.keyType) * 13 + Objects.hashCode(this.valueType) * 17;
    }

    @Override
    public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            return this.keyType.getChildType(reference.getChildReference());
        }
        if (reference instanceof KeyReference) {
            return this.keyType.getChildType(reference.getChildReference());
        }
        throw new ReferenceException(reference.getClass().getName() + " is not a reference of a map");
    }
}

