/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryReadable;
import org.simantics.databoard.util.binary.ByteBufferReadable;
import org.simantics.databoard.util.binary.ByteBufferWriteable;
import org.simantics.databoard.util.binary.InputStreamReadable;
import org.simantics.databoard.util.binary.OutputStreamWriteable;

public abstract class Serializer {
    public abstract void serialize(DataOutput var1, TObjectIntHashMap<Object> var2, Object var3) throws IOException;

    public abstract void serialize(DataOutput var1, Object var2) throws IOException;

    public void serialize(OutputStream out, Object obj) throws IOException {
        OutputStreamWriteable writ = new OutputStreamWriteable(out);
        this.serialize(writ, obj);
    }

    public abstract Object deserialize(DataInput var1, List<Object> var2) throws IOException;

    public abstract Object deserialize(DataInput var1) throws IOException;

    public abstract void deserializeTo(DataInput var1, List<Object> var2, Object var3) throws IOException;

    public abstract void deserializeTo(DataInput var1, Object var2) throws IOException;

    public Object deserializeToTry(DataInput in, List<Object> identities, Object dst) throws IOException {
        this.deserializeTo(in, identities, dst);
        return dst;
    }

    public Object deserialize(InputStream in) throws IOException {
        InputStreamReadable read = new InputStreamReadable(in, Long.MAX_VALUE);
        return this.deserialize(read);
    }

    public void deserialize(InputStream in, Object obj) throws IOException {
        InputStreamReadable read = new InputStreamReadable(in, Long.MAX_VALUE);
        this.deserializeTo(read, obj);
    }

    public Object deserialize(File file) throws IOException {
        try (BinaryFile f = new BinaryFile(file);){
            Object object = this.deserialize(f);
            return object;
        }
    }

    public void deserialize(File file, Object obj) throws IOException {
        try (BinaryFile f = new BinaryFile(file);){
            this.deserializeTo(f, obj);
        }
    }

    public Object deserialize(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        ByteBufferReadable readable = new ByteBufferReadable(buffer);
        return this.deserialize(readable);
    }

    public void deserialize(byte[] data, Object obj) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        ByteBufferReadable readable = new ByteBufferReadable(buffer);
        this.deserializeTo(readable, obj);
    }

    public abstract void skip(DataInput var1, List<Object> var2) throws IOException;

    public abstract void skip(DataInput var1) throws IOException;

    public void skip(InputStream in) throws IOException {
        InputStreamReadable read = new InputStreamReadable(in, Long.MAX_VALUE);
        this.skip(read);
    }

    public abstract Integer getConstantSize();

    public abstract int getSize(Object var1, TObjectIntHashMap<Object> var2) throws IOException;

    public abstract int getSize(Object var1) throws IOException;

    public abstract int getMinSize();

    public byte[] serialize(Object obj) throws IOException {
        TObjectIntHashMap identities = new TObjectIntHashMap();
        int size = this.getSize(obj, (TObjectIntHashMap<Object>)identities);
        identities.clear();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        ByteBufferWriteable writable = new ByteBufferWriteable(buffer);
        this.serialize(writable, (TObjectIntHashMap<Object>)identities, obj);
        buffer.rewind();
        return buffer.array();
    }

    public void serialize(Object obj, OutputStream out) throws IOException {
        OutputStreamWriteable writ = new OutputStreamWriteable(out);
        TObjectIntHashMap identities = new TObjectIntHashMap();
        this.serialize(writ, (TObjectIntHashMap<Object>)identities, obj);
    }

    public void serialize(Object obj, File file) throws IOException {
        TObjectIntHashMap identities = new TObjectIntHashMap();
        try (BinaryFile writable = new BinaryFile(file);){
            this.serialize(writable, (TObjectIntHashMap<Object>)identities, obj);
        }
    }

    public InputStream getInputStream(Object obj) throws IOException {
        byte[] data = this.serialize(obj);
        return new ByteArrayInputStream(data);
    }

    protected void assertRemainingBytes(DataInput in, long bts) throws IOException {
        if (!(in instanceof BinaryReadable)) {
            return;
        }
        BinaryReadable r = (BinaryReadable)in;
        if (bts > r.length() - r.position()) {
            throw new SerializationException("Malformed data. Serialization aborted. (Wrong binding?)");
        }
    }

    public static abstract class CompositeSerializer
    extends Serializer {
        boolean recursive;

        protected CompositeSerializer(boolean recursive) {
            this.recursive = recursive;
        }

        public abstract void finalizeConstruction();

        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            TObjectIntHashMap identities = this.recursive ? new TObjectIntHashMap(0) : null;
            this.serialize(out, (TObjectIntHashMap<Object>)identities, obj);
        }

        @Override
        public Object deserialize(DataInput in) throws IOException {
            ArrayList<Object> identities = this.recursive ? new ArrayList<Object>(0) : null;
            return this.deserialize(in, identities);
        }

        @Override
        public void deserializeTo(DataInput in, Object obj) throws IOException {
            ArrayList<Object> identities = this.recursive ? new ArrayList<Object>(0) : null;
            this.deserializeTo(in, identities, obj);
        }

        @Override
        public void skip(DataInput in) throws IOException {
            ArrayList<Object> identities = this.recursive ? new ArrayList<Object>(0) : null;
            this.skip(in, identities);
        }

        @Override
        public int getSize(Object obj) throws IOException {
            TObjectIntHashMap identities = this.recursive ? new TObjectIntHashMap(0) : null;
            return this.getSize(obj, (TObjectIntHashMap<Object>)identities);
        }
    }

    public static abstract class NonRecursiveSerializer
    extends Serializer {
        @Override
        public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
            this.serialize(out, obj);
        }

        @Override
        public Object deserialize(DataInput in, List<Object> identities) throws IOException {
            return this.deserialize(in);
        }

        @Override
        public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
            this.deserializeTo(in, obj);
        }

        @Override
        public void skip(DataInput in, List<Object> identities) throws IOException {
            this.skip(in);
        }

        @Override
        public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
            return this.getSize(obj);
        }
    }

    public static abstract class RecursiveSerializer
    extends Serializer {
        public abstract void finalizeConstruction();

        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            TObjectIntHashMap identities = new TObjectIntHashMap(0);
            this.serialize(out, (TObjectIntHashMap<Object>)identities, obj);
        }

        @Override
        public Object deserialize(DataInput in) throws IOException {
            ArrayList<Object> identities = new ArrayList<Object>(0);
            return this.deserialize(in, identities);
        }

        @Override
        public void deserializeTo(DataInput in, Object obj) throws IOException {
            ArrayList<Object> identities = new ArrayList<Object>(0);
            this.deserializeTo(in, identities, obj);
        }

        @Override
        public void skip(DataInput in) throws IOException {
            ArrayList<Object> identities = new ArrayList<Object>(0);
            this.skip(in, identities);
        }

        @Override
        public int getSize(Object obj) throws IOException {
            TObjectIntHashMap identities = new TObjectIntHashMap(0);
            return this.getSize(obj, (TObjectIntHashMap<Object>)identities);
        }
    }
}

