/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.util.IdentityPair;

public abstract class BooleanBinding
extends Binding {
    public BooleanBinding(BooleanType type) {
        this.type = type;
    }

    public abstract Object create(boolean var1) throws BindingException;

    public abstract Object create(Boolean var1) throws BindingException;

    public abstract void setValue(Object var1, Boolean var2) throws BindingException;

    public abstract void setValue(Object var1, boolean var2) throws BindingException;

    public abstract Boolean getValue(Object var1) throws BindingException;

    public abstract boolean getValue_(Object var1) throws BindingException;

    public Object createUnchecked(Boolean value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        boolean v = ((BooleanBinding)srcBinding).getValue_(src);
        this.setValue(dst, v);
    }

    @Override
    public BooleanType type() {
        return (BooleanType)super.type();
    }

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        if (!this.isInstance(obj)) {
            throw new BindingException("Not a boolean instance");
        }
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        boolean b = this.getValue_(value);
        return b ? 1231 : 1237;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        boolean v1 = this.getValue_(o1);
        boolean v2 = this.getValue_(o2);
        return v2 == v1 ? 0 : (v1 ? 1 : -1);
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        ctx.b.append(this.getValue_(value));
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    public Binding getComponentBinding(int index) {
        throw new IllegalArgumentException();
    }
}

