/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.lang.ref.SoftReference;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.RecordInterestSet;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.RecordType;

public class JavaRecord
extends JavaObject
implements RecordAccessor {
    SoftReference<JavaObject>[] children;

    public JavaRecord(Accessor parent, RecordBinding binding, Object object, AccessorParams params) throws AccessorConstructionException {
        super(parent, binding, object, params);
        RecordType type = binding.type();
        if (type.isReferable()) {
            throw new AccessorConstructionException("Refereable record are not supported");
        }
        int count = binding.type().getComponentCount();
        this.children = new SoftReference[count];
    }

    @Override
    public RecordBinding getBinding() {
        return (RecordBinding)this.binding;
    }

    @Override
    public RecordType type() {
        return this.getBinding().type();
    }

    @Override
    public int count() {
        return this.type().getComponentCount();
    }

    @Override
    public <T extends Accessor> T getFieldAccessor(String fieldName) throws AccessorConstructionException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorConstructionException("Field " + fieldName + " does not exist");
        }
        return this.getFieldAccessor(fieldIndex);
    }

    @Override
    public <T extends Accessor> T getFieldAccessor(int index) throws AccessorConstructionException {
        if (index < 0 || index >= this.count()) {
            throw new ReferenceException("Field index (" + index + ") out of bounds (" + this.count() + ")");
        }
        this.readLock();
        try {
            JavaObject sa;
            SoftReference<JavaObject> ref = this.children[index];
            JavaObject javaObject = sa = ref != null ? ref.get() : null;
            if (sa == null) {
                Binding cb = this.getBinding().getComponentBindings()[index];
                Object cv = this.getBinding().getComponent(this.object, index);
                sa = JavaRecord.createSubAccessor(this, cb, cv, this.params);
                sa.keyInParent = index;
                this.children[index] = new SoftReference<JavaObject>(sa);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    RecordInterestSet is = (RecordInterestSet)le.getInterestSet();
                    InterestSet cis = is.getComponentInterest(index);
                    if (cis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new IndexReference(index));
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            JavaObject javaObject2 = sa;
            return (T)javaObject2;
        }
        catch (BindingException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    JavaObject getExistingAccessor(int index) {
        if (index < 0 || index >= this.count()) {
            throw new RuntimeException("Field index (" + index + ") out of bounds (" + this.count() + ")");
        }
        SoftReference<JavaObject> ref = this.children[index];
        JavaObject accessor = ref != null ? ref.get() : null;
        return accessor;
    }

    @Override
    public Object getFieldValue(String fieldName, Binding fieldBinding) throws AccessorException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorException("Field " + fieldName + " does not exist");
        }
        return this.getFieldValue(fieldIndex, fieldBinding);
    }

    @Override
    public Object getFieldValue(int index, Binding fieldBinding) throws AccessorException {
        this.readLock();
        try {
            Object cv = this.getBinding().getComponent(this.object, index);
            Binding cb = this.getBinding().getComponentBindings()[index];
            Object object = this.adapt(cv, cb, fieldBinding);
            return object;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setFieldValue(String fieldName, Binding fieldBinding, Object value) throws AccessorException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorException("Field " + fieldName + " does not exist");
        }
        this.setFieldValue(fieldIndex, fieldBinding, value);
    }

    @Override
    public void setFieldValue(int index, Binding binding, Object value) throws AccessorException {
        this.writeLock();
        try {
            try {
                JavaObject sa = this.getExistingAccessor(index);
                if (sa == null) {
                    Binding lb = this.getBinding().getComponentBindings()[index];
                    Binding rb = binding;
                    Object rv = value;
                    Object lv = this.adapt(rv, rb, lb);
                    this.getBinding().setComponent(this.object, index, lv);
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        RecordInterestSet is = (RecordInterestSet)le.getInterestSet();
                        if (is.inNotificationsOf(index)) {
                            MutableVariant newValue;
                            MutableVariant mutableVariant = newValue = is.inValuesOf(index) ? new MutableVariant(binding, value) : null;
                            if (is.inValuesOf(index)) {
                                newValue = new MutableVariant(binding, binding.isImmutable() ? value : binding.clone(value));
                            }
                            ValueAssigned e = new ValueAssigned(new IndexReference(index), newValue);
                            this.emitEvent(le, e);
                        }
                        le = le.next;
                    }
                } else {
                    sa.setValue(binding, value);
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        RecordInterestSet is = (RecordInterestSet)interestSet;
        super.addListener(listener, interestSet, path, executor);
        if (is.componentInterests != null) {
            int i = 0;
            while (i < this.count()) {
                JavaObject childAccessor;
                InterestSet cis = is.getComponentInterest(i);
                if (cis != null && (childAccessor = this.getExistingAccessor(i)) != null) {
                    ChildReference childPath = ChildReference.concatenate(path, new IndexReference(i));
                    childAccessor.addListener(listener, cis, childPath, executor);
                }
                ++i;
            }
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        RecordInterestSet is = (RecordInterestSet)e.interestSet;
        if (is.componentInterests != null) {
            int i = 0;
            while (i < this.count()) {
                JavaObject sa;
                InterestSet cis = is.getComponentInterest(i);
                if (cis != null && (sa = this.getExistingAccessor(i)) != null) {
                    sa.removeListener(listener);
                }
                ++i;
            }
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            String fieldName = lr.label;
            Integer index = this.type().getComponentIndex(fieldName);
            if (index == null) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            JavaObject sa = (JavaObject)this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = (JavaObject)sa.getComponent(reference.getChildReference());
            }
            return (T)sa;
        }
        if (reference instanceof IndexReference) {
            IndexReference ref = (IndexReference)reference;
            int index = ref.getIndex();
            JavaObject sa = (JavaObject)this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = (JavaObject)sa.getComponent(reference.getChildReference());
            }
            return (T)sa;
        }
        if (reference instanceof NameReference) {
            NameReference ref = (NameReference)reference;
            String fieldName = ref.getName();
            Integer index = this.type().getComponentIndex(fieldName);
            if (index == null) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            JavaObject sa = (JavaObject)this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = (JavaObject)sa.getComponent(reference.getChildReference());
            }
            return (T)sa;
        }
        throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a subreference of RecordType");
    }

    @Override
    public void setValue(Binding binding, Object newValue) throws AccessorException {
        this.writeLock();
        try {
            try {
                RecordBinding rb = (RecordBinding)binding;
                int i = 0;
                while (i < this.count()) {
                    Binding componentBinding = rb.getComponentBinding(i);
                    Object componentValue = rb.getComponent(newValue, i);
                    this.setFieldValue(i, componentBinding, componentValue);
                    ++i;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ValueAssigned rollback = null;
        if (makeRollback) {
            rollback = new ValueAssigned(this.getBinding(), this.getValue(this.getBinding()));
        }
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            this.setValue(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Record Type");
    }
}

