/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.annotations.Optional;

public class RecordInterestSet
extends InterestSet {
    public boolean notification;
    @Optional
    public boolean[] notifications;
    public boolean value;
    @Optional
    public boolean[] values;
    @Optional
    public InterestSet[] componentInterests;

    public RecordInterestSet(boolean notification, boolean[] specificNotifications, boolean value, boolean[] specificValues, InterestSet[] componentInterests) {
        this.notification = notification;
        this.notifications = specificNotifications;
        this.value = value;
        this.values = specificValues;
        this.componentInterests = componentInterests;
    }

    @Override
    public boolean inNotifications() {
        return this.notification | this.value;
    }

    public boolean inNotificationsOf(int fieldIndex) {
        if (this.notification || this.value) {
            return true;
        }
        if (this.notifications != null && this.notifications[fieldIndex]) {
            return true;
        }
        if (this.values != null && this.values[fieldIndex]) {
            return true;
        }
        if (this.componentInterests != null) {
            InterestSet compositeInterest = this.componentInterests[fieldIndex];
            return compositeInterest != null;
        }
        return false;
    }

    @Override
    public boolean inValues() {
        return this.value;
    }

    public boolean inValuesOf(int fieldIndex) {
        if (this.value) {
            return true;
        }
        if (this.values != null && this.values[fieldIndex]) {
            return true;
        }
        if (this.componentInterests != null) {
            InterestSet compositeInterest = this.componentInterests[fieldIndex];
            return compositeInterest != null;
        }
        return false;
    }

    public InterestSet getComponentInterest(int fieldIndex) {
        if (this.componentInterests == null) {
            return null;
        }
        return this.componentInterests[fieldIndex];
    }

    public boolean inComponentNotifications() {
        return this.notifications != null && this.notifications.length > 0 || this.values != null && this.values.length > 0 || this.componentInterests != null && this.componentInterests.length > 0;
    }
}

