/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.charts.commandlog.NewChartItemCommand;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.preference.ChartPreferences;
import org.simantics.charts.query.ChartItemDescriptor;
import org.simantics.charts.query.NextChartItemIndexQuery;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;

public class AddChartItem
extends WriteResultRequest<Collection<Resource>> {
    Resource chart;
    Collection<ChartItemDescriptor> items;
    public Resource chartItem;

    public AddChartItem(Resource chart, Collection<ChartItemDescriptor> items) {
        this.chart = chart;
        this.items = items;
    }

    public Collection<Resource> perform(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        int nextIndex = (Integer)graph.sync((ReadInterface)new NextChartItemIndexQuery(this.chart));
        ArrayList<Resource> result = new ArrayList<Resource>();
        block0: for (ChartItemDescriptor desc : this.items) {
            Object scale;
            Resource chartItem2;
            if (desc.subscriptionItem == null) continue;
            for (Resource chartItem2 : (Collection)graph.syncRequest((Read)Queries.objectsWithType((Resource)this.chart, (Resource)L0.ConsistsOf, (Resource)CHART.Chart_Item))) {
                Resource rdm;
                Resource subscriptionItem = graph.getPossibleObject(chartItem2, CHART.Chart_Item_HasSubscriptionItem);
                if (!desc.subscriptionItem.equals(subscriptionItem)) continue;
                if (desc.index == null) continue block0;
                graph.claimLiteral(chartItem2, CHART.Chart_Item_Index, (Object)desc.index);
                if (desc.min != null) {
                    graph.claimLiteral(chartItem2, CHART.Chart_Item_ScaleMode_Min, (Object)desc.min, (Binding)Bindings.DOUBLE);
                }
                if (desc.max != null) {
                    graph.claimLiteral(chartItem2, CHART.Chart_Item_ScaleMode_Max, (Object)desc.max, (Binding)Bindings.DOUBLE);
                }
                if (desc.renderer != null) {
                    graph.claim(chartItem2, CHART.Chart_Item_Renderer, AddChartItem.getRenderer((ReadGraph)graph, desc.renderer));
                }
                if (desc.subscriptionItem != null) {
                    graph.claim(chartItem2, CHART.Chart_Item_HasSubscriptionItem, desc.subscriptionItem);
                }
                if ((rdm = AddChartItem.getDrawmode((ReadGraph)graph, desc.drawMode)) == null) continue block0;
                graph.claim(chartItem2, CHART.Chart_Item_DrawMode, rdm);
                continue block0;
            }
            chartItem2 = graph.newResource();
            graph.claim(chartItem2, L0.InstanceOf, null, CHART.Chart_Item);
            graph.claim(this.chart, L0.ConsistsOf, chartItem2);
            graph.claimLiteral(chartItem2, L0.HasName, (Object)desc.name, (Binding)Bindings.STRING);
            graph.claim(chartItem2, CHART.Chart_Item_HasSubscriptionItem, desc.subscriptionItem);
            graph.claim(chartItem2, CHART.Chart_Item_Renderer, AddChartItem.getRenderer((ReadGraph)graph, desc.renderer));
            int index = desc.index != null ? desc.index : nextIndex++;
            graph.claimLiteral(chartItem2, CHART.Chart_Item_Index, (Object)index);
            if (desc.strokeWidth != null) {
                graph.claimLiteral(chartItem2, G2DResource.getInstance((ReadGraph)graph).HasStrokeWidth, (Object)desc.strokeWidth, (Binding)Bindings.FLOAT);
            }
            if (desc.color != null) {
                graph.claimLiteral(chartItem2, G2DResource.getInstance((ReadGraph)graph).HasColor, (Object)desc.color, (Binding)Bindings.FLOAT_ARRAY);
            }
            IEclipsePreferences pn = InstanceScope.INSTANCE.getNode("org.simantics.charts");
            String sdm = pn.get("chart.drawmode", ChartPreferences.DEFAULT_DRAWMODE);
            TrendItem.DrawMode dm = desc.drawMode != null ? desc.drawMode : TrendItem.DrawMode.valueOf((String)sdm);
            Resource rdm = AddChartItem.getDrawmode((ReadGraph)graph, dm);
            if (rdm != null) {
                graph.claim(chartItem2, CHART.Chart_Item_DrawMode, rdm);
            }
            if ((scale = desc.scale) == null) {
                String sdm2 = pn.get("chart.scalemode", "Auto");
                scale = sdm2.equals("Auto") ? new Scale.Auto() : new Scale.Manual(0.0, 100.0);
            }
            if (scale instanceof Scale.Auto) {
                Resource r = CHART.ScaleMode_AutoScale;
                graph.claim(chartItem2, CHART.Chart_Item_ScaleMode, r);
            } else {
                graph.claim(chartItem2, CHART.Chart_Item_ScaleMode, CHART.ScaleMode_ManualScale);
            }
            if (desc.min != null) {
                graph.claimLiteral(chartItem2, CHART.Chart_Item_ScaleMode_Min, (Object)desc.min, (Binding)Bindings.DOUBLE);
            }
            if (desc.max != null) {
                graph.claimLiteral(chartItem2, CHART.Chart_Item_ScaleMode_Max, (Object)desc.max, (Binding)Bindings.DOUBLE);
            }
            this.chartItem = chartItem2;
            result.add(chartItem2);
            if (Commands.isRecording()) {
                Commands.record((Object)graph, (Command)new NewChartItemCommand(chartItem2, this.chart, desc.subscriptionItem));
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Added chart item " + String.valueOf(chartItem2)));
        }
        return result;
    }

    public static Resource getDrawmode(ReadGraph graph, TrendItem.DrawMode dm) {
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        if (dm == TrendItem.DrawMode.Average) {
            return CHART.DrawMode_Average;
        }
        if (dm == TrendItem.DrawMode.Sample) {
            return CHART.DrawMode_Sample;
        }
        if (dm == TrendItem.DrawMode.Line) {
            return CHART.DrawMode_Line;
        }
        if (dm == TrendItem.DrawMode.Deviation) {
            return CHART.DrawMode_Deviation;
        }
        if (dm == TrendItem.DrawMode.DeviationAndAverage) {
            return CHART.DrawMode_DeviationAndAverage;
        }
        if (dm == TrendItem.DrawMode.DeviationAndLine) {
            return CHART.DrawMode_DeviationAndLine;
        }
        if (dm == TrendItem.DrawMode.DeviationAndSample) {
            return CHART.DrawMode_DeviationAndSample;
        }
        return null;
    }

    public static Resource getRenderer(ReadGraph graph, TrendItem.Renderer renderer) {
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        switch (renderer) {
            case Analog: {
                return CHART.Renderer_Analog;
            }
            case Binary: {
                return CHART.Renderer_Binary;
            }
        }
        throw new UnsupportedOperationException("invalid renderer: " + String.valueOf(renderer));
    }

    public static ChartItemDescriptor createDescriptor(ReadGraph graph, Resource subscriptionItem) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ChartItemDescriptor desc = new ChartItemDescriptor();
        desc.subscriptionItem = subscriptionItem;
        Datatype datatype = (Datatype)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Datatype, Bindings.getBindingUnchecked(Datatype.class));
        desc.renderer = datatype instanceof BooleanType ? TrendItem.Renderer.Binary : TrendItem.Renderer.Analog;
        return desc;
    }

    public static WriteResult<Collection<Resource>> addAndMoveChartItems(final Resource chart, final List<ChartItemDescriptor> references, final Set<Resource> movedPlots) {
        return new WriteResultRequest<Collection<Resource>>(){

            public Collection<Resource> perform(WriteGraph graph) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>();
                result.addAll((Collection<Resource>)new AddChartItem(chart, references).perform(graph));
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource plot : movedPlots) {
                    graph.deny(plot, L0.PartOf);
                    graph.claim(chart, L0.ConsistsOf, plot);
                    result.add(plot);
                }
                return result;
            }
        };
    }
}

